/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.internal.InternalClientManager;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.ClientMessage;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientManagerFacadeImpl
extends ClientManagerFacade
implements InternalClientManager {
    private final Log _log;
    private ClientManager _manager;
    private final RouterContext _context;
    public static final String PROP_CLIENT_PORT = "i2cp.port";
    public static final int DEFAULT_PORT = 7654;
    public static final String PROP_CLIENT_HOST = "i2cp.hostname";
    public static final String DEFAULT_HOST = "127.0.0.1";
    private static final long MAX_TIME_TO_REBUILD = 600000L;

    public ClientManagerFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientManagerFacadeImpl.class);
    }

    @Override
    public void startup() {
        this._log.info("Starting up the client subsystem");
        int port = this._context.getProperty(PROP_CLIENT_PORT, 7654);
        this._manager = new ClientManager(this._context, port);
    }

    @Override
    public void shutdown() {
        this.shutdown("Router shutdown");
    }

    @Override
    public void shutdown(String msg) {
        if (this._manager != null) {
            this._manager.shutdown(msg);
        }
    }

    @Override
    public void restart() {
        if (this._manager != null) {
            this._manager.restart();
        } else {
            this.startup();
        }
    }

    @Override
    public boolean isAlive() {
        return this._manager != null && this._manager.isAlive();
    }

    @Override
    public boolean verifyClientLiveliness() {
        if (this._manager == null) {
            return true;
        }
        boolean lively = true;
        for (Destination dest : this._manager.getRunnerDestinations()) {
            long howLongAgo;
            LeaseSet ls;
            ClientConnectionRunner runner = this._manager.getRunner(dest);
            if (runner == null || runner.getIsDead() || (ls = runner.getLeaseSet()) == null || (howLongAgo = this._context.clock().now() - ls.getEarliestLeaseDate()) <= 600000L) continue;
            if (this._log.shouldLog(40)) {
                this._log.error("Client " + dest.calculateHash().toBase64().substring(0, 6) + " has a leaseSet that expired " + DataHelper.formatDuration((long)howLongAgo));
            }
            lively = false;
        }
        return lively;
    }

    @Override
    public void requestLeaseSet(Destination dest, LeaseSet set, long timeout, Job onCreateJob, Job onFailedJob) {
        if (this._manager != null) {
            this._manager.requestLeaseSet(dest, set, timeout, onCreateJob, onFailedJob);
        } else {
            this._log.error("Null manager on requestLeaseSet!");
        }
    }

    @Override
    public void requestLeaseSet(Hash dest, LeaseSet set) {
        if (this._manager != null) {
            this._manager.requestLeaseSet(dest, set);
        }
    }

    @Override
    public void reportAbuse(Destination dest, String reason, int severity) {
        if (this._manager != null) {
            this._manager.reportAbuse(dest, reason, severity);
        } else {
            this._log.error("Null manager on reportAbuse!");
        }
    }

    @Override
    public boolean isLocal(Destination dest) {
        if (this._manager != null) {
            return this._manager.isLocal(dest);
        }
        this._log.debug("Null manager on isLocal(dest)!");
        return false;
    }

    @Override
    public boolean isLocal(Hash destHash) {
        if (this._manager != null) {
            return this._manager.isLocal(destHash);
        }
        this._log.debug("Null manager on isLocal(hash)!");
        return false;
    }

    @Override
    public boolean shouldPublishLeaseSet(Hash destinationHash) {
        return this._manager.shouldPublishLeaseSet(destinationHash);
    }

    @Override
    public void messageDeliveryStatusUpdate(Destination fromDest, MessageId id, boolean delivered) {
        if (this._manager != null) {
            this._manager.messageDeliveryStatusUpdate(fromDest, id, delivered);
        } else {
            this._log.error("Null manager on messageDeliveryStatusUpdate!");
        }
    }

    @Override
    public void messageReceived(ClientMessage msg) {
        if (this._manager != null) {
            this._manager.messageReceived(msg);
        } else {
            this._log.error("Null manager on messageReceived!");
        }
    }

    @Override
    public SessionConfig getClientSessionConfig(Destination dest) {
        if (this._manager != null) {
            return this._manager.getClientSessionConfig(dest);
        }
        this._log.error("Null manager on getClientSessionConfig!");
        return null;
    }

    @Override
    public SessionKeyManager getClientSessionKeyManager(Hash dest) {
        if (this._manager != null) {
            return this._manager.getClientSessionKeyManager(dest);
        }
        this._log.error("Null manager on getClientSessionKeyManager!");
        return null;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        if (this._manager != null) {
            this._manager.renderStatusHTML(out);
        }
    }

    @Override
    public Set<Destination> listClients() {
        if (this._manager != null) {
            return this._manager.listClients();
        }
        return Collections.EMPTY_SET;
    }

    public I2CPMessageQueue connect() throws I2PSessionException {
        if (this._manager != null) {
            return this._manager.internalConnect();
        }
        throw new I2PSessionException("No manager yet");
    }
}

