/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.RouterThrottle;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class RouterThrottleImpl
implements RouterThrottle {
    protected final RouterContext _context;
    private final Log _log;
    private String _tunnelStatus;
    private static int JOB_LAG_LIMIT = 2000;
    private static final String PROP_MAX_TUNNELS = "router.maxParticipatingTunnels";
    private static final int DEFAULT_MAX_TUNNELS = 5000;
    private static final String PROP_MAX_PROCESSINGTIME = "router.defaultProcessingTimeThrottle";
    private static final int DEFAULT_MAX_PROCESSINGTIME = 2250;
    public static final int TUNNEL_ACCEPT = 0;
    private static final int PREPROCESSED_SIZE = 1024;
    private static final long REJECT_STARTUP_TIME = 1200000L;
    private static final int DEFAULT_MESSAGES_PER_TUNNEL_ESTIMATE = 40;
    private static final int MIN_AVAILABLE_BPS = 4096;
    private static final String LIMIT_STR = RouterThrottleImpl._x("Rejecting tunnels: Bandwidth limit");

    public RouterThrottleImpl(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(RouterThrottleImpl.class);
        this.setTunnelStatus();
        this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new ResetStatus(), 1320000L);
        this._context.statManager().createRateStat("router.throttleNetworkCause", "How lagged the jobQueue was when an I2NP was throttled", "Throttle", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.bytesAllocatedAtAccept", "How many bytes had been 'allocated' for participating tunnels when we accepted a request?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelProcessingTime1m", "How long it takes to process a message (1 minute average) when we throttle a tunnel?", "Throttle", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelProcessingTime10m", "How long it takes to process a message (10 minute average) when we throttle a tunnel?", "Throttle", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelMaxExceeded", "How many tunnels we are participating in when we refuse one due to excees?", "Throttle", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelProbTooFast", "How many tunnels beyond the previous 1h average are we participating in when we throttle?", "Throttle", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelBandwidthExceeded", "How much bandwidth is allocated when we refuse due to bandwidth allocation?", "Throttle", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelBytesAllowed", "How many bytes are allowed to be sent when we get a tunnel request (period is how many are currently allocated)?", "Throttle", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelBytesUsed", "Used Bps at request (period = max KBps)?", "Throttle", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("router.throttleTunnelFailCount1m", "How many messages failed to be sent in the last 2 minutes when we throttle based on a spike in failures (period = 10 minute average failure count)?", "Throttle", new long[]{60000L, 600000L, 3600000L});
    }

    public boolean acceptNetworkMessage() {
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > (long)JOB_LAG_LIMIT && this._context.router().getUptime() > 60000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Throttling network reader, as the job lag is " + lag);
            }
            this._context.statManager().addRateData("router.throttleNetworkCause", lag, lag);
            return false;
        }
        return true;
    }

    public boolean acceptNetDbLookupRequest(Hash key) {
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > (long)JOB_LAG_LIMIT) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Refusing netDb request, as the job lag is " + lag);
            }
            this._context.statManager().addRateData("router.throttleNetDbCause", lag, lag);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int acceptTunnelRequest() {
        double bytesAllocated;
        int maxTunnels;
        int numTunnels;
        Rate r;
        RateStat rs;
        block27: {
            double avg;
            block28: {
                int min;
                if (this._context.getProperty("__shutdownInProgress") != null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Refusing tunnel request since we are shutting down ASAP");
                    }
                    this.setShutdownStatus();
                    return 30;
                }
                if (this._context.router().getUptime() < 1200000L) {
                    this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels: Starting up"));
                    return 30;
                }
                rs = this._context.statManager().getRate("transport.sendProcessingTime");
                r = null;
                if (rs != null) {
                    r = rs.getRate(60000L);
                }
                if (r != null) {
                    double totalSendProcessingTimeEvents = r.getCurrentEventCount() + r.getLastEventCount();
                    double avgSendProcessingTime = 0.0;
                    double currentSendProcessingTime = 0.0;
                    double lastSendProcessingTime = 0.0;
                    if (r.getCurrentEventCount() > 0L) {
                        currentSendProcessingTime = r.getCurrentTotalValue() / (double)r.getCurrentEventCount();
                    }
                    if (r.getLastEventCount() > 0L) {
                        lastSendProcessingTime = r.getLastTotalValue() / (double)r.getLastEventCount();
                    }
                    if (totalSendProcessingTimeEvents > 0.0) {
                        avgSendProcessingTime = (r.getCurrentTotalValue() + r.getLastTotalValue()) / totalSendProcessingTimeEvents;
                    } else {
                        avgSendProcessingTime = r.getAverageValue();
                        if (this._log.shouldLog(30)) {
                            this._log.warn("No events occurred. Using 1 minute average to look at message delay.");
                        }
                    }
                    int maxProcessingTime = this._context.getProperty(PROP_MAX_PROCESSINGTIME, 2250);
                    if (avgSendProcessingTime > (double)maxProcessingTime * 0.9 || currentSendProcessingTime > (double)maxProcessingTime || lastSendProcessingTime > (double)maxProcessingTime) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Refusing tunnel request due to sendProcessingTime of " + avgSendProcessingTime + " ms over the last two minutes, which is too much.");
                        }
                        this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels: High message delay"));
                        return 30;
                    }
                }
                numTunnels = this._context.tunnelManager().getParticipatingCount();
                maxTunnels = this._context.getProperty(PROP_MAX_TUNNELS, 5000);
                if (numTunnels <= this.getMinThrottleTunnels() || 5000 > maxTunnels) break block27;
                double tunnelGrowthFactor = this.getTunnelGrowthFactor();
                Rate avgTunnels = this._context.statManager().getRate("tunnel.participatingTunnels").getRate(600000L);
                if (avgTunnels == null) break block27;
                avg = 0.0;
                avg = avgTunnels.getLastEventCount() > 0L ? avgTunnels.getAverageValue() : avgTunnels.getLifetimeAverageValue();
                if (avg < (double)(min = this.getMinThrottleTunnels())) {
                    avg = min;
                }
                if (!(avg > 0.0) || !(avg * tunnelGrowthFactor < (double)numTunnels)) break block28;
                double probAccept = avg * tunnelGrowthFactor / (double)numTunnels;
                probAccept *= probAccept;
                int v = this._context.random().nextInt(100);
                if ((double)v < probAccept * 100.0) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Probabalistically accept tunnel request (p=" + probAccept + " v=" + v + " avg=" + avg + " current=" + numTunnels + ")");
                    }
                    break block27;
                } else {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Probabalistically refusing tunnel request (avg=" + avg + " current=" + numTunnels + ")");
                    }
                    this._context.statManager().addRateData("router.throttleTunnelProbTooFast", (long)((double)numTunnels - avg), 0L);
                    this.setTunnelStatus(RouterThrottleImpl._x("Rejecting most tunnels: High number of requests"));
                    return 10;
                }
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Accepting tunnel request, since the tunnel count average is " + avg + " and we only have " + numTunnels + ")");
            }
        }
        double tunnelTestTimeGrowthFactor = this.getTunnelTestTimeGrowthFactor();
        Rate tunnelTestTime1m = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(60000L);
        Rate tunnelTestTime10m = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(600000L);
        if (tunnelTestTime1m != null && tunnelTestTime10m != null && tunnelTestTime1m.getLastEventCount() > 0L) {
            double avg1m = tunnelTestTime1m.getAverageValue();
            double avg10m = 0.0;
            avg10m = tunnelTestTime10m.getLastEventCount() > 0L ? tunnelTestTime10m.getAverageValue() : tunnelTestTime10m.getLifetimeAverageValue();
            if (avg10m < 5000.0) {
                avg10m = 5000.0;
            }
            if (avg10m > 0.0 && avg1m > avg10m * tunnelTestTimeGrowthFactor) {
                double probAccept = avg10m * tunnelTestTimeGrowthFactor / avg1m;
                probAccept *= probAccept;
                int v = this._context.random().nextInt(100);
                if ((double)v < probAccept * 100.0 && this._log.shouldLog(20)) {
                    this._log.info("Probabalistically accept tunnel request (p=" + probAccept + " v=" + v + " test time avg 1m=" + avg1m + " 10m=" + avg10m + ")");
                }
            }
        }
        if (numTunnels >= maxTunnels) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Refusing tunnel request since we are already participating in " + numTunnels + " (our max is " + maxTunnels + ")");
            }
            this._context.statManager().addRateData("router.throttleTunnelMaxExceeded", (long)numTunnels, 0L);
            this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels: Limit reached"));
            return 30;
        }
        rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
        r = null;
        double messagesPerTunnel = 40.0;
        if (rs != null && (r = rs.getRate(60000L)) != null) {
            long count = r.getLastEventCount() + r.getCurrentEventCount();
            messagesPerTunnel = count > 0L ? (r.getLastTotalValue() + r.getCurrentTotalValue()) / (double)count : r.getLifetimeAverageValue();
        }
        if (messagesPerTunnel < 40.0) {
            messagesPerTunnel = 40.0;
        }
        if (!this.allowTunnel(bytesAllocated = messagesPerTunnel * (double)numTunnels * 1024.0, numTunnels)) {
            this._context.statManager().addRateData("router.throttleTunnelBandwidthExceeded", (long)bytesAllocated, 0L);
            return 30;
        }
        this._context.statManager().addRateData("tunnel.bytesAllocatedAtAccept", (long)bytesAllocated, 600000L);
        return 0;
    }

    private boolean allowTunnel(double bytesAllocated, int numTunnels) {
        boolean reject;
        int maxKBpsIn = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        int maxKBpsOut = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        int maxKBps = Math.min(maxKBpsIn, maxKBpsOut);
        int usedIn = Math.min(this._context.router().get1sRateIn(), this._context.router().get15sRateIn());
        int usedOut = Math.min(this._context.router().get1sRate(true), this._context.router().get15sRate(true));
        int used = Math.max(usedIn, usedOut);
        int used1mIn = this._context.router().get1mRateIn();
        int used1mOut = this._context.router().get1mRate(true);
        int availBps = Math.min(maxKBpsIn * 1024 * 9 / 10 - usedIn, maxKBpsOut * 1024 * 9 / 10 - usedOut);
        if (availBps < 4096) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Reject, avail (" + availBps + ") less than min");
            }
            this.setTunnelStatus(LIMIT_STR);
            return false;
        }
        double share = this._context.router().getSharePercentage();
        used = Math.min(used, (int)(bytesAllocated / 600.0));
        availBps = Math.min(availBps, (int)((double)(maxKBps * 1024) * share - (double)used));
        this._context.statManager().addRateData("router.throttleTunnelBytesUsed", (long)used, (long)maxKBps);
        this._context.statManager().addRateData("router.throttleTunnelBytesAllowed", (long)availBps, (long)bytesAllocated);
        long overage = Math.max(used1mIn - maxKBpsIn * 1024, used1mOut - maxKBpsOut * 1024);
        if (overage > 0L && (float)overage / ((float)maxKBps * 1024.0f) > this._context.random().nextFloat()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Reject tunnel, 1m rate (" + overage + " over) indicates overload.");
            }
            this.setTunnelStatus(LIMIT_STR);
            return false;
        }
        float maxBps = (float)maxKBps * 1024.0f * 0.9f - 4096.0f;
        float pctFull = (maxBps - (float)availBps) / maxBps;
        double probReject = Math.pow(pctFull, 16.0);
        double rand = this._context.random().nextFloat();
        boolean bl = reject = rand <= probReject;
        if (reject && this._log.shouldLog(30)) {
            this._log.warn("Reject avail/maxK/used " + availBps + "/" + maxKBps + "/" + used + " pReject = " + probReject + " pFull = " + pctFull + " numTunnels = " + numTunnels + " rand = " + rand + " est = " + bytesAllocated);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Accept avail/maxK/used " + availBps + "/" + maxKBps + "/" + used + " pReject = " + probReject + " pFull = " + pctFull + " numTunnels = " + numTunnels + " rand = " + rand + " est = " + bytesAllocated);
        }
        if (probReject >= 0.9) {
            this.setTunnelStatus(LIMIT_STR);
        } else if (probReject >= 0.5) {
            this.setTunnelStatus(RouterThrottleImpl._x("Rejecting most tunnels: Bandwidth limit"));
        } else if (probReject >= 0.1) {
            this.setTunnelStatus(RouterThrottleImpl._x("Accepting most tunnels"));
        } else {
            this.setTunnelStatus(RouterThrottleImpl._x("Accepting tunnels"));
        }
        return !reject;
    }

    private int getMinThrottleTunnels() {
        return this._context.getProperty("router.minThrottleTunnels", 1000);
    }

    private double getTunnelGrowthFactor() {
        try {
            return Double.parseDouble(this._context.getProperty("router.tunnelGrowthFactor", "1.3"));
        }
        catch (NumberFormatException nfe) {
            return 1.3;
        }
    }

    private double getTunnelTestTimeGrowthFactor() {
        try {
            return Double.parseDouble(this._context.getProperty("router.tunnelTestTimeGrowthFactor", "1.3"));
        }
        catch (NumberFormatException nfe) {
            return 1.3;
        }
    }

    public long getMessageDelay() {
        RateStat rs = this._context.statManager().getRate("transport.sendProcessingTime");
        if (rs == null) {
            return 0L;
        }
        Rate delayRate = rs.getRate(60000L);
        return (long)delayRate.getAverageValue();
    }

    public long getTunnelLag() {
        Rate lagRate = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(600000L);
        return (long)lagRate.getAverageValue();
    }

    public double getInboundRateDelta() {
        RateStat receiveRate = this._context.statManager().getRate("transport.sendMessageSize");
        if (receiveRate == null) {
            return 0.0;
        }
        double nowBps = RouterThrottleImpl.getBps(receiveRate.getRate(60000L));
        double fiveMinBps = RouterThrottleImpl.getBps(receiveRate.getRate(300000L));
        double hourBps = RouterThrottleImpl.getBps(receiveRate.getRate(3600000L));
        double dailyBps = RouterThrottleImpl.getBps(receiveRate.getRate(86400000L));
        if (nowBps < 0.0) {
            return 0.0;
        }
        if (dailyBps > 0.0) {
            return nowBps - dailyBps;
        }
        if (hourBps > 0.0) {
            return nowBps - hourBps;
        }
        if (fiveMinBps > 0.0) {
            return nowBps - fiveMinBps;
        }
        return 0.0;
    }

    private static double getBps(Rate rate) {
        if (rate == null) {
            return -1.0;
        }
        double bytes = rate.getLastTotalValue();
        return bytes * 1000.0 / (double)rate.getPeriod();
    }

    public String getTunnelStatus() {
        return this._tunnelStatus;
    }

    private void setTunnelStatus() {
        this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels: Starting up"));
    }

    public void setShutdownStatus() {
        this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels: Shutting down"));
    }

    public void cancelShutdownStatus() {
        this.setTunnelStatus(RouterThrottleImpl._x("Rejecting tunnels"));
    }

    public void setTunnelStatus(String msg) {
        this._tunnelStatus = msg;
    }

    private static final String _x(String s) {
        return s;
    }

    private class ResetStatus
    implements SimpleTimer.TimedEvent {
        private ResetStatus() {
        }

        public void timeReached() {
            if (RouterThrottleImpl.this._tunnelStatus.equals(RouterThrottleImpl._x("Rejecting tunnels: Starting up"))) {
                RouterThrottleImpl.this.cancelShutdownStatus();
            }
        }
    }
}

