/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.irc.DCCClientManager;
import net.i2p.i2ptunnel.irc.DCCHelper;
import net.i2p.i2ptunnel.irc.I2PTunnelDCCServer;
import net.i2p.i2ptunnel.irc.IrcInboundFilter;
import net.i2p.i2ptunnel.irc.IrcOutboundFilter;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;

public class I2PTunnelIRCClient
extends I2PTunnelClientBase {
    private static volatile long __clientId = 0L;
    protected List<Destination> dests;
    private static final long DEFAULT_READ_TIMEOUT = 300000L;
    protected long readTimeout = 300000L;
    private final boolean _dccEnabled;
    private I2PTunnelDCCServer _DCCServer;
    private DCCClientManager _DCCClientManager;
    public static final String PROP_DCC = "i2ptunnel.ircclient.enableDCC";

    public I2PTunnelIRCClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "IRC Client on " + tunnel.listenHost + ':' + localPort + " #" + ++__clientId, tunnel, pkf);
        StringTokenizer tok = new StringTokenizer(destinations, ", ");
        this.dests = new ArrayList<Destination>(2);
        while (tok.hasMoreTokens()) {
            String destination = tok.nextToken();
            Destination destN = this._context.namingService().lookup(destination);
            if (destN == null) {
                l.log("Could not resolve " + destination);
                continue;
            }
            this.dests.add(destN);
        }
        if (this.dests.isEmpty()) {
            l.log("No target destinations found");
            this.notifyEvent("openClientResult", "error");
            throw new IllegalArgumentException("No valid target destinations found");
        }
        this.setName("IRC Client on " + tunnel.listenHost + ':' + localPort);
        this._dccEnabled = Boolean.valueOf(tunnel.getClientOptions().getProperty(PROP_DCC));
        this.startRunning();
        this.notifyEvent("openIRCClientResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientConnectionRun(Socket s) {
        block12: {
            if (this._log.shouldLog(20)) {
                this._log.info("New connection local addr is: " + s.getLocalAddress() + " from: " + s.getInetAddress());
            }
            Destination clientDest = this.pickDestination();
            I2PSocket i2ps = null;
            try {
                i2ps = this.createI2PSocket(clientDest);
                i2ps.setReadTimeout(this.readTimeout);
                StringBuffer expectedPong = new StringBuffer();
                DCC dcc = this._dccEnabled ? new DCC(s.getLocalAddress().getAddress()) : null;
                I2PAppThread in = new I2PAppThread(new IrcInboundFilter(s, i2ps, expectedPong, this._log, dcc), "IRC Client " + __clientId + " in", true);
                in.start();
                I2PAppThread out = new I2PAppThread(new IrcOutboundFilter(s, i2ps, expectedPong, this._log, dcc), "IRC Client " + __clientId + " out", true);
                out.start();
            }
            catch (I2PException ex) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error connecting", ex);
                }
                I2PTunnelIRCClient.closeSocket(s);
                if (i2ps == null) break block12;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
            catch (Exception ex) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error connecting", ex);
                }
                I2PTunnelIRCClient.closeSocket(s);
                if (i2ps == null) break block12;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
        }
    }

    private final Destination pickDestination() {
        int size = this.dests.size();
        if (size <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("No client targets?!");
            }
            return null;
        }
        if (size == 1) {
            return this.dests.get(0);
        }
        int index = this._context.random().nextInt(size);
        return this.dests.get(index);
    }

    public void startRunning() {
        super.startRunning();
        this._context.portMapper().register("irc", this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        int reg = this._context.portMapper().getPort("irc");
        if (reg == this.getLocalPort()) {
            this._context.portMapper().unregister("irc");
        }
        I2PTunnelIRCClient i2PTunnelIRCClient = this;
        synchronized (i2PTunnelIRCClient) {
            if (this._DCCServer != null) {
                this._DCCServer.close(forced);
                this._DCCServer = null;
            }
            if (this._DCCClientManager != null) {
                this._DCCClientManager.close(forced);
                this._DCCClientManager = null;
            }
        }
        return super.close(forced);
    }

    private class DCC
    implements DCCHelper {
        private final byte[] _localAddr;

        public DCC(byte[] local) {
            this._localAddr = local.length == 4 ? local : new byte[]{127, 0, 0, 1};
        }

        public boolean isEnabled() {
            return I2PTunnelIRCClient.this._dccEnabled;
        }

        public String getB32Hostname() {
            return Base32.encode(I2PTunnelIRCClient.this.sockMgr.getSession().getMyDestination().calculateHash().getData()) + ".b32.i2p";
        }

        public byte[] getLocalAddress() {
            return this._localAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int newOutgoing(byte[] ip, int port, String type) {
            I2PTunnelDCCServer server;
            DCC dCC = this;
            synchronized (dCC) {
                if (I2PTunnelIRCClient.this._DCCServer == null) {
                    if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                        I2PTunnelIRCClient.this._log.info("Starting DCC Server");
                    }
                    I2PTunnelIRCClient.this._DCCServer = new I2PTunnelDCCServer(I2PTunnelIRCClient.this.sockMgr, I2PTunnelIRCClient.this.l, I2PTunnelIRCClient.this, I2PTunnelIRCClient.this.getTunnel());
                    I2PTunnelIRCClient.this._DCCServer.startRunning();
                }
                server = I2PTunnelIRCClient.this._DCCServer;
            }
            int rv = server.newOutgoing(ip, port, type);
            if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                I2PTunnelIRCClient.this._log.info("New outgoing " + type + ' ' + port + " returns " + rv);
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int newIncoming(String b32, int port, String type) {
            DCCClientManager tracker;
            DCC dCC = this;
            synchronized (dCC) {
                if (I2PTunnelIRCClient.this._DCCClientManager == null) {
                    if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                        I2PTunnelIRCClient.this._log.info("Starting DCC Client");
                    }
                    I2PTunnelIRCClient.this._DCCClientManager = new DCCClientManager(I2PTunnelIRCClient.this.sockMgr, I2PTunnelIRCClient.this.l, I2PTunnelIRCClient.this, I2PTunnelIRCClient.this.getTunnel());
                }
                tracker = I2PTunnelIRCClient.this._DCCClientManager;
            }
            int rv = tracker.newIncoming(b32, port, type);
            if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                I2PTunnelIRCClient.this._log.info("New incoming " + type + ' ' + b32 + ' ' + port + " returns " + rv);
            }
            return rv;
        }

        public int resumeOutgoing(int port) {
            DCCClientManager tracker = I2PTunnelIRCClient.this._DCCClientManager;
            if (tracker != null) {
                return tracker.resumeOutgoing(port);
            }
            return -1;
        }

        public int resumeIncoming(int port) {
            I2PTunnelDCCServer server = I2PTunnelIRCClient.this._DCCServer;
            if (server != null) {
                return server.resumeIncoming(port);
            }
            return -1;
        }

        public int acceptOutgoing(int port) {
            I2PTunnelDCCServer server = I2PTunnelIRCClient.this._DCCServer;
            if (server != null) {
                return server.acceptOutgoing(port);
            }
            return -1;
        }

        public int acceptIncoming(int port) {
            DCCClientManager tracker = I2PTunnelIRCClient.this._DCCClientManager;
            if (tracker != null) {
                return tracker.acceptIncoming(port);
            }
            return -1;
        }
    }
}

