/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Base64;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.InternalSocket;

public abstract class I2PTunnelHTTPClientBase
extends I2PTunnelClientBase
implements Runnable {
    protected final List<String> _proxyList = new ArrayList<String>(4);
    protected static final byte[] ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel".getBytes();
    protected static volatile long __clientId = 0L;
    protected static final File _errorDir = new File(I2PAppContext.getGlobalContext().getBaseDir(), "docs");
    protected static final int DEFAULT_READ_TIMEOUT = 300000;
    protected static long __requestId = 0L;
    public static final String PROP_AUTH = "proxyAuth";
    public static final String PROP_USER = "proxyUsername";
    public static final String PROP_PW = "proxyPassword";
    public static final String PROP_PW_PREFIX = "proxyPassword.";
    public static final String PROP_OUTPROXY_AUTH = "outproxyAuth";
    public static final String PROP_OUTPROXY_USER = "outproxyUsername";
    public static final String PROP_OUTPROXY_PW = "outproxyPassword";
    public static final String PROP_OUTPROXY_USER_PREFIX = "outproxyUsername.";
    public static final String PROP_OUTPROXY_PW_PREFIX = "outproxyPassword.";

    protected String getPrefix(long requestId) {
        return "Client[" + this._clientId + "/" + requestId + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectProxy() {
        List<String> list = this._proxyList;
        synchronized (list) {
            int size = this._proxyList.size();
            if (size <= 0) {
                return null;
            }
            int index = this._context.random().nextInt(size);
            return this._proxyList.get(index);
        }
    }

    public I2PTunnelHTTPClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, handlerName, tunnel);
    }

    public I2PTunnelHTTPClientBase(int localPort, Logging l, I2PSocketManager sktMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) throws IllegalArgumentException {
        super(localPort, l, sktMgr, tunnel, notifyThis, clientId);
    }

    protected boolean authorize(Socket s, long requestId, String authorization) {
        String authRequired = this.getTunnel().getClientOptions().getProperty(PROP_AUTH);
        if (Boolean.valueOf(authRequired).booleanValue() || authRequired != null && "basic".equals(authRequired.toLowerCase(Locale.US))) {
            block17: {
                if (s instanceof InternalSocket) {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getPrefix(requestId) + "Internal access, no auth required");
                    }
                    return true;
                }
                if (authorization != null) {
                    byte[] decoded = Base64.decode(authorization.replace("/", "~").replace("+", "="));
                    if (decoded != null) {
                        try {
                            String configUser;
                            String dec = new String(decoded, "UTF-8");
                            String[] parts = dec.split(":");
                            String user = parts[0];
                            String pw = parts[1];
                            String configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW_PREFIX + user);
                            if (configPW == null && user.equals(configUser = this.getTunnel().getClientOptions().getProperty(PROP_USER))) {
                                configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW);
                            }
                            if (configPW != null) {
                                if (pw.equals(configPW)) {
                                    if (this._log.shouldLog(20)) {
                                        this._log.info(this.getPrefix(requestId) + "Good auth - user: " + user + " pw: " + pw);
                                    }
                                    return true;
                                }
                                if (this._log.shouldLog(30)) {
                                    this._log.warn(this.getPrefix(requestId) + "Bad auth, pw mismatch - user: " + user + " pw: " + pw + " expected: " + configPW);
                                }
                            } else if (this._log.shouldLog(30)) {
                                this._log.warn(this.getPrefix(requestId) + "Bad auth, no stored pw for user: " + user + " pw: " + pw);
                            }
                            break block17;
                        }
                        catch (UnsupportedEncodingException uee) {
                            this._log.error(this.getPrefix(requestId) + "No UTF-8 support? B64: " + authorization, uee);
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization, aioobe);
                            }
                            break block17;
                        }
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization);
                    }
                }
            }
            return false;
        }
        return true;
    }
}

