/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMHandlerFactory;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class SAMBridge
implements Runnable {
    private static final Log _log = new Log(SAMBridge.class);
    private final ServerSocketChannel serverSocket;
    private final Properties i2cpProps;
    private final String persistFilename;
    private final Map<String, String> nameToPrivKeys;
    private volatile boolean acceptConnections = true;
    private static final int SAM_LISTENPORT = 7656;
    public static final String DEFAULT_SAM_KEYFILE = "sam.keys";
    public static final String PROP_TCP_HOST = "sam.tcp.host";
    public static final String PROP_TCP_PORT = "sam.tcp.port";
    protected static final String DEFAULT_TCP_HOST = "0.0.0.0";
    protected static final String DEFAULT_TCP_PORT = "7656";
    public static final String PROP_DATAGRAM_HOST = "sam.udp.host";
    public static final String PROP_DATAGRAM_PORT = "sam.udp.port";
    protected static final String DEFAULT_DATAGRAM_HOST = "0.0.0.0";
    protected static final String DEFAULT_DATAGRAM_PORT = "7655";

    public SAMBridge(String listenHost, int listenPort, Properties i2cpProps, String persistFile) {
        this.persistFilename = persistFile;
        this.nameToPrivKeys = new HashMap<String, String>(8);
        this.loadKeys();
        try {
            if (listenHost != null && !"0.0.0.0".equals(listenHost)) {
                this.serverSocket = ServerSocketChannel.open();
                this.serverSocket.socket().bind(new InetSocketAddress(listenHost, listenPort));
                if (_log.shouldLog(10)) {
                    _log.debug("SAM bridge listening on " + listenHost + ":" + listenPort);
                }
            } else {
                this.serverSocket = ServerSocketChannel.open();
                this.serverSocket.socket().bind(new InetSocketAddress(listenPort));
                if (_log.shouldLog(10)) {
                    _log.debug("SAM bridge listening on 0.0.0.0:" + listenPort);
                }
            }
        }
        catch (Exception e) {
            if (_log.shouldLog(40)) {
                _log.error("Error starting SAM bridge on " + (listenHost == null ? "0.0.0.0" : listenHost) + ":" + listenPort, e);
            }
            throw new RuntimeException(e);
        }
        this.i2cpProps = i2cpProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(String name) {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            String val = this.nameToPrivKeys.get(name);
            if (val == null) {
                return null;
            }
            try {
                Destination d = new Destination();
                d.fromBase64(val);
                return d;
            }
            catch (DataFormatException dfe) {
                _log.error("Error retrieving the destination from " + name, dfe);
                this.nameToPrivKeys.remove(name);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeystream(String name) {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            String val = this.nameToPrivKeys.get(name);
            if (val == null) {
                return null;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeystream(String name, String stream) {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.put(name, stream);
        }
        this.storeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeys() {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.clear();
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.persistFilename);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int eq = line.indexOf(61);
                    String name = line.substring(0, eq);
                    String privKeys = line.substring(eq + 1);
                    this.nameToPrivKeys.put(name, privKeys);
                }
            }
            catch (FileNotFoundException fnfe) {
                _log.warn("Key file does not exist at " + this.persistFilename);
            }
            catch (IOException ioe) {
                _log.error("Unable to read the keys from " + this.persistFilename, ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeKeys() {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.persistFilename);
                for (String name : this.nameToPrivKeys.keySet()) {
                    String privKeys = this.nameToPrivKeys.get(name);
                    out.write(name.getBytes());
                    out.write(61);
                    out.write(privKeys.getBytes());
                    out.write(10);
                }
            }
            catch (IOException ioe) {
                _log.error("Error writing out the SAM keys to " + this.persistFilename, ioe);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] args) {
        String keyfile = DEFAULT_SAM_KEYFILE;
        int port = 7656;
        String host = "0.0.0.0";
        Properties opts = null;
        if (args.length > 0) {
            try {
                opts = SAMBridge.parseOptions(args, 0);
                keyfile = args[0];
                int portIndex = 1;
                try {
                    if (args.length > portIndex) {
                        port = Integer.parseInt(args[portIndex]);
                    }
                }
                catch (NumberFormatException nfe) {
                    host = args[portIndex];
                    ++portIndex;
                    try {
                        if (args.length > portIndex) {
                            port = Integer.parseInt(args[portIndex]);
                        }
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            port = Integer.parseInt(opts.getProperty(PROP_TCP_PORT, DEFAULT_TCP_PORT));
                            host = opts.getProperty(PROP_TCP_HOST, "0.0.0.0");
                        }
                        catch (NumberFormatException e) {
                            SAMBridge.usage();
                            return;
                        }
                    }
                }
            }
            catch (HelpRequested e) {
                SAMBridge.usage();
                return;
            }
        }
        SAMBridge bridge = new SAMBridge(host, port, opts, keyfile);
        I2PAppThread t = new I2PAppThread(bridge, "SAMListener");
        if (Boolean.valueOf(System.getProperty("sam.shutdownOnOOM", "false")).booleanValue()) {
            t.addOOMEventThreadListener(new I2PThread.OOMEventListener(){

                public void outOfMemory(OutOfMemoryError err) {
                    err.printStackTrace();
                    System.err.println("OOMed, die die die");
                    System.exit(-1);
                }
            });
        }
        t.start();
    }

    private static Properties parseOptions(String[] args, int startArgs) throws HelpRequested {
        Properties props = new Properties();
        for (int i = startArgs; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                throw new HelpRequested();
            }
            int eq = args[i].indexOf(61);
            if (eq <= 0 || eq >= args[i].length() - 1) continue;
            String key = args[i].substring(0, eq);
            String val = args[i].substring(eq + 1);
            key = key.trim();
            val = val.trim();
            if (key.length() <= 0 || val.length() <= 0) continue;
            props.setProperty(key, val);
        }
        return props;
    }

    private static void usage() {
        System.err.println("Usage: SAMBridge [keyfile [listenHost] listenPortNum[ name=val]*]");
        System.err.println("or:");
        System.err.println("       SAMBridge [ name=val ]*");
        System.err.println(" keyfile: location to persist private keys (default sam.keys)");
        System.err.println(" listenHost: interface to listen on (0.0.0.0 for all interfaces)");
        System.err.println(" listenPort: port to listen for SAM connections on (default 7656)");
        System.err.println(" name=val: options to pass when connecting via I2CP, such as ");
        System.err.println("           i2cp.host=localhost and i2cp.port=7654");
        System.err.println("");
        System.err.println("Host and ports of the SAM bridge can be specified with the alternate");
        System.err.println("form by specifying options sam.tcp.host and/or sam.tcp.port");
        System.err.println("");
        System.err.println("Options sam.udp.host and sam.udp.port specify the listening ip");
        System.err.println("range and the port of SAM datagram server. This server is");
        System.err.println("only launched after a client creates the first SAM datagram");
        System.err.println("or raw session, after a handshake with SAM version >= 3.0.");
        System.err.println("");
        System.err.println("The option loglevel=[DEBUG|WARN|ERROR|CRIT] can be used");
        System.err.println("for tuning the log verbosity.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            while (this.acceptConnections) {
                SocketChannel s = this.serverSocket.accept();
                if (_log.shouldLog(10)) {
                    _log.debug("New connection from " + s.socket().getInetAddress().toString() + ":" + s.socket().getPort());
                }
                class HelloHandler
                implements Runnable {
                    SocketChannel s;
                    SAMBridge parent;

                    HelloHandler(SocketChannel s, SAMBridge parent) {
                        this.s = s;
                        this.parent = parent;
                    }

                    public void run() {
                        try {
                            SAMHandler handler = SAMHandlerFactory.createSAMHandler(this.s, SAMBridge.this.i2cpProps);
                            if (handler == null) {
                                if (_log.shouldLog(10)) {
                                    _log.debug("SAM handler has not been instantiated");
                                }
                                try {
                                    this.s.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                return;
                            }
                            handler.setBridge(this.parent);
                            handler.startHandling();
                        }
                        catch (SAMException e) {
                            block14: {
                                if (_log.shouldLog(40)) {
                                    _log.error("SAM error: " + e.getMessage(), e);
                                }
                                try {
                                    String reply = "HELLO REPLY RESULT=I2P_ERROR MESSAGE=\"" + e.getMessage() + "\"\n";
                                    this.s.write(ByteBuffer.wrap(reply.getBytes("ISO-8859-1")));
                                }
                                catch (IOException ioe) {
                                    if (!_log.shouldLog(40)) break block14;
                                    _log.error("SAM Error sending error reply", ioe);
                                }
                            }
                            try {
                                this.s.close();
                            }
                            catch (IOException ioe) {}
                        }
                        catch (Exception ee) {
                            try {
                                this.s.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            _log.log(50, "Unexpected error handling SAM connection", ee);
                        }
                    }
                }
                new I2PAppThread(new HelloHandler(s, this), "HelloHandler").start();
            }
        }
        catch (Exception e) {
            if (_log.shouldLog(40)) {
                _log.error("Unexpected error while listening for connections", e);
            }
        }
        finally {
            try {
                if (_log.shouldLog(10)) {
                    _log.debug("Shutting down, closing server socket");
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static class HelpRequested
    extends Exception {
        static final long serialVersionUID = 1L;

        HelpRequested() {
        }
    }
}

