/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataOutputStream;
import java.io.IOException;
import org.klomp.snark.DataLoader;

class Message {
    static final byte KEEP_ALIVE = -1;
    static final byte CHOKE = 0;
    static final byte UNCHOKE = 1;
    static final byte INTERESTED = 2;
    static final byte UNINTERESTED = 3;
    static final byte HAVE = 4;
    static final byte BITFIELD = 5;
    static final byte REQUEST = 6;
    static final byte PIECE = 7;
    static final byte CANCEL = 8;
    static final byte PORT = 9;
    static final byte SUGGEST = 13;
    static final byte HAVE_ALL = 14;
    static final byte HAVE_NONE = 15;
    static final byte REJECT = 16;
    static final byte ALLOWED_FAST = 17;
    static final byte EXTENSION = 20;
    byte type;
    int piece;
    int begin;
    int length;
    byte[] data;
    int off;
    int len;
    DataLoader dataLoader;

    Message() {
    }

    void sendMessage(DataOutputStream dos) throws IOException {
        if (this.type == -1) {
            dos.writeInt(0);
            return;
        }
        if (this.data == null && this.dataLoader != null) {
            this.data = this.dataLoader.loadData(this.piece, this.begin, this.length);
            if (this.data == null) {
                return;
            }
        }
        int datalen = 1;
        if (this.type == 4 || this.type == 6 || this.type == 7 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 6 || this.type == 7 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 6 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 20) {
            ++datalen;
        }
        if (this.type == 9) {
            datalen += 2;
        }
        if (this.type == 5 || this.type == 7 || this.type == 20) {
            datalen += this.len;
        }
        dos.writeInt(datalen);
        dos.writeByte(this.type & 0xFF);
        if (this.type == 4 || this.type == 6 || this.type == 7 || this.type == 8) {
            dos.writeInt(this.piece);
        }
        if (this.type == 6 || this.type == 7 || this.type == 8) {
            dos.writeInt(this.begin);
        }
        if (this.type == 6 || this.type == 8) {
            dos.writeInt(this.length);
        }
        if (this.type == 20) {
            dos.writeByte((byte)this.piece & 0xFF);
        }
        if (this.type == 9) {
            dos.writeShort(this.piece & 0xFFFF);
        }
        if (this.type == 5 || this.type == 7 || this.type == 20) {
            dos.write(this.data, this.off, this.len);
        }
    }

    public String toString() {
        switch (this.type) {
            case -1: {
                return "KEEP_ALIVE";
            }
            case 0: {
                return "CHOKE";
            }
            case 1: {
                return "UNCHOKE";
            }
            case 2: {
                return "INTERESTED";
            }
            case 3: {
                return "UNINTERESTED";
            }
            case 4: {
                return "HAVE(" + this.piece + ")";
            }
            case 5: {
                return "BITFIELD";
            }
            case 6: {
                return "REQUEST(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
            case 7: {
                return "PIECE(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
            case 8: {
                return "CANCEL(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
            case 9: {
                return "PORT(" + this.piece + ")";
            }
            case 20: {
                return "EXTENSION(" + this.piece + ',' + this.data.length + ')';
            }
        }
        return "<UNKNOWN>";
    }
}

