/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.stat.Rate;
import net.i2p.stat.StatLog;
import net.i2p.util.Log;

public class RateStat {
    private final String _statName;
    private final String _groupName;
    private final String _description;
    protected final ConcurrentHashMap<Long, Rate> _rates;
    private StatLog _statLog;
    private static final String NL = System.getProperty("line.separator");

    public RateStat(String name, String description, String group, long[] periods) {
        this._statName = name;
        this._description = description;
        this._groupName = group;
        this._rates = new ConcurrentHashMap(4);
        for (int i = 0; i < periods.length; ++i) {
            Rate rate = new Rate(periods[i]);
            rate.setRateStat(this);
            this._rates.put(rate.getPeriod(), rate);
        }
    }

    public void setStatLog(StatLog sl) {
        this._statLog = sl;
    }

    public void addData(long value, long eventDuration) {
        if (this._statLog != null) {
            this._statLog.addData(this._groupName, this._statName, value, eventDuration);
        }
        for (Rate r : this._rates.values()) {
            r.addData(value, eventDuration);
        }
    }

    public void addData(long value) {
        if (this._statLog != null) {
            this._statLog.addData(this._groupName, this._statName, value, 0L);
        }
        for (Rate r : this._rates.values()) {
            r.addData(value);
        }
    }

    public void coalesceStats() {
        for (Rate r : this._rates.values()) {
            r.coalesce();
        }
    }

    public String getName() {
        return this._statName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDescription() {
        return this._description;
    }

    public long[] getPeriods() {
        long[] rv = new long[this._rates.size()];
        int counter = 0;
        for (Rate r : this._rates.values()) {
            rv[counter++] = r.getPeriod();
        }
        Arrays.sort(rv);
        return rv;
    }

    public double getLifetimeAverageValue() {
        if (this._rates.isEmpty()) {
            return 0.0;
        }
        return this._rates.values().iterator().next().getLifetimeAverageValue();
    }

    public long getLifetimeEventCount() {
        if (this._rates.isEmpty()) {
            return 0L;
        }
        return this._rates.values().iterator().next().getLifetimeEventCount();
    }

    public Rate getRate(long period) {
        return this._rates.get(period);
    }

    public void addRate(long period) {
        if (!this._rates.containsKey(period)) {
            Rate rate = new Rate(period);
            rate.setRateStat(this);
            this._rates.put(period, rate);
        }
    }

    public void removeRate(long period) {
        this._rates.remove(period);
    }

    public boolean containsRate(long period) {
        return this._rates.containsKey(period);
    }

    public int hashCode() {
        return this._statName.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(4096);
        buf.append(this.getGroupName()).append('.').append(this.getName()).append(": ").append(this.getDescription()).append('\n');
        long[] periods = this.getPeriods();
        Arrays.sort(periods);
        for (int i = 0; i < periods.length; ++i) {
            buf.append('\t').append(periods[i]).append(':');
            Rate curRate = this.getRate(periods[i]);
            buf.append(curRate.toString());
            buf.append(NL);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RateStat)) {
            return false;
        }
        RateStat rs = (RateStat)obj;
        if (DataHelper.eq(this.getGroupName(), rs.getGroupName()) && DataHelper.eq(this.getDescription(), rs.getDescription()) && DataHelper.eq(this.getName(), rs.getName())) {
            return this._rates.equals(rs._rates);
        }
        return false;
    }

    public void store(OutputStream out, String prefix) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(NL);
        buf.append("################################################################################").append(NL);
        buf.append("# Rate: ").append(this._groupName).append(": ").append(this._statName).append(NL);
        buf.append("# ").append(this._description).append(NL);
        buf.append("# ").append(NL).append(NL);
        out.write(buf.toString().getBytes());
        buf.setLength(0);
        for (Rate r : this._rates.values()) {
            buf.append("#######").append(NL);
            buf.append("# Period : ").append(DataHelper.formatDuration(r.getPeriod())).append(" for rate ").append(this._groupName).append(" - ").append(this._statName).append(NL);
            buf.append(NL);
            String curPrefix = prefix + "." + DataHelper.formatDuration(r.getPeriod());
            r.store(curPrefix, buf);
            out.write(buf.toString().getBytes());
            buf.setLength(0);
        }
    }

    public void load(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        for (Rate r : this._rates.values()) {
            long period = r.getPeriod();
            String curPrefix = prefix + "." + DataHelper.formatDuration(period);
            try {
                r.load(props, curPrefix, treatAsCurrent);
            }
            catch (IllegalArgumentException iae) {
                Rate rate = new Rate(period);
                rate.setRateStat(this);
                this._rates.put(rate.getPeriod(), rate);
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(RateStat.class);
                if (!log.shouldLog(30)) continue;
                log.warn("Rate for " + prefix + " is corrupt, reinitializing that period");
            }
        }
    }
}

