/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.stat.PersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.stat.RateSummaryListener;

public class Rate {
    private volatile double _currentTotalValue;
    private volatile int _currentEventCount;
    private volatile long _currentTotalEventTime;
    private volatile double _lastTotalValue;
    private volatile int _lastEventCount;
    private volatile long _lastTotalEventTime;
    private volatile double _extremeTotalValue;
    private volatile int _extremeEventCount;
    private volatile long _extremeTotalEventTime;
    private volatile double _lifetimeTotalValue;
    private volatile long _lifetimeEventCount;
    private volatile long _lifetimeTotalEventTime;
    private RateSummaryListener _summaryListener;
    private RateStat _stat;
    private volatile long _lastCoalesceDate;
    private long _creationDate;
    private int _period;
    private static final int SLACK = 2000;

    public double getCurrentTotalValue() {
        return this._currentTotalValue;
    }

    public long getCurrentEventCount() {
        return this._currentEventCount;
    }

    public long getCurrentTotalEventTime() {
        return this._currentTotalEventTime;
    }

    public double getLastTotalValue() {
        return this._lastTotalValue;
    }

    public long getLastEventCount() {
        return this._lastEventCount;
    }

    public long getLastTotalEventTime() {
        return this._lastTotalEventTime;
    }

    public double getExtremeTotalValue() {
        return this._extremeTotalValue;
    }

    public long getExtremeEventCount() {
        return this._extremeEventCount;
    }

    public long getExtremeTotalEventTime() {
        return this._extremeTotalEventTime;
    }

    public double getLifetimeTotalValue() {
        return this._lifetimeTotalValue;
    }

    public long getLifetimeEventCount() {
        return this._lifetimeEventCount;
    }

    public long getLifetimeTotalEventTime() {
        return this._lifetimeTotalEventTime;
    }

    public long getLastCoalesceDate() {
        return this._lastCoalesceDate;
    }

    public long getCreationDate() {
        return this._creationDate;
    }

    public long getPeriod() {
        return this._period;
    }

    public RateStat getRateStat() {
        return this._stat;
    }

    public void setRateStat(RateStat rs) {
        this._stat = rs;
    }

    public Rate(long period) throws IllegalArgumentException {
        if (period <= 0L || period > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this._lastCoalesceDate = this._creationDate = Rate.now();
        this._period = (int)period;
    }

    public Rate(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        this(1L);
        this.load(props, prefix, treatAsCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(long value) {
        Rate rate = this;
        synchronized (rate) {
            this._currentTotalValue += (double)value;
            ++this._currentEventCount;
            this._lifetimeTotalValue += (double)value;
            ++this._lifetimeEventCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(long value, long eventDuration) {
        Rate rate = this;
        synchronized (rate) {
            this._currentTotalValue += (double)value;
            ++this._currentEventCount;
            this._currentTotalEventTime += eventDuration;
            this._lifetimeTotalValue += (double)value;
            ++this._lifetimeEventCount;
            this._lifetimeTotalEventTime += eventDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalesce() {
        double correctedTotalValue;
        long now = Rate.now();
        Rate rate = this;
        synchronized (rate) {
            long measuredPeriod = now - this._lastCoalesceDate;
            if (measuredPeriod < (long)(this._period - 2000)) {
                return;
            }
            double periodFactor = (double)measuredPeriod / (double)this._period;
            this._lastTotalValue = this._currentTotalValue / periodFactor;
            this._lastEventCount = (int)(0.499999 + (double)this._currentEventCount / periodFactor);
            this._lastTotalEventTime = (long)((double)this._currentTotalEventTime / periodFactor);
            this._lastCoalesceDate = now;
            correctedTotalValue = this._currentEventCount == 0 ? 0.0 : this._currentTotalValue * ((double)this._lastEventCount / (double)this._currentEventCount);
            if (this._lastTotalValue >= this._extremeTotalValue) {
                this._extremeTotalValue = this._lastTotalValue;
                this._extremeEventCount = this._lastEventCount;
                this._extremeTotalEventTime = this._lastTotalEventTime;
            }
            this._currentTotalValue = 0.0;
            this._currentEventCount = 0;
            this._currentTotalEventTime = 0L;
        }
        if (this._summaryListener != null) {
            this._summaryListener.add(correctedTotalValue, this._lastEventCount, this._lastTotalEventTime, this._period);
        }
    }

    public void setSummaryListener(RateSummaryListener listener) {
        this._summaryListener = listener;
    }

    public RateSummaryListener getSummaryListener() {
        return this._summaryListener;
    }

    public double getAverageValue() {
        int lec = this._lastEventCount;
        if (this._lastTotalValue != 0.0 && lec > 0) {
            return this._lastTotalValue / (double)lec;
        }
        return 0.0;
    }

    public double getExtremeAverageValue() {
        if (this._extremeTotalValue != 0.0 && this._extremeEventCount > 0) {
            return this._extremeTotalValue / (double)this._extremeEventCount;
        }
        return 0.0;
    }

    public double getLifetimeAverageValue() {
        if (this._lifetimeTotalValue != 0.0 && this._lifetimeEventCount > 0L) {
            return this._lifetimeTotalValue / (double)this._lifetimeEventCount;
        }
        return 0.0;
    }

    public double getLastEventSaturation() {
        if (this._lastEventCount > 0 && this._lastTotalEventTime > 0L) {
            return (double)this._lastTotalEventTime / (double)this._period;
        }
        return 0.0;
    }

    public double getExtremeEventSaturation() {
        if (this._extremeEventCount > 0 && this._extremeTotalEventTime > 0L) {
            double eventTime = (double)this._extremeTotalEventTime / (double)this._extremeEventCount;
            double maxEvents = (double)this._period / eventTime;
            return (double)this._extremeEventCount / maxEvents;
        }
        return 0.0;
    }

    public double getLifetimeEventSaturation() {
        if (this._lastEventCount > 0 && this._lifetimeTotalEventTime > 0L) {
            double eventTime = (double)this._lifetimeTotalEventTime / (double)this._lifetimeEventCount;
            double maxEvents = (double)this._period / eventTime;
            double numPeriods = this.getLifetimePeriods();
            double avgEventsPerPeriod = (double)this._lifetimeEventCount / numPeriods;
            return avgEventsPerPeriod / maxEvents;
        }
        return 0.0;
    }

    public long getLifetimePeriods() {
        long lifetime = Rate.now() - this._creationDate;
        double periods = (double)lifetime / (double)this._period;
        return (long)Math.floor(periods);
    }

    public double getLastSaturationLimit() {
        if (this._lastTotalValue != 0.0 && this._lastEventCount > 0 && this._lastTotalEventTime > 0L) {
            double saturation = this.getLastEventSaturation();
            if (saturation != 0.0) {
                return this._lastTotalValue / saturation;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getExtremeSaturationLimit() {
        if (this._extremeTotalValue != 0.0 && this._extremeEventCount > 0 && this._extremeTotalEventTime > 0L) {
            double saturation = this.getExtremeEventSaturation();
            if (saturation != 0.0) {
                return this._extremeTotalValue / saturation;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getPercentageOfExtremeValue() {
        if (this._lastTotalValue != 0.0 && this._extremeTotalValue != 0.0) {
            return this._lastTotalValue / this._extremeTotalValue;
        }
        return 0.0;
    }

    public double getPercentageOfLifetimeValue() {
        if (this._lastTotalValue != 0.0 && this._lifetimeTotalValue != 0.0) {
            double lifetimePeriodValue = (double)this._period * (this._lifetimeTotalValue / (double)(Rate.now() - this._creationDate));
            return this._lastTotalValue / lifetimePeriodValue;
        }
        return 0.0;
    }

    public void store(String prefix, StringBuilder buf) throws IOException {
        PersistenceHelper.addTime(buf, prefix, ".period", "Length of the period:", this._period);
        PersistenceHelper.addDate(buf, prefix, ".creationDate", "When was this rate created?", this._creationDate);
        PersistenceHelper.addDate(buf, prefix, ".lastCoalesceDate", "When did we last coalesce this rate?", this._lastCoalesceDate);
        PersistenceHelper.addDate(buf, prefix, ".currentDate", "When was this data written?", Rate.now());
        PersistenceHelper.add(buf, prefix, ".currentTotalValue", "Total value of data points in the current (uncoalesced) period", this._currentTotalValue);
        PersistenceHelper.add(buf, prefix, ".currentEventCount", "How many events have occurred in the current (uncoalesced) period?", this._currentEventCount);
        PersistenceHelper.addTime(buf, prefix, ".currentTotalEventTime", "How much time have the events in the current (uncoalesced) period consumed?", this._currentTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".lastTotalValue", "Total value of data points in the most recent (coalesced) period", this._lastTotalValue);
        PersistenceHelper.add(buf, prefix, ".lastEventCount", "How many events have occurred in the most recent (coalesced) period?", this._lastEventCount);
        PersistenceHelper.addTime(buf, prefix, ".lastTotalEventTime", "How much time have the events in the most recent (coalesced) period consumed?", this._lastTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".extremeTotalValue", "Total value of data points in the most extreme period", this._extremeTotalValue);
        PersistenceHelper.add(buf, prefix, ".extremeEventCount", "How many events have occurred in the most extreme period?", this._extremeEventCount);
        PersistenceHelper.addTime(buf, prefix, ".extremeTotalEventTime", "How much time have the events in the most extreme period consumed?", this._extremeTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".lifetimeTotalValue", "Total value of data points since this stat was created", this._lifetimeTotalValue);
        PersistenceHelper.add(buf, prefix, ".lifetimeEventCount", "How many events have occurred since this stat was created?", this._lifetimeEventCount);
        PersistenceHelper.addTime(buf, prefix, ".lifetimeTotalEventTime", "How much total time was consumed by the events since this stat was created?", this._lifetimeTotalEventTime);
    }

    public void load(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        this._period = PersistenceHelper.getInt(props, prefix, ".period");
        this._creationDate = PersistenceHelper.getLong(props, prefix, ".creationDate");
        this._lastCoalesceDate = PersistenceHelper.getLong(props, prefix, ".lastCoalesceDate");
        this._currentTotalValue = PersistenceHelper.getDouble(props, prefix, ".currentTotalValue");
        this._currentEventCount = PersistenceHelper.getInt(props, prefix, ".currentEventCount");
        this._currentTotalEventTime = PersistenceHelper.getLong(props, prefix, ".currentTotalEventTime");
        this._lastTotalValue = PersistenceHelper.getDouble(props, prefix, ".lastTotalValue");
        this._lastEventCount = PersistenceHelper.getInt(props, prefix, ".lastEventCount");
        this._lastTotalEventTime = PersistenceHelper.getLong(props, prefix, ".lastTotalEventTime");
        this._extremeTotalValue = PersistenceHelper.getDouble(props, prefix, ".extremeTotalValue");
        this._extremeEventCount = PersistenceHelper.getInt(props, prefix, ".extremeEventCount");
        this._extremeTotalEventTime = PersistenceHelper.getLong(props, prefix, ".extremeTotalEventTime");
        this._lifetimeTotalValue = PersistenceHelper.getDouble(props, prefix, ".lifetimeTotalValue");
        this._lifetimeEventCount = PersistenceHelper.getLong(props, prefix, ".lifetimeEventCount");
        this._lifetimeTotalEventTime = PersistenceHelper.getLong(props, prefix, ".lifetimeTotalEventTime");
        if (treatAsCurrent) {
            this._lastCoalesceDate = Rate.now();
        }
        if (this._period <= 0) {
            throw new IllegalArgumentException("Period for " + prefix + " is invalid");
        }
        this.coalesce();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Rate)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Rate r = (Rate)obj;
        return (long)this._period == r.getPeriod() && this._creationDate == r.getCreationDate() && this._stat == r._stat;
    }

    public int hashCode() {
        return DataHelper.hashCode(this._stat) ^ this._period ^ (int)this._creationDate;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(2048);
        buf.append("\n\t total value: ").append(this.getLastTotalValue());
        buf.append("\n\t highest total value: ").append(this.getExtremeTotalValue());
        buf.append("\n\t lifetime total value: ").append(this.getLifetimeTotalValue());
        buf.append("\n\t # periods: ").append(this.getLifetimePeriods());
        buf.append("\n\t average value: ").append(this.getAverageValue());
        buf.append("\n\t highest average value: ").append(this.getExtremeAverageValue());
        buf.append("\n\t lifetime average value: ").append(this.getLifetimeAverageValue());
        buf.append("\n\t % of lifetime rate: ").append(100.0 * this.getPercentageOfLifetimeValue());
        buf.append("\n\t % of highest rate: ").append(100.0 * this.getPercentageOfExtremeValue());
        buf.append("\n\t # events: ").append(this.getLastEventCount());
        buf.append("\n\t lifetime events: ").append(this.getLifetimeEventCount());
        if (this.getLifetimeTotalEventTime() > 0L) {
            buf.append("\n\t % of time spent processing events: ").append(100.0 * this.getLastEventSaturation());
            buf.append("\n\t total value if we were always processing events: ").append(this.getLastSaturationLimit());
            buf.append("\n\t max % of time spent processing events: ").append(100.0 * this.getExtremeEventSaturation());
            buf.append("\n\t max total value if we were always processing events: ").append(this.getExtremeSaturationLimit());
        }
        return buf.toString();
    }

    private static final long now() {
        return System.currentTimeMillis();
    }
}

