/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

public class SessionConfig
extends DataStructureImpl {
    private static final Log _log = new Log(SessionConfig.class);
    private Destination _destination;
    private Signature _signature;
    private Date _creationDate;
    private Properties _options;
    private static final long OFFSET_VALIDITY = 30000L;

    public SessionConfig() {
        this(null);
    }

    public SessionConfig(Destination dest) {
        this._destination = dest;
        this._creationDate = new Date(Clock.getInstance().now());
    }

    public Destination getDestination() {
        return this._destination;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public void setCreationDate(Date date) {
        this._creationDate = date;
    }

    public Properties getOptions() {
        return this._options;
    }

    public void setOptions(Properties options) {
        this._options = options;
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature sig) {
        this._signature = sig;
    }

    public void signSessionConfig(SigningPrivateKey signingKey) throws DataFormatException {
        byte[] data = this.getBytes();
        if (data == null) {
            throw new DataFormatException("Unable to retrieve bytes for signing");
        }
        this._signature = DSAEngine.getInstance().sign(data, signingKey);
    }

    public boolean verifySignature() {
        if (this.getSignature() == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Signature is null!");
            }
            return false;
        }
        if (this.getDestination() == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Destination is null!");
            }
            return false;
        }
        if (this.getCreationDate() == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Date is null!");
            }
            return false;
        }
        if (this.tooOld()) {
            if (_log.shouldLog(30)) {
                _log.warn("Too old!");
            }
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Bytes could not be found - wtf?");
            }
            return false;
        }
        boolean ok = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this.getDestination().getSigningPublicKey());
        if (!ok && _log.shouldLog(30)) {
            _log.warn("DSA signature failed!");
        }
        return ok;
    }

    public boolean tooOld() {
        long now = Clock.getInstance().now();
        long earliestValid = now - 30000L;
        long latestValid = now + 30000L;
        if (this._creationDate == null) {
            return true;
        }
        if (this._creationDate.getTime() < earliestValid) {
            return true;
        }
        return this._creationDate.getTime() > latestValid;
    }

    private byte[] getBytes() {
        if (this._destination == null) {
            return null;
        }
        if (this._options == null) {
            return null;
        }
        if (this._creationDate == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this._destination.writeBytes(out);
            DataHelper.writeProperties(out, this._options, true);
            DataHelper.writeDate(out, this._creationDate);
        }
        catch (IOException ioe) {
            _log.error("IOError signing", ioe);
            return null;
        }
        catch (DataFormatException dfe) {
            _log.error("Error writing out the bytes for signing/verification", dfe);
            return null;
        }
        return out.toByteArray();
    }

    public void readBytes(InputStream rawConfig) throws DataFormatException, IOException {
        this._destination = new Destination();
        this._destination.readBytes(rawConfig);
        this._options = DataHelper.readProperties(rawConfig);
        this._creationDate = DataHelper.readDate(rawConfig);
        this._signature = new Signature();
        this._signature.readBytes(rawConfig);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._options == null || this._signature == null || this._creationDate == null) {
            throw new DataFormatException("Not enough data to create the session config");
        }
        this._destination.writeBytes(out);
        DataHelper.writeProperties(out, this._options, true);
        DataHelper.writeDate(out, this._creationDate);
        this._signature.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SessionConfig) {
            SessionConfig cfg = (SessionConfig)object;
            return DataHelper.eq(this.getSignature(), cfg.getSignature()) && DataHelper.eq(this.getDestination(), cfg.getDestination()) && DataHelper.eq(this.getCreationDate(), cfg.getCreationDate()) && DataHelper.eq(this.getOptions(), cfg.getOptions());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[SessionConfig: ");
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tSignature: ").append(this.getSignature());
        buf.append("\n\tCreation Date: ").append(this.getCreationDate());
        buf.append("\n\tOptions: #: ").append(this._options.size());
        OrderedProperties sorted = new OrderedProperties();
        sorted.putAll((Map<?, ?>)this._options);
        for (Map.Entry<Object, Object> e : ((Properties)sorted).entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
        }
        buf.append("]");
        return buf.toString();
    }
}

