/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class DateAndFlags
extends DataStructureImpl {
    protected int _flags;
    private long _date;

    public DateAndFlags() {
    }

    public DateAndFlags(long date, int flags) {
        this._flags = flags;
        this._date = date;
    }

    public DateAndFlags(Date date, int flags) {
        this._flags = flags;
        this._date = date.getTime();
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public Date getDate() {
        return new Date(this._date);
    }

    public long getTime() {
        return this._date;
    }

    public void setDate(long date) {
        this._date = date;
    }

    public void setDate(Date date) {
        this._date = date.getTime();
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._flags = (int)DataHelper.readLong(in, 2);
        this._date = DataHelper.readLong(in, 6);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        DataHelper.writeLong(out, 2, this._flags);
        DataHelper.writeLong(out, 6, this._date);
    }

    public byte[] toByteArray() {
        byte[] rv = DataHelper.toLong(8, this._date);
        rv[0] = (byte)(this._flags >> 8 & 0xFF);
        rv[1] = (byte)(this._flags & 0xFF);
        return rv;
    }

    public void fromByteArray(byte[] data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        if (data.length != 8) {
            throw new DataFormatException("Bad data length");
        }
        this._flags = (int)DataHelper.fromLong(data, 0, 2);
        this._date = DataHelper.fromLong(data, 2, 6);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DateAndFlags)) {
            return false;
        }
        DateAndFlags daf = (DateAndFlags)object;
        return this._date == daf._date && this._flags == daf._flags;
    }

    public int hashCode() {
        return this._flags + (int)this._date;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[DateAndFlags: ");
        buf.append("\n\tDate: ").append(new Date(this._date).toString());
        buf.append("\n\tFlags: 0x").append(Integer.toHexString(this._flags));
        buf.append("]");
        return buf.toString();
    }
}

