/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.InvalidKeyException;
import net.i2p.I2PAppContext;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.CryptixRijndael_Algorithm;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.ByteCache;

public class CryptixAESEngine
extends AESEngine {
    private static final CryptixRijndael_Algorithm _algo = new CryptixRijndael_Algorithm();
    private static final boolean USE_FAKE_CRYPTO = false;
    private static final ByteCache _prevCache = ByteCache.getInstance(16, 16);

    public CryptixAESEngine(I2PAppContext context) {
        super(context);
    }

    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.encrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        if (payload == null || out == null || sessionKey == null || iv == null) {
            throw new NullPointerException("invalid args to aes");
        }
        if (payload.length < payloadIndex + length) {
            throw new IllegalArgumentException("Payload is too short");
        }
        if (out.length < outIndex + length) {
            throw new IllegalArgumentException("Output is too short");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length is too small");
        }
        if (length % 16 != 0) {
            throw new IllegalArgumentException("Only lengths mod 16 are supported here");
        }
        int numblock = length / 16;
        DataHelper.xor(iv, ivOffset, payload, payloadIndex, out, outIndex, 16);
        this.encryptBlock(out, outIndex, sessionKey, out, outIndex);
        for (int x = 1; x < numblock; ++x) {
            DataHelper.xor(out, outIndex + (x - 1) * 16, payload, payloadIndex + x * 16, out, outIndex + x * 16, 16);
            this.encryptBlock(out, outIndex + x * 16, sessionKey, out, outIndex + x * 16);
        }
    }

    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.decrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        if (iv == null || payload == null || payload.length <= 0 || sessionKey == null) {
            throw new IllegalArgumentException("bad setup");
        }
        if (out == null) {
            throw new IllegalArgumentException("out is null");
        }
        if (out.length - outIndex < length) {
            throw new IllegalArgumentException("out is too small (out.length=" + out.length + " outIndex=" + outIndex + " length=" + length);
        }
        int numblock = length / 16;
        if (length % 16 != 0) {
            ++numblock;
        }
        ByteArray prevA = _prevCache.acquire();
        byte[] prev = prevA.getData();
        ByteArray curA = _prevCache.acquire();
        byte[] cur = curA.getData();
        System.arraycopy(iv, ivOffset, prev, 0, 16);
        for (int x = 0; x < numblock; ++x) {
            System.arraycopy(payload, payloadIndex + x * 16, cur, 0, 16);
            this.decryptBlock(payload, payloadIndex + x * 16, sessionKey, out, outIndex + x * 16);
            DataHelper.xor(out, outIndex + x * 16, prev, 0, out, outIndex + x * 16, 16);
            iv = prev;
            prev = cur;
            cur = iv;
        }
        _prevCache.release(prevA);
        _prevCache.release(curA);
    }

    public final void encryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] out, int outIndex) {
        if (sessionKey.getPreparedKey() == null) {
            try {
                Object key = CryptixRijndael_Algorithm.makeKey(sessionKey.getData(), 16);
                sessionKey.setPreparedKey(key);
            }
            catch (InvalidKeyException ike) {
                this._log.log(50, "Invalid key", ike);
                throw new IllegalArgumentException("wtf, invalid key?  " + ike.getMessage());
            }
        }
        CryptixRijndael_Algorithm.blockEncrypt(payload, out, inIndex, outIndex, sessionKey.getPreparedKey());
    }

    public final void decryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] rv, int outIndex) {
        if (sessionKey.getPreparedKey() == null) {
            try {
                Object key = CryptixRijndael_Algorithm.makeKey(sessionKey.getData(), 16);
                sessionKey.setPreparedKey(key);
            }
            catch (InvalidKeyException ike) {
                this._log.log(50, "Invalid key", ike);
                throw new IllegalArgumentException("wtf, invalid key?  " + ike.getMessage());
            }
        }
        CryptixRijndael_Algorithm.blockDecrypt(payload, rv, inIndex, outIndex, sessionKey.getPreparedKey());
    }
}

