/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.util.RFC822Date;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.UpdateHandler;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;

public class UnsignedUpdateHandler
extends UpdateHandler {
    private static UnsignedUpdateRunner _unsignedUpdateRunner;
    private String _zipURL;
    private String _zipVersion;

    public UnsignedUpdateHandler(RouterContext ctx, String zipURL, String version) {
        super(ctx);
        this._zipURL = zipURL;
        this._zipVersion = version;
        this._updateFile = new File(ctx.getTempDir(), "tmp" + ctx.random().nextInt() + "i2pupdate.zip").getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if ("true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress"))) {
            this._log.error("Update already running");
            return;
        }
        Class<UpdateHandler> clazz = UpdateHandler.class;
        synchronized (UpdateHandler.class) {
            if (_unsignedUpdateRunner == null) {
                _unsignedUpdateRunner = new UnsignedUpdateRunner();
            }
            if (_unsignedUpdateRunner.isRunning()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.setProperty("net.i2p.router.web.UpdateHandler.updateInProgress", "true");
            I2PAppThread update = new I2PAppThread(_unsignedUpdateRunner, "UnsignedUpdate");
            update.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public class UnsignedUpdateRunner
    extends UpdateHandler.UpdateRunner
    implements Runnable,
    EepGet.StatusListener {
        public UnsignedUpdateRunner() {
            super(UnsignedUpdateHandler.this);
        }

        protected void update() {
            UnsignedUpdateHandler.this.updateStatus("<b>" + UnsignedUpdateHandler.this._("Updating") + "</b>");
            if (UnsignedUpdateHandler.this._log.shouldLog(10)) {
                UnsignedUpdateHandler.this._log.debug("Starting unsigned update URL: " + UnsignedUpdateHandler.this._zipURL);
            }
            String proxyHost = UnsignedUpdateHandler.this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = ConfigUpdateHandler.proxyPort(UnsignedUpdateHandler.this._context);
            try {
                this._get = new EepGet((I2PAppContext)UnsignedUpdateHandler.this._context, proxyHost, proxyPort, 40, UnsignedUpdateHandler.this._updateFile, UnsignedUpdateHandler.this._zipURL, false);
                this._get.addStatusListener(this);
                this._get.fetch(55000L, -1L, 300000L);
            }
            catch (Throwable t) {
                UnsignedUpdateHandler.this._log.error("Error updating", t);
            }
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            File updFile = new File(UnsignedUpdateHandler.this._updateFile);
            if (!FileUtil.verifyZip(updFile)) {
                updFile.delete();
                UnsignedUpdateHandler.this.updateStatus("<b>" + UnsignedUpdateHandler.this._("Unsigned update file from {0} is corrupt", url) + "</b>");
                UnsignedUpdateHandler.this._log.log(50, "Corrupt zip file from " + url);
                return;
            }
            UnsignedUpdateHandler.this.updateStatus("<b>" + UnsignedUpdateHandler.this._("Update downloaded") + "</b>");
            File to = new File(UnsignedUpdateHandler.this._context.getRouterDir(), "i2pupdate.zip");
            boolean copied = FileUtil.copy(updFile, to, true, false);
            if (copied) {
                updFile.delete();
                String policy = UnsignedUpdateHandler.this._context.getProperty("router.updatePolicy");
                this.done = true;
                String lastmod = this._get.getLastModified();
                long modtime = 0L;
                if (lastmod != null) {
                    modtime = RFC822Date.parse822Date(lastmod);
                }
                if (modtime <= 0L) {
                    modtime = UnsignedUpdateHandler.this._context.clock().now();
                }
                UnsignedUpdateHandler.this._context.router().saveConfig("router.updateLastDownloaded", "" + modtime);
                if ("install".equals(policy)) {
                    UnsignedUpdateHandler.this._log.log(50, "Update was downloaded, restarting to install it");
                    UnsignedUpdateHandler.this.updateStatus("<b>" + UnsignedUpdateHandler.this._("Update downloaded") + "</b><br>" + UnsignedUpdateHandler.this._("Restarting"));
                    UnsignedUpdateHandler.this.restart();
                } else {
                    UnsignedUpdateHandler.this._log.log(50, "Update was downloaded, will be installed at next restart");
                    StringBuilder buf = new StringBuilder(64);
                    buf.append("<b>").append(UnsignedUpdateHandler.this._("Update downloaded")).append("</b><br>");
                    if (UnsignedUpdateHandler.this._context.hasWrapper()) {
                        buf.append(UnsignedUpdateHandler.this._("Click Restart to install"));
                    } else {
                        buf.append(UnsignedUpdateHandler.this._("Click Shutdown and restart to install"));
                    }
                    buf.append(' ').append(UnsignedUpdateHandler.this._("Version {0}", UnsignedUpdateHandler.this._zipVersion));
                    UnsignedUpdateHandler.this.updateStatus(buf.toString());
                }
            } else {
                UnsignedUpdateHandler.this._log.log(50, "Failed copy to " + to);
                UnsignedUpdateHandler.this.updateStatus("<b>" + UnsignedUpdateHandler.this._("Failed copy to {0}", to.getAbsolutePath()) + "</b>");
            }
        }
    }
}

