/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryHelper;

public class SummaryBarRenderer {
    static final String[] ALL_SECTIONS = new String[]{"HelpAndFAQ", "I2PServices", "I2PInternals", "General", "ShortGeneral", "NetworkReachability", "UpdateStatus", "RestartStatus", "Peers", "FirewallAndReseedStatus", "Bandwidth", "Tunnels", "Congestion", "TunnelStatus", "Destinations", "NewsHeadings"};
    static final Map<String, String> SECTION_NAMES;
    private final RouterContext _context;
    private final SummaryHelper _helper;

    public SummaryBarRenderer(RouterContext context, SummaryHelper helper) {
        this._context = context;
        this._helper = helper;
    }

    public void renderSummaryHTML(Writer out) throws IOException {
        String requestURI = this._helper.getRequestURI();
        String page = requestURI.replace("/", "").replace(".jsp", "");
        List<String> sections = this._helper.getSummaryBarSections(page);
        StringBuilder buf = new StringBuilder(8192);
        for (String section : sections) {
            buf.setLength(0);
            buf.append("<hr>\n");
            if ("HelpAndFAQ".equals(section)) {
                buf.append(this.renderHelpAndFAQHTML());
            } else if ("I2PServices".equals(section)) {
                buf.append(this.renderI2PServicesHTML());
            } else if ("I2PInternals".equals(section)) {
                buf.append(this.renderI2PInternalsHTML());
            } else if ("General".equals(section)) {
                buf.append(this.renderGeneralHTML());
            } else if ("ShortGeneral".equals(section)) {
                buf.append(this.renderShortGeneralHTML());
            } else if ("NetworkReachability".equals(section)) {
                buf.append(this.renderNetworkReachabilityHTML());
            } else if ("UpdateStatus".equals(section)) {
                buf.append(this.renderUpdateStatusHTML());
            } else if ("RestartStatus".equals(section)) {
                buf.append(this.renderRestartStatusHTML());
            } else if ("Peers".equals(section)) {
                buf.append(this.renderPeersHTML());
            } else if ("FirewallAndReseedStatus".equals(section)) {
                buf.append(this.renderFirewallAndReseedStatusHTML());
            } else if ("Bandwidth".equals(section)) {
                buf.append(this.renderBandwidthHTML());
            } else if ("Tunnels".equals(section)) {
                buf.append(this.renderTunnelsHTML());
            } else if ("Congestion".equals(section)) {
                buf.append(this.renderCongestionHTML());
            } else if ("TunnelStatus".equals(section)) {
                buf.append(this.renderTunnelStatusHTML());
            } else if ("Destinations".equals(section)) {
                buf.append(this.renderDestinationsHTML());
            } else if ("NewsHeadings".equals(section)) {
                buf.append(this.renderNewsHeadingsHTML());
            }
            if (buf.length() <= 5) continue;
            out.write(buf.toString());
        }
    }

    public String renderHelpAndFAQHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/help\" target=\"_top\" title=\"").append(this._("I2P Router Help &amp; FAQ")).append("\">").append(this._("Help &amp; FAQ")).append("</a></h3>");
        return buf.toString();
    }

    public String renderI2PServicesHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/configclients\" target=\"_top\" title=\"").append(this._("Configure startup of clients and webapps (services); manually start dormant services")).append("\">").append(this._("I2P Services")).append("</a></h3>\n<hr class=\"b\"><table><tr><td><a href=\"/susimail/susimail\" target=\"_blank\" title=\"").append(this._("Anonymous webmail client")).append("\">").append(this._("Email")).append("</a>\n<a href=\"/i2psnark/\" target=\"_blank\" title=\"").append(this._("Built-in anonymous BitTorrent Client")).append("\">").append(this._("Torrents")).append("</a>\n<a href=\"http://127.0.0.1:7658/\" target=\"_blank\" title=\"").append(this._("Local web server")).append("\">").append(this._("Website")).append("</a>\n").append(NavHelper.getClientAppLinks(this._context)).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderI2PInternalsHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" target=\"_top\" title=\"").append(this._("Configure I2P Router")).append("\">").append(this._("I2P Internals")).append("</a></h3><hr class=\"b\">\n<table><tr><td>\n<a href=\"/tunnels\" target=\"_top\" title=\"").append(this._("View existing tunnels and tunnel build status")).append("\">").append(this._("Tunnels")).append("</a>\n<a href=\"/peers\" target=\"_top\" title=\"").append(this._("Show all current peer connections")).append("\">").append(this._("Peers")).append("</a>\n<a href=\"/profiles\" target=\"_top\" title=\"").append(this._("Show recent peer performance profiles")).append("\">").append(this._("Profiles")).append("</a>\n<a href=\"/netdb\" target=\"_top\" title=\"").append(this._("Show list of all known I2P routers")).append("\">").append(this._("NetDB")).append("</a>\n<a href=\"/logs\" target=\"_top\" title=\"").append(this._("Health Report")).append("\">").append(this._("Logs")).append("</a>\n");
        if (!StatSummarizer.isDisabled()) {
            buf.append("<a href=\"/graphs\" target=\"_top\" title=\"").append(this._("Graph router performance")).append("\">").append(this._("Graphs")).append("</a>\n");
        }
        buf.append("<a href=\"/stats\" target=\"_top\" title=\"").append(this._("Textual router performance statistics")).append("\">").append(this._("Stats")).append("</a>\n<a href=\"/i2ptunnelmgr\" target=\"_top\" title=\"").append(this._("Local Destinations")).append("\">").append(this._("I2PTunnel")).append("</a>\n<a href=\"/dns\" target=\"_top\" title=\"").append(this._("Manage your I2P hosts file here (I2P domain name resolution)")).append("\">").append(this._("Addressbook")).append("</a>\n");
        File javadoc = new File(this._context.getBaseDir(), "docs/javadoc/index.html");
        if (javadoc.exists()) {
            buf.append("<a href=\"/javadoc/index.html\" target=\"_blank\">Javadoc</a>\n");
        }
        buf.append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderGeneralHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/help\" target=\"_top\" title=\"").append(this._("I2P Router Help")).append("\">").append(this._("General")).append("</a></h3><hr class=\"b\">\n<table><tr><td align=\"left\"><b title=\"").append(this._("Your Local Identity is your unique I2P router identity, similar to an ip address but tailored to I2P. ")).append(this._("Never disclose this to anyone, as it can reveal your real world ip.")).append("\">").append(this._("Local Identity")).append(":</b></td><td align=\"right\"><a title=\"").append(this._("Your unique I2P router identity is")).append(' ').append(this._helper.getIdent()).append(", ").append(this._("never reveal it to anyone")).append("\" href=\"/netdb?r=.\" target=\"_top\">").append(this._("show")).append("</a></td></tr>\n<tr title=\"").append(this._("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderShortGeneralHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<table><tr title=\"").append(this._("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderNetworkReachabilityHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h4><a href=\"/confignet#help\" target=\"_top\" title=\"").append(this._("Help with configuring your firewall and router for optimal I2P performance")).append("\">").append(this._("Network")).append(": ").append(this._helper.getReachability()).append("</a></h4>\n");
        return buf.toString();
    }

    public String renderUpdateStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        String updateStatus = this._helper.getUpdateStatus();
        if ("".equals(updateStatus)) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/configupdate\" target=\"_top\" title=\"").append(this._("Configure I2P Updates")).append("\">").append(this._("I2P Update")).append("</a></h3><hr class=\"b\">\n");
        buf.append(updateStatus);
        return buf.toString();
    }

    public String renderRestartStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getRestartStatus());
        return buf.toString();
    }

    public String renderPeersHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/peers\" target=\"_top\" title=\"").append(this._("Show all current peer connections")).append("\">").append(this._("Peers")).append("</a></h3><hr class=\"b\">\n<table>\n<tr title=\"").append(this._("Peers we've been talking to in the last few minutes/last hour")).append("\"><td align=\"left\"><b>").append(this._("Active")).append(":</b></td><td align=\"right\">");
        int active = this._helper.getActivePeers();
        buf.append(active).append(" / ").append(Math.max(active, this._helper.getActiveProfiles())).append("</td></tr>\n<tr title=\"").append(this._("The number of peers available for building client tunnels")).append("\"><td align=\"left\"><b>").append(this._("Fast")).append(":</b></td><td align=\"right\">").append(this._helper.getFastPeers()).append("</td></tr>\n<tr title=\"").append(this._("The number of peers available for building exploratory tunnels")).append("\"><td align=\"left\"><b>").append(this._("High capacity")).append(":</b></td><td align=\"right\">").append(this._helper.getHighCapacityPeers()).append("</td></tr>\n<tr title=\"").append(this._("The number of peers available for network database inquiries")).append("\"><td align=\"left\"><b>").append(this._("Integrated")).append(":</b></td><td align=\"right\">").append(this._helper.getWellIntegratedPeers()).append("</td></tr>\n<tr title=\"").append(this._("The total number of peers in our network database")).append("\"><td align=\"left\"><b>").append(this._("Known")).append(":</b></td><td align=\"right\">").append(this._helper.getAllPeers()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderFirewallAndReseedStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getFirewallAndReseedStatus());
        return buf.toString();
    }

    public String renderBandwidthHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" title=\"").append(this._("Configure router bandwidth allocation")).append("\" target=\"_top\">").append(this._("Bandwidth in/out")).append("</a></h3><hr class=\"b\"><table>\n<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2(3000L)).append(":</b></td><td align=\"right\">").append(this._helper.getSecondKBps()).append("Bps</td></tr>\n");
        if (this._context.router().getUptime() > 360000L) {
            buf.append("<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2(300000L)).append(":</b></td><td align=\"right\">").append(this._helper.getFiveMinuteKBps()).append("Bps</td></tr>\n");
        }
        if (this._context.router().getUptime() > 120000L) {
            buf.append("<tr><td align=\"left\"><b>").append(this._("Total")).append(":</b></td><td align=\"right\">").append(this._helper.getLifetimeKBps()).append("Bps</td></tr>\n");
        }
        buf.append("<tr><td align=\"left\"><b>").append(this._("Used")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTransferred()).append(" / ").append(this._helper.getOutboundTransferred()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderTunnelsHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/tunnels\" target=\"_top\" title=\"").append(this._("View existing tunnels and tunnel build status")).append("\">").append(this._("Tunnels")).append("</a></h3><hr class=\"b\"><table>\n<tr title=\"").append(this._("Used for building and testing tunnels, and communicating with floodfill peers")).append("\"><td align=\"left\"><b>").append(this._("Exploratory")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTunnels() + this._helper.getOutboundTunnels()).append("</td></tr>\n<tr title=\"").append(this._("Tunnels we are using to provide or access services on the network")).append("\"><td align=\"left\"><b>").append(this._("Client")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundClientTunnels() + this._helper.getOutboundClientTunnels()).append("</td></tr>\n<tr title=\"").append(this._("Tunnels we are participating in, directly contributing bandwith to the network")).append("\"><td align=\"left\"><b>").append(this._("Participating")).append(":</b></td><td align=\"right\">").append(this._helper.getParticipatingTunnels()).append("</td></tr>\n<tr title=\"").append(this._("The ratio of tunnel hops we provide to tunnel hops we use - a value greater than 1.00 indicates a positive contribution to the network")).append("\"><td align=\"left\"><b>").append(this._("Share ratio")).append(":</b></td><td align=\"right\">").append(this._helper.getShareRatio()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderCongestionHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/jobs\" target=\"_top\" title=\"").append(this._("What's in the router's job queue?")).append("\">").append(this._("Congestion")).append("</a></h3><hr class=\"b\"><table>\n<tr title=\"").append(this._("Indicates router performance")).append("\"><td align=\"left\"><b>").append(this._("Job lag")).append(":</b></td><td align=\"right\">").append(this._helper.getJobLag()).append("</td></tr>\n<tr title=\"").append(this._("Indicates how quickly outbound messages to other I2P routers are sent")).append("\"><td align=\"left\"><b>").append(this._("Message delay")).append(":</b></td><td align=\"right\">").append(this._helper.getMessageDelay()).append("</td></tr>\n");
        if (!this._context.getBooleanPropertyDefaultTrue("router.disableTunnelTesting")) {
            buf.append("<tr title=\"").append(this._("Round trip time for a tunnel test")).append("\"><td align=\"left\"><b>").append(this._("Tunnel lag")).append(":</b></td><td align=\"right\">").append(this._helper.getTunnelLag()).append("</td></tr>\n");
        }
        buf.append("<tr title=\"").append(this._("Queued requests from other routers to participate in tunnels")).append("\"><td align=\"left\"><b>").append(this._("Backlog")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundBacklog()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderTunnelStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append("<h4>").append(this._(this._helper.getTunnelStatus())).append("</h4>\n");
        return buf.toString();
    }

    public String renderDestinationsHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getDestinations());
        return buf.toString();
    }

    public String renderNewsHeadingsHTML() {
        if (this._helper == null) {
            return "";
        }
        NewsHelper newshelper = this._helper.getNewsHelper();
        if (newshelper == null || newshelper.shouldShowNews()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        String consoleNonce = System.getProperty("router.consoleNonce");
        if (consoleNonce != null) {
            buf.append("<h3><a href=\"/configupdate\">").append(this._("News &amp; Updates")).append("</a></h3><hr class=\"b\"><div class=\"newsheadings\">\n");
            String newsContent = newshelper.getContent();
            if (newsContent != "") {
                buf.append("<ul>\n");
                int start = newsContent.indexOf("<h3>");
                while (start >= 0) {
                    int end = (newsContent = newsContent.substring(start + 16, newsContent.length())).indexOf("</h3>");
                    if (end >= 0) {
                        String heading = newsContent.substring(0, end);
                        buf.append("<li>").append(heading).append("</li>\n");
                    }
                    start = newsContent.indexOf("<h3>");
                }
                buf.append("</ul>\n");
                String requestURI = this._helper.getRequestURI();
                if (requestURI.contains("/home")) {
                    buf.append("<a href=\"/?news=1&amp;consoleNonce=").append(consoleNonce).append("\">").append(this._("Show news")).append("</a>\n");
                }
            } else {
                buf.append("<center><i>").append(this._("none")).append("</i></center>");
            }
            buf.append("</div>\n");
        }
        return buf.toString();
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put("HelpAndFAQ", "Help &amp; FAQ");
        aMap.put("I2PServices", "I2P Services");
        aMap.put("I2PInternals", "I2P Internals");
        aMap.put("General", "General");
        aMap.put("ShortGeneral", "Short General");
        aMap.put("NetworkReachability", "Network Reachability");
        aMap.put("UpdateStatus", "Update Status");
        aMap.put("RestartStatus", "Restart Status");
        aMap.put("Peers", "Peers");
        aMap.put("FirewallAndReseedStatus", "Firewall &amp; Reseed Status");
        aMap.put("Bandwidth", "Bandwidth");
        aMap.put("Tunnels", "Tunnels");
        aMap.put("Congestion", "Congestion");
        aMap.put("TunnelStatus", "Tunnel Status");
        aMap.put("Destinations", "Local Destinations");
        aMap.put("NewsHeadings", "News &amp; Updates");
        SECTION_NAMES = Collections.unmodifiableMap(aMap);
    }
}

