/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.ConfigClientsHelper;
import net.i2p.router.web.LogsHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.PluginUpdateChecker;
import net.i2p.router.web.PluginUpdateHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;
import org.mortbay.jetty.handler.ContextHandlerCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginStarter
implements Runnable {
    protected RouterContext _context;
    static final String PREFIX = "plugin.";
    static final String ENABLED = ".startOnLoad";
    private static final String[] STANDARD_WEBAPPS = new String[]{"i2psnark", "i2ptunnel", "susidns", "susimail", "addressbook", "routerconsole"};
    private static final String[] STANDARD_THEMES = new String[]{"images", "light", "dark", "classic", "midnight"};
    private static Map<String, ThreadGroup> pluginThreadGroups = new ConcurrentHashMap<String, ThreadGroup>();
    private static Map<String, Collection<Job>> pluginJobs = new ConcurrentHashMap<String, Collection<Job>>();
    private static Map<String, ClassLoader> _clCache = new ConcurrentHashMap<String, ClassLoader>();
    private static Map<String, Collection<String>> pluginWars = new ConcurrentHashMap<String, Collection<String>>();

    public PluginStarter(RouterContext ctx) {
        this._context = ctx;
    }

    static boolean pluginsEnabled(I2PAppContext ctx) {
        return Boolean.valueOf(ctx.getProperty("router.enablePlugins", "true"));
    }

    @Override
    public void run() {
        if (this._context.getBooleanPropertyDefaultTrue("plugins.autoUpdate") && !Boolean.valueOf(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress")).booleanValue() && !"0.9.2".equals(this._context.getProperty("router.previousVersion"))) {
            PluginStarter.updateAll(this._context, true);
        }
        PluginStarter.startPlugins(this._context);
    }

    static void updateAll(RouterContext ctx) {
        I2PAppThread t = new I2PAppThread(new PluginUpdater(ctx), "PluginUpdater", true);
        t.start();
    }

    private static void updateAll(RouterContext ctx, boolean delay) {
        List<String> plugins = PluginStarter.getPlugins();
        HashMap<String, String> toUpdate = new HashMap<String, String>();
        for (String appName : plugins) {
            Properties props = PluginStarter.pluginProperties(ctx, appName);
            String url = props.getProperty("updateURL");
            if (url == null) continue;
            toUpdate.put(appName, url);
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        PluginUpdateChecker puc = PluginUpdateChecker.getInstance(ctx);
        if (puc.isRunning()) {
            return;
        }
        if (delay) {
            System.setProperty("net.i2p.router.web.UpdateHandler.updateInProgress", "true");
            puc.setAppStatus(Messages.getString("Checking for plugin updates", ctx));
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            System.setProperty("net.i2p.router.web.UpdateHandler.updateInProgress", "false");
        }
        Log log = ctx.logManager().getLog(PluginStarter.class);
        int updated = 0;
        for (Map.Entry entry : toUpdate.entrySet()) {
            String appName = (String)entry.getKey();
            if (log.shouldLog(30)) {
                log.warn("Checking for update plugin: " + appName);
            }
            puc.update(appName);
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (puc.isRunning());
            if (!puc.isNewerAvailable()) {
                if (!log.shouldLog(30)) continue;
                log.warn("No update available for plugin: " + appName);
                continue;
            }
            PluginUpdateHandler puh = PluginUpdateHandler.getInstance(ctx);
            String url = (String)entry.getValue();
            if (log.shouldLog(30)) {
                log.warn("Updating plugin: " + appName);
            }
            puh.update(url);
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (puh.isRunning());
            if (!puh.wasUpdateSuccessful()) continue;
            ++updated;
        }
        if (updated > 0) {
            puc.setDoneStatus(PluginStarter.ngettext("1 plugin updated", "{0} plugins updated", updated, ctx));
        } else {
            puc.setDoneStatus(Messages.getString("Plugin update check complete", ctx));
        }
    }

    static void startPlugins(RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        Properties props = PluginStarter.pluginProperties();
        for (String string : props.keySet()) {
            String app;
            if (!string.startsWith(PREFIX) || !string.endsWith(ENABLED) || !Boolean.valueOf(props.getProperty(string)).booleanValue() || PluginStarter.isPluginRunning(app = string.substring(PREFIX.length(), string.lastIndexOf(ENABLED)), ctx)) continue;
            try {
                if (PluginStarter.startPlugin(ctx, app)) continue;
                log.error("Failed to start plugin: " + app);
            }
            catch (Throwable e) {
                log.error("Failed to start plugin: " + app, e);
            }
        }
    }

    static boolean startPlugin(RouterContext ctx, String appName) throws Exception {
        String name;
        File[] files;
        ContextHandlerCollection server;
        File clientConfig;
        File dir;
        File[] tfiles;
        Properties props;
        String minVersion;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot start nonexistent plugin: " + appName);
            PluginStarter.disablePlugin(appName);
            return false;
        }
        File pluginUpdate = new File(ctx.getConfigDir(), "plugins/" + appName + "/app.xpi2p.zip");
        if (pluginUpdate.exists() && ctx.router().getWhenStarted() > pluginUpdate.lastModified()) {
            if (!FileUtil.extractZip(pluginUpdate, pluginDir)) {
                pluginUpdate.delete();
                String foo = "Plugin '" + appName + "' failed to update! File '" + pluginUpdate + "' deleted. You may need to remove and install the plugin again.";
                log.error(foo);
                PluginStarter.disablePlugin(appName);
                throw new Exception(foo);
            }
            pluginUpdate.delete();
            System.err.println("INFO: Plugin updated: " + appName);
        }
        if ((minVersion = ConfigClientsHelper.stripHTML(props = PluginStarter.pluginProperties(ctx, appName), "min-i2p-version")) != null && new VersionComparator().compare("0.9.2", minVersion) < 0) {
            String foo = "Plugin " + appName + " requires I2P version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            throw new Exception(foo);
        }
        minVersion = ConfigClientsHelper.stripHTML(props, "min-java-version");
        if (minVersion != null && new VersionComparator().compare(System.getProperty("java.version"), minVersion) < 0) {
            String foo = "Plugin " + appName + " requires Java version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            throw new Exception(foo);
        }
        String jVersion = LogsHelper.jettyVersion();
        minVersion = ConfigClientsHelper.stripHTML(props, "min-jetty-version");
        if (minVersion != null && new VersionComparator().compare(minVersion, jVersion) > 0) {
            String foo = "Plugin " + appName + " requires Jetty version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            throw new Exception(foo);
        }
        String maxVersion = ConfigClientsHelper.stripHTML(props, "max-jetty-version");
        if (maxVersion != null && new VersionComparator().compare(maxVersion, jVersion) < 0) {
            String foo = "Plugin " + appName + " requires Jetty version " + maxVersion + " or lower";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            throw new Exception(foo);
        }
        if (log.shouldLog(20)) {
            log.info("Starting plugin: " + appName);
        }
        if ((tfiles = (dir = new File(pluginDir, "console/themes")).listFiles()) != null) {
            for (int i = 0; i < tfiles.length; ++i) {
                String name2 = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                ctx.router().setConfigSetting("routerconsole.theme." + name2, tfiles[i].getAbsolutePath());
            }
        }
        if ((clientConfig = new File(pluginDir, "clients.config")).exists()) {
            Properties cprops = new Properties();
            DataHelper.loadProps(cprops, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "start");
        }
        if ((server = WebAppStarter.getConsoleServer()) != null) {
            File consoleDir = new File(pluginDir, "console");
            Properties wprops = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            File webappDir = new File(consoleDir, "webapps");
            String[] fileNames = webappDir.list(RouterConsoleRunner.WarFilenameFilter.instance());
            if (fileNames != null) {
                if (!pluginWars.containsKey(appName)) {
                    pluginWars.put(appName, new ConcurrentHashSet());
                }
                for (int i = 0; i < fileNames.length; ++i) {
                    try {
                        String warName = fileNames[i].substring(0, fileNames[i].lastIndexOf(".war"));
                        if (Arrays.asList(STANDARD_WEBAPPS).contains(warName)) {
                            log.error("Skipping duplicate webapp " + warName + " in plugin " + appName);
                            continue;
                        }
                        String enabled = wprops.getProperty("webapps." + warName + ENABLED);
                        if ("false".equals(enabled)) continue;
                        if (log.shouldLog(20)) {
                            log.info("Starting webapp: " + warName);
                        }
                        String path = new File(webappDir, fileNames[i]).getCanonicalPath();
                        WebAppStarter.startWebApp(ctx, server, warName, path);
                        pluginWars.get(appName).add(warName);
                        continue;
                    }
                    catch (IOException ioe) {
                        log.error("Error resolving '" + fileNames[i] + "' in '" + webappDir, ioe);
                    }
                }
            }
        } else {
            log.error("No console web server to start plugins?");
        }
        File localeDir = new File(pluginDir, "console/locale");
        if (localeDir.exists() && localeDir.isDirectory() && (files = localeDir.listFiles()) != null) {
            boolean added = false;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginStarter.addPath(f.toURI().toURL());
                    log.error("INFO: Adding translation plugin to classpath: " + f);
                    added = true;
                    continue;
                }
                catch (Exception e) {
                    log.error("Plugin " + appName + " bad classpath element: " + f, e);
                }
            }
            if (added) {
                Translate.clearCache();
            }
        }
        if ((name = ConfigClientsHelper.stripHTML(props, "consoleLinkName_" + Messages.getLanguage(ctx))) == null) {
            name = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
        }
        String url = ConfigClientsHelper.stripHTML(props, "consoleLinkURL");
        if (name != null && url != null && name.length() > 0 && url.length() > 0) {
            String tip = ConfigClientsHelper.stripHTML(props, "consoleLinkTooltip_" + Messages.getLanguage(ctx));
            if (tip == null) {
                tip = ConfigClientsHelper.stripHTML(props, "consoleLinkTooltip");
            }
            if (tip != null) {
                NavHelper.registerApp(name, url, tip);
            } else {
                NavHelper.registerApp(name, url);
            }
        }
        return true;
    }

    static boolean stopPlugin(RouterContext ctx, String appName) throws Exception {
        String name;
        Properties props;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot stop nonexistent plugin: " + appName);
            return false;
        }
        File clientConfig = new File(pluginDir, "clients.config");
        if (clientConfig.exists()) {
            props = new Properties();
            DataHelper.loadProps(props, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "stop");
        }
        if (pluginWars.containsKey(appName)) {
            for (String warName : pluginWars.get(appName)) {
                WebAppStarter.stopWebApp(warName);
            }
            pluginWars.get(appName).clear();
        }
        if ((name = ConfigClientsHelper.stripHTML(props = PluginStarter.pluginProperties(ctx, appName), "consoleLinkName_" + Messages.getLanguage(ctx))) == null) {
            name = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
        }
        if (name != null && name.length() > 0) {
            NavHelper.unregisterApp(name);
        }
        if (log.shouldLog(30)) {
            log.warn("Stopping plugin: " + appName);
        }
        return true;
    }

    static boolean deletePlugin(RouterContext ctx, String appName) throws Exception {
        File dir;
        File[] tfiles;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot delete nonexistent plugin: " + appName);
            return false;
        }
        File clientConfig = new File(pluginDir, "clients.config");
        if (clientConfig.exists()) {
            Properties props = new Properties();
            DataHelper.loadProps(props, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "uninstall");
        }
        if ((tfiles = (dir = new File(pluginDir, "console/themes")).listFiles()) != null) {
            String current = ctx.getProperty("routerconsole.theme");
            HashMap<String, String> changes = new HashMap<String, String>();
            ArrayList<String> removes = new ArrayList<String>();
            for (int i = 0; i < tfiles.length; ++i) {
                String name = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                removes.add("routerconsole.theme." + name);
                if (!name.equals(current)) continue;
                changes.put("routerconsole.theme", "light");
            }
            ctx.router().saveConfig(changes, removes);
        }
        FileUtil.rmdir(pluginDir, false);
        Properties props = PluginStarter.pluginProperties();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(PREFIX + appName + '.')) continue;
            iter.remove();
        }
        PluginStarter.storePluginProperties(props);
        return true;
    }

    public static Properties pluginProperties(I2PAppContext ctx, String appName) {
        File cfgFile = new File(ctx.getConfigDir(), "plugins/" + appName + '/' + "plugin.config");
        Properties rv = new Properties();
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rv;
    }

    public static Properties pluginProperties() {
        File dir = I2PAppContext.getGlobalContext().getConfigDir();
        Properties rv = new Properties();
        File cfgFile = new File(dir, "plugins.config");
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        List<String> names = PluginStarter.getPlugins();
        for (String name : names) {
            String prop = PREFIX + name + ENABLED;
            if (rv.getProperty(prop) != null) continue;
            rv.setProperty(prop, "true");
        }
        return rv;
    }

    public static boolean isPluginEnabled(String appName) {
        Properties props = PluginStarter.pluginProperties();
        String prop = PREFIX + appName + ENABLED;
        return Boolean.valueOf(props.getProperty(prop, "true"));
    }

    public static void disablePlugin(String appName) {
        String prop;
        Properties props = PluginStarter.pluginProperties();
        if (Boolean.valueOf(props.getProperty(prop = PREFIX + appName + ENABLED, "true")).booleanValue()) {
            props.setProperty(prop, "false");
            PluginStarter.storePluginProperties(props);
        }
    }

    public static List<String> getPlugins() {
        ArrayList<String> rv = new ArrayList<String>();
        File pluginDir = new File(I2PAppContext.getGlobalContext().getConfigDir(), "plugins");
        File[] files = pluginDir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            rv.add(files[i].getName());
        }
        Collections.sort(rv);
        return rv;
    }

    public static Map<String, String> getPluginKeys(I2PAppContext ctx) {
        HashMap<String, String> rv = new HashMap<String, String>();
        List<String> names = PluginStarter.getPlugins();
        for (String name : names) {
            Properties props = PluginStarter.pluginProperties(ctx, name);
            String pubkey = props.getProperty("key");
            String signer = props.getProperty("signer");
            if (pubkey == null || signer == null || pubkey.length() != 172 || signer.length() <= 0) continue;
            rv.put(pubkey, signer);
        }
        return rv;
    }

    public static void storePluginProperties(Properties props) {
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), "plugins.config");
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runClientApps(RouterContext ctx, File pluginDir, List<ClientAppConfig> apps, String action) throws Exception {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        String pluginName = pluginDir.getName();
        if (!pluginThreadGroups.containsKey(pluginName)) {
            pluginThreadGroups.put(pluginName, new ThreadGroup(pluginName));
        }
        ThreadGroup pluginThreadGroup = pluginThreadGroups.get(pluginName);
        if (action.equals("start")) {
            pluginJobs.put(pluginName, new ConcurrentHashSet());
        }
        for (ClientAppConfig app : apps) {
            String[] argVal;
            if (action.equals("start") && app.disabled) continue;
            if (action.equals("start")) {
                argVal = LoadClientAppsJob.parseArgs(app.args);
            } else {
                String args;
                if (action.equals("stop")) {
                    args = app.stopargs;
                } else if (action.equals("uninstall")) {
                    args = app.uninstallargs;
                } else {
                    throw new IllegalArgumentException("bad action");
                }
                if (args == null || args.length() <= 0) continue;
                argVal = LoadClientAppsJob.parseArgs(args);
            }
            for (int i = 0; i < argVal.length; ++i) {
                if (argVal[i].indexOf("$") < 0) continue;
                argVal[i] = argVal[i].replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$PLUGIN", pluginDir.getAbsolutePath());
            }
            ClassLoader cl = null;
            if (app.classpath != null) {
                URL[] urls;
                String cp = new String(app.classpath);
                if (cp.indexOf("$") >= 0) {
                    cp = cp.replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                    cp = cp.replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                    cp = cp.replace("$PLUGIN", pluginDir.getAbsolutePath());
                }
                String clCacheKey = pluginName + app.className + app.args;
                if (!action.equals("start")) {
                    cl = _clCache.get(clCacheKey);
                }
                if (cl == null && (urls = PluginStarter.classpathToURLArray(cp, app.clientName, log)) != null) {
                    cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    if (action.equals("start")) {
                        _clCache.put(clCacheKey, cl);
                    }
                }
            }
            if (app.delay < 0L && action.equals("start")) {
                LoadClientAppsJob.runClientInline(app.className, app.clientName, argVal, log, cl);
                continue;
            }
            if (app.delay == 0L || !action.equals("start")) {
                LoadClientAppsJob.testClient(app.className, cl);
                LoadClientAppsJob.runClient(app.className, app.clientName, argVal, log, pluginThreadGroup, cl);
                continue;
            }
            try {
                LoadClientAppsJob.testClient(app.className, cl);
            }
            catch (ClassNotFoundException ex) {
                if (app.delay > 1L) {
                    Thread.sleep(2000L);
                }
                Thread.sleep(1000L);
            }
            LoadClientAppsJob.testClient(app.className, cl);
            LoadClientAppsJob.DelayedRunClient job = new LoadClientAppsJob.DelayedRunClient(ctx, app.className, app.clientName, argVal, app.delay, pluginThreadGroup, cl);
            ctx.jobQueue().addJob(job);
            pluginJobs.get(pluginName).add(job);
        }
    }

    public static boolean isPluginRunning(String pluginName, RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        boolean isJobRunning = false;
        if (pluginJobs.containsKey(pluginName)) {
            for (Job job : pluginJobs.get(pluginName)) {
                if (!ctx.jobQueue().isJobActive(job)) continue;
                isJobRunning = true;
                break;
            }
        }
        boolean isWarRunning = false;
        if (pluginWars.containsKey(pluginName)) {
            Iterator<String> it = pluginWars.get(pluginName).iterator();
            while (it.hasNext() && !isWarRunning) {
                String warName = it.next();
                if (!WebAppStarter.isWebAppRunning(warName)) continue;
                isWarRunning = true;
            }
        }
        if (log.shouldLog(10)) {
            log.debug("plugin name = <" + pluginName + ">; threads running? " + PluginStarter.isClientThreadRunning(pluginName) + "; webapp runing? " + isWarRunning + "; jobs running? " + isJobRunning);
        }
        return PluginStarter.isClientThreadRunning(pluginName) || isWarRunning || isJobRunning;
    }

    private static boolean isClientThreadRunning(String pluginName) {
        ThreadGroup group = pluginThreadGroups.get(pluginName);
        if (group == null) {
            return false;
        }
        Thread[] activeThreads = new Thread[1];
        group.enumerate(activeThreads);
        return activeThreads[0] != null;
    }

    private static URL[] classpathToURLArray(String classpath, String clientName, Log log) {
        StringTokenizer tok = new StringTokenizer(classpath, ",");
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            File f = new File(elem);
            if (!f.isAbsolute()) {
                log.error("Plugin client " + clientName + " classpath element is not absolute: " + f);
                continue;
            }
            try {
                urls.add(f.toURI().toURL());
                if (!log.shouldLog(30)) continue;
                log.warn("INFO: Adding plugin to classpath: " + f);
            }
            catch (Exception e) {
                log.error("Plugin client " + clientName + " bad classpath element: " + f, e);
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addPath(URL u) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    private static String ngettext(String s, String p, int n, I2PAppContext ctx) {
        return Messages.getString(n, s, p, ctx);
    }

    private static class PluginUpdater
    implements Runnable {
        private final RouterContext _ctx;

        public PluginUpdater(RouterContext ctx) {
            this._ctx = ctx;
        }

        public void run() {
            PluginStarter.updateAll(this._ctx, false);
        }
    }
}

