/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;
import net.i2p.util.VersionComparator;
import org.mortbay.jetty.Server;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogsHelper
extends HelperBase {
    private static final String LOCATION_AVAILABLE = "3.3.7";
    private static final String NL = System.getProperty("line.separator");

    public String getJettyVersion() {
        return Server.getVersion();
    }

    static String jettyVersion() {
        return Server.getVersion();
    }

    public String getLogs() {
        String str = this.formatMessages(this._context.logManager().getBuffer().getMostRecentMessages());
        return this._("File location") + ": <b><code>" + this._context.logManager().currentFile() + "</code></b><br><br>" + str;
    }

    public String getCriticalLogs() {
        return this.formatMessages(this._context.logManager().getBuffer().getMostRecentCriticalMessages());
    }

    static File wrapperLogFile(I2PAppContext ctx) {
        String wv;
        File f = null;
        if (ctx.hasWrapper() && (wv = System.getProperty("wrapper.version")) != null && new VersionComparator().compare(wv, LOCATION_AVAILABLE) >= 0) {
            try {
                f = WrapperManager.getWrapperLogFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (f == null || !f.exists()) {
            String path = System.getProperty("wrapper.logfile");
            if (path != null) {
                f = new File(path);
            } else {
                f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
                if (!f.exists()) {
                    f = new File(ctx.getBaseDir(), "wrapper.log");
                }
            }
        }
        return f;
    }

    public String getServiceLogs() {
        File f = LogsHelper.wrapperLogFile(this._context);
        String str = FileUtil.readTextFile(f.getAbsolutePath(), 250, false);
        if (str == null) {
            return this._("File not found") + ": <b><code>" + f.getAbsolutePath() + "</code></b>";
        }
        str = str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        return this._("File location") + ": <b><code>" + f.getAbsolutePath() + "</code></b> <pre>" + str + "</pre>";
    }

    private String formatMessages(List<String> msgs) {
        if (msgs.isEmpty()) {
            return "<p><i>" + this._("No log messages") + "</i></p>";
        }
        boolean colorize = this._context.getBooleanPropertyDefaultTrue("routerconsole.logs.color");
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<ul>");
        for (int i = msgs.size() - 1; i >= 0; --i) {
            String msg = msgs.get(i);
            if ((msg = msg.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;")).endsWith(NL)) {
                msg = msg.substring(0, msg.length() - NL.length());
            }
            msg = msg.replace("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;\n");
            buf.append("<li>");
            if (colorize) {
                String color = msg.contains(this._("CRIT")) ? "#cc0000" : (msg.contains(this._("ERROR")) ? "#ff3300" : (msg.contains(this._("WARN")) ? "#ff00cc" : (msg.contains(this._("INFO")) ? "#000099" : "#006600")));
                buf.append("<font color=\"").append(color).append("\">");
                buf.append(msg);
                buf.append("</font>");
            } else {
                buf.append(msg);
            }
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }
}

