/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobStats;
import net.i2p.router.web.HelperBase;

public class JobQueueHelper
extends HelperBase {
    public String getJobQueueSummary() {
        try {
            if (this._out != null) {
                this.renderStatusHTML(this._out);
                return "";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            this.renderStatusHTML(new OutputStreamWriter(baos));
            return new String(baos.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    private void renderStatusHTML(Writer out) throws IOException {
        Job j;
        int i;
        ArrayList<Job> readyJobs = new ArrayList<Job>(8);
        ArrayList<Job> timedJobs = new ArrayList<Job>(128);
        ArrayList<Job> activeJobs = new ArrayList<Job>(8);
        ArrayList<Job> justFinishedJobs = new ArrayList<Job>(8);
        int numRunners = this._context.jobQueue().getJobs(readyJobs, timedJobs, activeJobs, justFinishedJobs);
        StringBuilder buf = new StringBuilder(32768);
        buf.append("<b><div class=\"joblog\"><h3>I2P Job Queue</h3><div class=\"wideload\">Job runners: ").append(numRunners);
        buf.append("</b><br>\n");
        long now = this._context.clock().now();
        buf.append("<hr><b>Active jobs: ").append(activeJobs.size()).append("</b><ol>\n");
        for (i = 0; i < activeJobs.size(); ++i) {
            j = (Job)activeJobs.get(i);
            buf.append("<li>[started ").append(DataHelper.formatDuration2(now - j.getTiming().getStartAfter())).append(" ago]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>Just finished jobs: ").append(justFinishedJobs.size()).append("</b><ol>\n");
        for (i = 0; i < justFinishedJobs.size(); ++i) {
            j = (Job)justFinishedJobs.get(i);
            buf.append("<li>[finished ").append(DataHelper.formatDuration2(now - j.getTiming().getActualEnd())).append(" ago]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>Ready/waiting jobs: ").append(readyJobs.size()).append("</b><ol>\n");
        for (i = 0; i < readyJobs.size(); ++i) {
            j = (Job)readyJobs.get(i);
            buf.append("<li>[waiting ");
            buf.append(DataHelper.formatDuration2(now - j.getTiming().getStartAfter()));
            buf.append("]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        out.flush();
        buf.append("<hr><b>Scheduled jobs: ").append(timedJobs.size()).append("</b><ol>\n");
        long prev = Long.MIN_VALUE;
        for (Job j2 : timedJobs) {
            long time = j2.getTiming().getStartAfter() - now;
            buf.append("<li>").append(j2.getName()).append(" in ");
            buf.append(DataHelper.formatDuration2(time));
            if (time < 0L) {
                buf.append(" <b>DELAYED</b>");
            }
            if (time < prev) {
                buf.append(" <b>** OUT OF ORDER **</b>");
            }
            prev = time;
            buf.append("</li>\n");
        }
        buf.append("</ol></div>\n");
        out.flush();
        this.getJobStats(buf);
        out.flush();
        out.write(buf.toString());
    }

    private void getJobStats(StringBuilder buf) {
        buf.append("<table>\n<tr><th>Job</th><th>Runs</th><th>Time</th><th><i>Avg</i></th><th><i>Max</i></th><th><i>Min</i></th><th>Pending</th><th><i>Avg</i></th><th><i>Max</i></th><th><i>Min</i></th></tr>\n");
        long totRuns = 0L;
        long totExecTime = 0L;
        long avgExecTime = 0L;
        long maxExecTime = -1L;
        long minExecTime = -1L;
        long totPendingTime = 0L;
        long avgPendingTime = 0L;
        long maxPendingTime = -1L;
        long minPendingTime = -1L;
        ArrayList<JobStats> tstats = new ArrayList<JobStats>(this._context.jobQueue().getJobStats());
        Collections.sort(tstats, new JobStatsComparator());
        for (JobStats stats : tstats) {
            buf.append("<tr>");
            buf.append("<td><b>").append(stats.getName()).append("</b></td>");
            buf.append("<td align=\"right\">").append(stats.getRuns()).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getTotalTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getAvgTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMaxTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMinTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getTotalPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getAvgPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMaxPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMinPendingTime())).append("</td>");
            buf.append("</tr>\n");
            totRuns += stats.getRuns();
            totExecTime += stats.getTotalTime();
            if (stats.getMaxTime() > maxExecTime) {
                maxExecTime = stats.getMaxTime();
            }
            if (minExecTime < 0L || minExecTime > stats.getMinTime()) {
                minExecTime = stats.getMinTime();
            }
            totPendingTime += stats.getTotalPendingTime();
            if (stats.getMaxPendingTime() > maxPendingTime) {
                maxPendingTime = stats.getMaxPendingTime();
            }
            if (minPendingTime >= 0L && minPendingTime <= stats.getMinPendingTime()) continue;
            minPendingTime = stats.getMinPendingTime();
        }
        if (totRuns != 0L) {
            if (totExecTime != 0L) {
                avgExecTime = totExecTime / totRuns;
            }
            if (totPendingTime != 0L) {
                avgPendingTime = totPendingTime / totRuns;
            }
        }
        buf.append("<tr class=\"tablefooter\">");
        buf.append("<td><b>").append("SUMMARY").append("</b></td>");
        buf.append("<td align=\"right\">").append(totRuns).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(totExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(avgExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(maxExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(minExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(totPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(avgPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(maxPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(minPendingTime)).append("</td>");
        buf.append("</tr></table></div>\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JobStatsComparator
    implements Comparator<JobStats> {
        private JobStatsComparator() {
        }

        @Override
        public int compare(JobStats l, JobStats r) {
            return l.getName().compareTo(r.getName());
        }
    }
}

