/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SystemVersion;

class BloomFilterIVValidator
implements IVValidator {
    private final RouterContext _context;
    private final DecayingBloomFilter _filter;
    private static final int HALFLIFE_MS = 600000;
    private static final int MIN_SHARE_KBPS_TO_USE_BLOOM = 64;
    private static final int MIN_SHARE_KBPS_FOR_BIG_BLOOM = 512;
    private static final int MIN_SHARE_KBPS_FOR_HUGE_BLOOM = 1536;
    private static final long MIN_MEM_TO_USE_BLOOM = 0x4000000L;
    private static final long MIN_MEM_FOR_BIG_BLOOM = 0x8000000L;
    private static final long MIN_MEM_FOR_HUGE_BLOOM = 0x10000000L;
    private static final String PROP_FORCE = "router.forceDecayingBloomFilter";

    public BloomFilterIVValidator(RouterContext ctx, int KBps) {
        this._context = ctx;
        long maxMemory = SystemVersion.getMaxMemory();
        this._filter = this._context.getBooleanProperty(PROP_FORCE) ? new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV") : (KBps < 64 || maxMemory < 0x4000000L ? new DecayingHashSet(ctx, 600000, 16, "TunnelIVV") : (KBps >= 1536 && maxMemory >= 0x10000000L ? new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 25) : (KBps >= 512 && maxMemory >= 0x8000000L ? new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 24) : new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV"))));
        ctx.statManager().createRateStat("tunnel.duplicateIV", "Note that a duplicate IV was received", "Tunnels", new long[]{3600000L});
    }

    @Override
    public boolean receiveIV(byte[] ivData, int ivOffset, byte[] payload, int payloadOffset) {
        byte[] buf = SimpleByteCache.acquire((int)16);
        DataHelper.xor((byte[])ivData, (int)ivOffset, (byte[])payload, (int)payloadOffset, (byte[])buf, (int)0, (int)16);
        boolean dup = this._filter.add(buf);
        SimpleByteCache.release((byte[])buf);
        if (dup) {
            this._context.statManager().addRateData("tunnel.duplicateIV", 1L);
        }
        return !dup;
    }

    public void destroy() {
        this._filter.stopDecaying();
    }
}

