/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class PacketPusher
implements Runnable {
    private final Log _log;
    private final OutboundMessageFragments _fragments;
    private final List<UDPEndpoint> _endpoints;
    private volatile boolean _alive;

    public PacketPusher(RouterContext ctx, OutboundMessageFragments fragments, List<UDPEndpoint> endpoints) {
        this._log = ctx.logManager().getLog(PacketPusher.class);
        this._fragments = fragments;
        this._endpoints = endpoints;
    }

    public synchronized void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)this, "UDP packet pusher", true);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
    }

    @Override
    public void run() {
        while (this._alive) {
            try {
                List<UDPPacket> packets = this._fragments.getNextVolley();
                if (packets == null) continue;
                for (int i = 0; i < packets.size(); ++i) {
                    this.send(packets.get(i));
                }
            }
            catch (Exception e) {
                this._log.error("SSU Output Queue Error", (Throwable)e);
            }
        }
    }

    public void send(UDPPacket packet) {
        boolean isIPv4 = packet.getPacket().getAddress().getAddress().length == 4;
        for (int j = 0; j < this._endpoints.size(); ++j) {
            UDPEndpoint ep;
            try {
                ep = this._endpoints.get(j);
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            if ((!isIPv4 || !ep.isIPv4()) && (isIPv4 || !ep.isIPv6())) continue;
            ep.getSender().add(packet);
            return;
        }
        this._log.error("No endpoint to send " + packet);
        packet.release();
    }
}

