/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.I2PAppContext;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.util.CDPQEntry;
import net.i2p.util.Log;

class OutboundMessageState
implements CDPQEntry {
    private final I2PAppContext _context;
    private final Log _log;
    private final OutNetMessage _message;
    private final I2NPMessage _i2npMessage;
    private final PeerState _peer;
    private final long _expiration;
    private final byte[] _messageBuf;
    private final int _fragmentSize;
    private long _fragmentAcks;
    private final int _numFragments;
    private final long _startedOn;
    private long _nextSendTime;
    private int _pushCount;
    private int _maxSends;
    private long _enqueueTime;
    private long _seqNum;
    public static final int MAX_MSG_SIZE = 32768;
    private static final long EXPIRATION = 10000L;

    public OutboundMessageState(I2PAppContext context, I2NPMessage msg, PeerState peer) {
        this(context, null, msg, peer);
    }

    public OutboundMessageState(I2PAppContext context, OutNetMessage m, PeerState peer) {
        this(context, m, m.getMessage(), peer);
    }

    private OutboundMessageState(I2PAppContext context, OutNetMessage m, I2NPMessage msg, PeerState peer) {
        if (msg == null || peer == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageState.class);
        this._message = m;
        this._i2npMessage = msg;
        this._peer = peer;
        this._nextSendTime = this._startedOn = this._context.clock().now();
        this._expiration = this._startedOn + 10000L;
        int totalSize = this._i2npMessage.getRawMessageSize();
        if (totalSize > 32768) {
            throw new IllegalArgumentException("Size too large! " + totalSize);
        }
        this._messageBuf = new byte[totalSize];
        this._i2npMessage.toRawByteArray(this._messageBuf);
        this._fragmentSize = this._peer.fragmentSize();
        int numFragments = totalSize / this._fragmentSize;
        if (numFragments * this._fragmentSize < totalSize) {
            ++numFragments;
        }
        if (numFragments > 64) {
            throw new IllegalArgumentException("Fragmenting a " + totalSize + " message into " + numFragments + " fragments - too many!");
        }
        this._numFragments = numFragments;
        this._fragmentAcks = this._numFragments < 64 ? OutboundMessageState.mask(this._numFragments) - 1L : -1L;
    }

    private static long mask(int fragment) {
        return 1L << fragment;
    }

    public OutNetMessage getMessage() {
        return this._message;
    }

    public long getMessageId() {
        return this._i2npMessage.getUniqueId();
    }

    public PeerState getPeer() {
        return this._peer;
    }

    public boolean isExpired() {
        return this._expiration < this._context.clock().now();
    }

    public synchronized boolean isComplete() {
        return this._fragmentAcks == 0L;
    }

    public synchronized int getUnackedSize() {
        int rv = 0;
        if (this.isComplete()) {
            return rv;
        }
        int lastSize = this._messageBuf.length % this._fragmentSize;
        if (lastSize == 0) {
            lastSize = this._fragmentSize;
        }
        for (int i = 0; i < this._numFragments; ++i) {
            if (!this.needsSending(i)) continue;
            if (i + 1 == this._numFragments) {
                rv += lastSize;
                continue;
            }
            rv += this._fragmentSize;
        }
        return rv;
    }

    public synchronized boolean needsSending(int fragment) {
        return (this._fragmentAcks & OutboundMessageState.mask(fragment)) != 0L;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._startedOn;
    }

    public synchronized boolean acked(ACKBitfield bitfield) {
        int highest = bitfield.highestReceived();
        for (int i = 0; i <= highest && i < this._numFragments; ++i) {
            if (!bitfield.received(i)) continue;
            this._fragmentAcks &= OutboundMessageState.mask(i) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this.isComplete();
    }

    public long getNextSendTime() {
        return this._nextSendTime;
    }

    public void setNextSendTime(long when) {
        this._nextSendTime = when;
    }

    public synchronized int getMaxSends() {
        return this._maxSends;
    }

    public synchronized int getPushCount() {
        return this._pushCount;
    }

    public synchronized void push() {
        ++this._pushCount;
        this._maxSends = this._pushCount;
    }

    public int getFragmentCount() {
        return this._numFragments;
    }

    public int getMessageSize() {
        return this._messageBuf.length;
    }

    public int fragmentSize(int fragmentNum) {
        if (fragmentNum + 1 == this._numFragments) {
            int valid = this._messageBuf.length;
            if (valid <= this._fragmentSize) {
                return valid;
            }
            int mod = valid % this._fragmentSize;
            return mod == 0 ? this._fragmentSize : mod;
        }
        return this._fragmentSize;
    }

    public int writeFragment(byte[] out, int outOffset, int fragmentNum) {
        int start = this._fragmentSize * fragmentNum;
        int toSend = this.fragmentSize(fragmentNum);
        int end = start + toSend;
        if (end <= this._messageBuf.length && outOffset + toSend <= out.length) {
            System.arraycopy(this._messageBuf, start, out, outOffset, toSend);
            return toSend;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Error: " + start + '/' + end + '/' + outOffset + '/' + out.length);
        }
        return -1;
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    @Override
    public void drop() {
        this._peer.getTransport().failed(this, false);
    }

    @Override
    public void setSeqNum(long num) {
        this._seqNum = num;
    }

    @Override
    public long getSeqNum() {
        return this._seqNum;
    }

    @Override
    public int getPriority() {
        return this._message != null ? this._message.getPriority() : 1000;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("OB Message ").append(this._i2npMessage.getUniqueId());
        buf.append(" with ").append(this._numFragments).append(" fragments");
        buf.append(" of size ").append(this._messageBuf.length);
        buf.append(" volleys: ").append(this._maxSends);
        buf.append(" lifetime: ").append(this.getLifetime());
        if (!this.isComplete()) {
            buf.append(" pending fragments: ");
            for (int i = 0; i < this._numFragments; ++i) {
                if (!this.needsSending(i)) continue;
                buf.append(i).append(' ');
            }
        }
        return buf.toString();
    }
}

