/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

class EstablishState {
    public static final VerifiedEstablishState VERIFIED = new VerifiedEstablishState();
    public static final FailedEstablishState FAILED = new FailedEstablishState();
    private final RouterContext _context;
    private final Log _log;
    private final byte[] _X;
    private final byte[] _hX_xor_bobIdentHash;
    private int _aliceIdentSize;
    private RouterIdentity _aliceIdent;
    private ByteArrayOutputStream _sz_aliceIdent_tsA_padding_aliceSig;
    private int _sz_aliceIdent_tsA_padding_aliceSigSize;
    private final byte[] _Y;
    private final byte[] _e_hXY_tsB;
    private transient long _tsB;
    private transient long _tsA;
    private transient byte[] _e_bobSig;
    private byte[] _prevEncrypted;
    private byte[] _curEncrypted;
    private int _curEncryptedOffset;
    private final byte[] _curDecrypted;
    private int _received;
    private byte[] _extra;
    private final DHSessionKeyBuilder _dh;
    private final NTCPTransport _transport;
    private final NTCPConnection _con;
    private String _err;
    private Exception _e;
    private boolean _failedBySkew;
    private static final int MIN_RI_SIZE = 387;
    private static final int MAX_RI_SIZE = 2048;
    private static final int AES_SIZE = 16;
    private static final int XY_SIZE = 256;
    private static final int HXY_SIZE = 32;
    private static final int HXY_TSB_PAD_SIZE = 48;
    private static final Object _stateLock = new Object();
    protected State _state;

    private EstablishState() {
        this._context = null;
        this._log = null;
        this._X = null;
        this._Y = null;
        this._hX_xor_bobIdentHash = null;
        this._curDecrypted = null;
        this._dh = null;
        this._transport = null;
        this._con = null;
        this._e_hXY_tsB = null;
    }

    public EstablishState(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._con = con;
        this._dh = this._transport.getDHBuilder();
        this._hX_xor_bobIdentHash = SimpleByteCache.acquire((int)32);
        if (this._con.isInbound()) {
            this._X = SimpleByteCache.acquire((int)256);
            this._Y = this._dh.getMyPublicValueBytes();
            this._sz_aliceIdent_tsA_padding_aliceSig = new ByteArrayOutputStream(512);
            this._prevEncrypted = SimpleByteCache.acquire((int)16);
            this._state = State.IB_INIT;
        } else {
            this._X = this._dh.getMyPublicValueBytes();
            this._Y = SimpleByteCache.acquire((int)256);
            ctx.sha().calculateHash(this._X, 0, 256, this._hX_xor_bobIdentHash, 0);
            EstablishState.xor32(con.getRemotePeer().calculateHash().getData(), this._hX_xor_bobIdentHash);
            this._state = State.OB_INIT;
        }
        this._e_hXY_tsB = new byte[48];
        this._curEncrypted = SimpleByteCache.acquire((int)16);
        this._curDecrypted = SimpleByteCache.acquire((int)16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State state) {
        Object object = _stateLock;
        synchronized (object) {
            this._state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(ByteBuffer src) {
        Object object = _stateLock;
        synchronized (object) {
            if (this._state == State.VERIFIED || this._state == State.CORRUPT) {
                throw new IllegalStateException(this.prefix() + "received unexpected data on " + this._con);
            }
        }
        if (!src.hasRemaining()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Receiving: " + src.remaining() + " Received: " + this._received);
        }
        if (this._con.isInbound()) {
            this.receiveInbound(src);
        } else {
            this.receiveOutbound(src);
        }
    }

    public synchronized boolean getFailedBySkew() {
        return this._failedBySkew;
    }

    private void receiveInbound(ByteBuffer src) {
        while (this._state == State.IB_INIT && src.hasRemaining()) {
            byte c = src.get();
            this._X[this._received++] = c;
            if (this._received < 256) continue;
            this.changeState(State.IB_GOT_X);
        }
        while (this._state == State.IB_GOT_X && src.hasRemaining()) {
            byte c;
            int i = this._received - 256;
            ++this._received;
            this._hX_xor_bobIdentHash[i] = c = src.get();
            if (i < 31) continue;
            this.changeState(State.IB_GOT_HX);
        }
        if (this._state == State.IB_GOT_HX) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "Enough data for a DH received");
            }
            byte[] realXor = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(this._X, 0, 256, realXor, 0);
            EstablishState.xor32(this._context.routerHash().getData(), realXor);
            if (!DataHelper.eq((byte[])realXor, (byte[])this._hX_xor_bobIdentHash)) {
                SimpleByteCache.release((byte[])realXor);
                this._context.statManager().addRateData("ntcp.invalidHXxorBIH", 1L);
                this.fail("Invalid hX_xor");
                return;
            }
            SimpleByteCache.release((byte[])realXor);
            if (!this._transport.isHXHIValid(this._hX_xor_bobIdentHash)) {
                this._context.statManager().addRateData("ntcp.replayHXxorBIH", 1L);
                this.fail("Replay hX_xor");
                return;
            }
            try {
                this._dh.setPeerPublicValue(this._X);
                this._dh.getSessionKey();
                System.arraycopy(this._hX_xor_bobIdentHash, 16, this._prevEncrypted, 0, 16);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                }
                byte[] xy = new byte[512];
                System.arraycopy(this._X, 0, xy, 0, 256);
                System.arraycopy(this._Y, 0, xy, 256, 256);
                byte[] hxy = SimpleByteCache.acquire((int)32);
                this._context.sha().calculateHash(xy, 0, 512, hxy, 0);
                this._tsB = (this._context.clock().now() + 500L) / 1000L;
                byte[] toEncrypt = new byte[48];
                System.arraycopy(hxy, 0, toEncrypt, 0, 32);
                byte[] tsB = DataHelper.toLong((int)4, (long)this._tsB);
                System.arraycopy(tsB, 0, toEncrypt, 32, tsB.length);
                this._context.random().nextBytes(toEncrypt, 36, 12);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "h(x+y)=" + Base64.encode((byte[])hxy));
                    this._log.debug(this.prefix() + "tsb = " + this._tsB);
                    this._log.debug(this.prefix() + "unencrypted H(X+Y)+tsB+padding: " + Base64.encode((byte[])toEncrypt));
                    this._log.debug(this.prefix() + "encryption iv= " + Base64.encode((byte[])this._Y, (int)240, (int)16));
                    this._log.debug(this.prefix() + "encryption key= " + this._dh.getSessionKey().toBase64());
                }
                SimpleByteCache.release((byte[])hxy);
                this._context.aes().encrypt(toEncrypt, 0, this._e_hXY_tsB, 0, this._dh.getSessionKey(), this._Y, 240, 48);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "encrypted H(X+Y)+tsB+padding: " + Base64.encode((byte[])this._e_hXY_tsB));
                }
                byte[] write = new byte[304];
                System.arraycopy(this._Y, 0, write, 0, 256);
                System.arraycopy(this._e_hXY_tsB, 0, write, 256, 48);
                this.changeState(State.IB_SENT_Y);
                this._transport.getPumper().wantsWrite(this._con, write);
                if (!src.hasRemaining()) {
                    return;
                }
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                this.fail("Invalid X", (Exception)((Object)e));
                return;
            }
        }
        while ((this._state == State.IB_SENT_Y || this._state == State.IB_GOT_RI_SIZE || this._state == State.IB_GOT_RI) && src.hasRemaining()) {
            while (this._curEncryptedOffset < 16 && src.hasRemaining()) {
                this._curEncrypted[this._curEncryptedOffset++] = src.get();
                ++this._received;
            }
            if (this._curEncryptedOffset >= 16) {
                block30: {
                    this._context.aes().decrypt(this._curEncrypted, 0, this._curDecrypted, 0, this._dh.getSessionKey(), this._prevEncrypted, 0, 16);
                    byte[] swap = this._prevEncrypted;
                    this._prevEncrypted = this._curEncrypted;
                    this._curEncrypted = swap;
                    this._curEncryptedOffset = 0;
                    if (this._state == State.IB_SENT_Y) {
                        int sz = (int)DataHelper.fromLong((byte[])this._curDecrypted, (int)0, (int)2);
                        if (sz < 387 || sz > 2048) {
                            this._context.statManager().addRateData("ntcp.invalidInboundSize", (long)sz);
                            this.fail("size is invalid", new Exception("size is " + sz));
                            return;
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug(this.prefix() + "got the RI size: " + sz);
                        }
                        this._aliceIdentSize = sz;
                        this.changeState(State.IB_GOT_RI_SIZE);
                    }
                    try {
                        this._sz_aliceIdent_tsA_padding_aliceSig.write(this._curDecrypted);
                    }
                    catch (IOException ioe) {
                        if (!this._log.shouldLog(40)) break block30;
                        this._log.error(this.prefix() + "Error writing to the baos?", (Throwable)ioe);
                    }
                }
                if (this._state == State.IB_GOT_RI_SIZE && this._sz_aliceIdent_tsA_padding_aliceSig.size() >= 2 + this._aliceIdentSize) {
                    this.readAliceRouterIdentity();
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "got the RI");
                    }
                    if (this._aliceIdent == null) {
                        return;
                    }
                    SigType type = this._aliceIdent.getSigningPublicKey().getType();
                    if (type == null) {
                        this.fail("Unsupported sig type");
                        return;
                    }
                    this.changeState(State.IB_GOT_RI);
                    this._sz_aliceIdent_tsA_padding_aliceSigSize = 2 + this._aliceIdentSize + 4 + type.getSigLen();
                    int rem = this._sz_aliceIdent_tsA_padding_aliceSigSize % 16;
                    int padding = 0;
                    if (rem > 0) {
                        padding = 16 - rem;
                    }
                    this._sz_aliceIdent_tsA_padding_aliceSigSize += padding;
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "alice ident size decrypted as " + this._aliceIdentSize + ", making the padding at " + padding + " and total size at " + this._sz_aliceIdent_tsA_padding_aliceSigSize);
                    }
                }
                if (this._state != State.IB_GOT_RI || this._sz_aliceIdent_tsA_padding_aliceSig.size() < this._sz_aliceIdent_tsA_padding_aliceSigSize) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "got the sig");
                }
                this.verifyInbound();
                if (this._state == State.VERIFIED && src.hasRemaining()) {
                    this.prepareExtra(src);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "verifying size (sz=" + this._sz_aliceIdent_tsA_padding_aliceSig.size() + " expected=" + this._sz_aliceIdent_tsA_padding_aliceSigSize + ' ' + (Object)((Object)this._state) + " extra=" + (this._extra != null ? this._extra.length : 0) + ")");
                }
                return;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug(this.prefix() + "end of available data with only a partial block read (" + this._curEncryptedOffset + ", " + this._received + ")");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "done with the data, not yet complete or corrupt");
        }
    }

    private void receiveOutbound(ByteBuffer src) {
        while (this._state == State.OB_SENT_X && src.hasRemaining()) {
            byte c = src.get();
            this._Y[this._received++] = c;
            if (this._received < 256) continue;
            try {
                this._dh.setPeerPublicValue(this._Y);
                this._dh.getSessionKey();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                }
                this.changeState(State.OB_GOT_Y);
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                this.fail("Invalid X", (Exception)((Object)e));
                return;
            }
        }
        while (this._state == State.OB_GOT_Y && src.hasRemaining()) {
            byte c;
            int i = this._received - 256;
            ++this._received;
            this._e_hXY_tsB[i] = c = src.get();
            if (i + 1 < 48) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "received _e_hXY_tsB fully");
            }
            byte[] hXY_tsB = new byte[48];
            this._context.aes().decrypt(this._e_hXY_tsB, 0, hXY_tsB, 0, this._dh.getSessionKey(), this._Y, 240, 48);
            byte[] XY = new byte[512];
            System.arraycopy(this._X, 0, XY, 0, 256);
            System.arraycopy(this._Y, 0, XY, 256, 256);
            byte[] h = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(XY, 0, 512, h, 0);
            if (!DataHelper.eq((byte[])h, (int)0, (byte[])hXY_tsB, (int)0, (int)32)) {
                SimpleByteCache.release((byte[])h);
                this._context.statManager().addRateData("ntcp.invalidHXY", 1L);
                this.fail("Invalid H(X+Y) - mitm attack attempted?");
                return;
            }
            SimpleByteCache.release((byte[])h);
            this.changeState(State.OB_GOT_HXY);
            this._tsB = DataHelper.fromLong((byte[])hXY_tsB, (int)32, (int)4);
            this._tsA = (this._context.clock().now() + 500L) / 1000L;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "h(X+Y) is correct, tsA-tsB=" + (this._tsA - this._tsB));
            }
            long diff = 1000L * Math.abs(this._tsA - this._tsB);
            if (!this._context.clock().getUpdatedSuccessfully()) {
                this._context.clock().setOffset(1000L * (this._tsB - this._tsA), true);
                this._tsA = this._tsB;
                if (diff != 0L) {
                    this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration((long)diff));
                }
            } else {
                if (diff >= 60000L) {
                    this._context.statManager().addRateData("ntcp.invalidOutboundSkew", diff);
                    this._transport.markReachable(this._con.getRemotePeer().calculateHash(), false);
                    this._context.banlist().banlistRouter(DataHelper.formatDuration((long)diff), this._con.getRemotePeer().calculateHash(), EstablishState._x("Excessive clock skew: {0}"));
                    this._transport.setLastBadSkew(this._tsA - this._tsB);
                    this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
                }
            }
            int sigSize = 552;
            byte[] preSign = new byte[sigSize];
            System.arraycopy(this._X, 0, preSign, 0, 256);
            System.arraycopy(this._Y, 0, preSign, 256, 256);
            System.arraycopy(this._con.getRemotePeer().calculateHash().getData(), 0, preSign, 512, 32);
            DataHelper.toLong((byte[])preSign, (int)544, (int)4, (long)this._tsA);
            DataHelper.toLong((byte[])preSign, (int)548, (int)4, (long)this._tsB);
            Signature sig = this._context.dsa().sign(preSign, this._context.keyManager().getSigningPrivateKey());
            byte[] ident = this._context.router().getRouterInfo().getIdentity().toByteArray();
            int min = 2 + ident.length + 4 + sig.length();
            int rem = min % 16;
            int padding = 0;
            if (rem > 0) {
                padding = 16 - rem;
            }
            byte[] preEncrypt = new byte[min + padding];
            DataHelper.toLong((byte[])preEncrypt, (int)0, (int)2, (long)ident.length);
            System.arraycopy(ident, 0, preEncrypt, 2, ident.length);
            DataHelper.toLong((byte[])preEncrypt, (int)(2 + ident.length), (int)4, (long)this._tsA);
            if (padding > 0) {
                this._context.random().nextBytes(preEncrypt, 2 + ident.length + 4, padding);
            }
            System.arraycopy(sig.getData(), 0, preEncrypt, 2 + ident.length + 4 + padding, sig.length());
            this._prevEncrypted = new byte[preEncrypt.length];
            this._context.aes().encrypt(preEncrypt, 0, this._prevEncrypted, 0, this._dh.getSessionKey(), this._hX_xor_bobIdentHash, this._hX_xor_bobIdentHash.length - 16, preEncrypt.length);
            this.changeState(State.OB_SENT_RI);
            this._transport.getPumper().wantsWrite(this._con, this._prevEncrypted);
        }
        if (this._state == State.OB_SENT_RI && src.hasRemaining()) {
            int off = 0;
            if (this._e_bobSig == null) {
                int siglen = this._con.getRemotePeer().getSigningPublicKey().getType().getSigLen();
                int rem = siglen % 16;
                int padding = rem > 0 ? 16 - rem : 0;
                this._e_bobSig = new byte[siglen + padding];
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "receiving E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + ")");
                }
            } else {
                off = this._received - 256 - 48;
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "continuing to receive E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + " off=" + off + " recv=" + this._received + ")");
                }
            }
            while (this._state == State.OB_SENT_RI && src.hasRemaining()) {
                this._e_bobSig[off++] = src.get();
                ++this._received;
                if (off < this._e_bobSig.length) continue;
                this.changeState(State.OB_GOT_SIG);
                byte[] bobSig = new byte[this._e_bobSig.length];
                this._context.aes().decrypt(this._e_bobSig, 0, bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, 32, this._e_bobSig.length);
                SigType type = this._con.getRemotePeer().getSigningPublicKey().getType();
                int siglen = type.getSigLen();
                byte[] bobSigData = new byte[siglen];
                System.arraycopy(bobSig, 0, bobSigData, 0, siglen);
                Signature sig = new Signature(type, bobSigData);
                byte[] toVerify = new byte[552];
                int voff = 0;
                System.arraycopy(this._X, 0, toVerify, voff, 256);
                System.arraycopy(this._Y, 0, toVerify, voff += 256, 256);
                System.arraycopy(this._context.routerHash().getData(), 0, toVerify, voff += 256, 32);
                DataHelper.toLong((byte[])toVerify, (int)(voff += 32), (int)4, (long)this._tsA);
                DataHelper.toLong((byte[])toVerify, (int)(voff += 4), (int)4, (long)this._tsB);
                voff += 4;
                boolean ok = this._context.dsa().verifySignature(sig, toVerify, this._con.getRemotePeer().getSigningPublicKey());
                if (!ok) {
                    this._context.statManager().addRateData("ntcp.invalidSignature", 1L);
                    this.fail("Signature was invalid - attempt to spoof " + this._con.getRemotePeer().calculateHash().toBase64() + "?");
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "signature verified from Bob.  done!");
                    }
                    this.prepareExtra(src);
                    byte[] nextWriteIV = this._curEncrypted;
                    System.arraycopy(this._prevEncrypted, this._prevEncrypted.length - 16, nextWriteIV, 0, 16);
                    this._con.finishOutboundEstablishment(this._dh.getSessionKey(), this._tsA - this._tsB, nextWriteIV, this._e_bobSig);
                    this.releaseBufs(true);
                    InetAddress ia = this._con.getChannel().socket().getInetAddress();
                    if (ia != null) {
                        this._transport.setIP(this._con.getRemotePeer().calculateHash(), ia.getAddress());
                    }
                    this.changeState(State.VERIFIED);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrupt() {
        Object object = _stateLock;
        synchronized (object) {
            return this._state == State.CORRUPT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Object object = _stateLock;
        synchronized (object) {
            return this._state == State.VERIFIED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareOutbound() {
        boolean shouldSend;
        Object object = _stateLock;
        synchronized (object) {
            shouldSend = this._state == State.OB_INIT;
        }
        if (shouldSend) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "send X");
            }
            byte[] toWrite = new byte[256 + this._hX_xor_bobIdentHash.length];
            System.arraycopy(this._X, 0, toWrite, 0, 256);
            System.arraycopy(this._hX_xor_bobIdentHash, 0, toWrite, 256, this._hX_xor_bobIdentHash.length);
            this.changeState(State.OB_SENT_X);
            this._transport.getPumper().wantsWrite(this._con, toWrite);
        } else if (this._log.shouldLog(30)) {
            this._log.warn(this.prefix() + "unexpected prepareOutbound()");
        }
    }

    private void readAliceRouterIdentity() {
        byte[] b = this._sz_aliceIdent_tsA_padding_aliceSig.toByteArray();
        try {
            int sz = this._aliceIdentSize;
            if (sz < 387 || sz > 2048 || sz > b.length - 2) {
                this._context.statManager().addRateData("ntcp.invalidInboundSize", (long)sz);
                this.fail("size is invalid", new Exception("size is " + sz));
                return;
            }
            RouterIdentity alice = new RouterIdentity();
            ByteArrayInputStream bais = new ByteArrayInputStream(b, 2, sz);
            alice.readBytes(bais);
            this._aliceIdent = alice;
        }
        catch (IOException ioe) {
            this._context.statManager().addRateData("ntcp.invalidInboundIOE", 1L);
            this.fail("Error verifying peer", ioe);
        }
        catch (DataFormatException dfe) {
            this._context.statManager().addRateData("ntcp.invalidInboundDFE", 1L);
            this.fail("Error verifying peer", (Exception)((Object)dfe));
        }
    }

    private void verifyInbound() {
        byte[] b = this._sz_aliceIdent_tsA_padding_aliceSig.toByteArray();
        try {
            int sz = this._aliceIdentSize;
            long tsA = DataHelper.fromLong((byte[])b, (int)(2 + sz), (int)4);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(768);
            baos.write(this._X);
            baos.write(this._Y);
            baos.write(this._context.routerHash().getData());
            baos.write(DataHelper.toLong((int)4, (long)tsA));
            baos.write(DataHelper.toLong((int)4, (long)this._tsB));
            byte[] toVerify = baos.toByteArray();
            SigType type = this._aliceIdent.getSigningPublicKey().getType();
            if (type == null) {
                this.fail("unsupported sig type");
                return;
            }
            byte[] s = new byte[type.getSigLen()];
            System.arraycopy(b, b.length - s.length, s, 0, s.length);
            Signature sig = new Signature(type, s);
            boolean ok = this._context.dsa().verifySignature(sig, toVerify, this._aliceIdent.getSigningPublicKey());
            if (ok) {
                byte[] ip;
                InetAddress addr = this._con.getChannel().socket().getInetAddress();
                byte[] byArray = ip = addr == null ? null : addr.getAddress();
                if (this._context.banlist().isBanlistedForever(this._aliceIdent.calculateHash())) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping inbound connection from permanently banlisted peer: " + this._aliceIdent.calculateHash());
                    }
                    if (ip != null) {
                        this._context.blocklist().add(ip);
                    }
                    this.fail("Peer is banlisted forever: " + this._aliceIdent.calculateHash());
                    return;
                }
                if (ip != null) {
                    this._transport.setIP(this._aliceIdent.calculateHash(), ip);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "verification successful for " + this._con);
                }
                long diff = 1000L * Math.abs(tsA - this._tsB);
                if (!this._context.clock().getUpdatedSuccessfully()) {
                    this._context.clock().setOffset(1000L * (this._tsB - tsA), true);
                    tsA = this._tsB;
                    if (diff != 0L) {
                        this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration((long)diff));
                    }
                } else {
                    if (diff >= 60000L) {
                        this._context.statManager().addRateData("ntcp.invalidInboundSkew", diff);
                        this._transport.markReachable(this._aliceIdent.calculateHash(), true);
                        this._context.banlist().banlistRouter(DataHelper.formatDuration((long)diff), this._aliceIdent.calculateHash(), EstablishState._x("Excessive clock skew: {0}"));
                        this._transport.setLastBadSkew(tsA - this._tsB);
                        this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                        return;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
                    }
                }
                this.sendInboundConfirm(this._aliceIdent, tsA);
                this._con.setRemotePeer(this._aliceIdent);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "e_bobSig is " + this._e_bobSig.length + " bytes long");
                }
                byte[] iv = this._curEncrypted;
                System.arraycopy(this._e_bobSig, this._e_bobSig.length - 16, iv, 0, 16);
                this._con.finishInboundEstablishment(this._dh.getSessionKey(), tsA - this._tsB, iv, this._prevEncrypted);
                this.releaseBufs(true);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.prefix() + "Verified remote peer as " + this._aliceIdent.calculateHash());
                }
                this.changeState(State.VERIFIED);
            } else {
                this._context.statManager().addRateData("ntcp.invalidInboundSignature", 1L);
                this.fail("Peer verification failed - spoof of " + this._aliceIdent.calculateHash() + "?");
            }
        }
        catch (IOException ioe) {
            this._context.statManager().addRateData("ntcp.invalidInboundIOE", 1L);
            this.fail("Error verifying peer", ioe);
        }
    }

    private void sendInboundConfirm(RouterIdentity alice, long tsA) {
        byte[] toSign = new byte[552];
        int off = 0;
        System.arraycopy(this._X, 0, toSign, off, 256);
        System.arraycopy(this._Y, 0, toSign, off += 256, 256);
        Hash h = alice.calculateHash();
        System.arraycopy(h.getData(), 0, toSign, off += 256, 32);
        DataHelper.toLong((byte[])toSign, (int)(off += 32), (int)4, (long)tsA);
        DataHelper.toLong((byte[])toSign, (int)(off += 4), (int)4, (long)this._tsB);
        off += 4;
        Signature sig = this._context.dsa().sign(toSign, this._context.keyManager().getSigningPrivateKey());
        int siglen = sig.length();
        int rem = siglen % 16;
        int padding = rem > 0 ? 16 - rem : 0;
        byte[] preSig = new byte[siglen + padding];
        System.arraycopy(sig.getData(), 0, preSig, 0, siglen);
        if (padding > 0) {
            this._context.random().nextBytes(preSig, siglen, padding);
        }
        this._e_bobSig = new byte[preSig.length];
        this._context.aes().encrypt(preSig, 0, this._e_bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, 32, this._e_bobSig.length);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Sending encrypted inbound confirmation");
        }
        this._transport.getPumper().wantsWrite(this._con, this._e_bobSig);
    }

    private void prepareExtra(ByteBuffer buf) {
        int remaining = buf.remaining();
        if (remaining > 0) {
            this._extra = new byte[remaining];
            buf.get(this._extra);
            this._received += remaining;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "prepare extra " + remaining + " (total received: " + this._received + ")");
        }
    }

    public synchronized byte[] getExtraBytes() {
        return this._extra;
    }

    public synchronized void close(String reason, Exception e) {
        this.fail(reason, e);
    }

    private void fail(String reason) {
        this.fail(reason, null);
    }

    private void fail(String reason, Exception e) {
        this.fail(reason, e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(String reason, Exception e, boolean bySkew) {
        Object object = _stateLock;
        synchronized (object) {
            if (this._state == State.CORRUPT || this._state == State.VERIFIED) {
                return;
            }
            this.changeState(State.CORRUPT);
        }
        this._failedBySkew = bySkew;
        this._err = reason;
        this._e = e;
        if (this._log.shouldLog(30)) {
            this._log.warn(this.prefix() + "Failed to establish: " + this._err, (Throwable)e);
        }
        this.releaseBufs(false);
    }

    private void releaseBufs(boolean isVerified) {
        if (this._prevEncrypted != null && this._prevEncrypted.length == 16) {
            SimpleByteCache.release((byte[])this._prevEncrypted);
        }
        if (!isVerified) {
            SimpleByteCache.release((byte[])this._curEncrypted);
        }
        SimpleByteCache.release((byte[])this._curDecrypted);
        SimpleByteCache.release((byte[])this._hX_xor_bobIdentHash);
        if (this._dh.getPeerPublicValue() == null) {
            this._transport.returnUnused(this._dh);
        }
        if (this._con.isInbound()) {
            SimpleByteCache.release((byte[])this._X);
        } else {
            SimpleByteCache.release((byte[])this._Y);
        }
    }

    public synchronized String getError() {
        return this._err;
    }

    public synchronized Exception getException() {
        return this._e;
    }

    private static void xor32(byte[] a, byte[] b) {
        for (int i = 0; i < 32; ++i) {
            int n = i;
            b[n] = (byte)(b[n] ^ a[i]);
        }
    }

    private String prefix() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this._con.isInbound()) {
            buf.append("IBES ");
        } else {
            buf.append("OBES ");
        }
        buf.append(System.identityHashCode(this));
        buf.append(' ').append((Object)this._state);
        if (this._con.isEstablished()) {
            buf.append(" established");
        }
        buf.append(": ");
        return buf.toString();
    }

    private static final String _x(String s) {
        return s;
    }

    private static class FailedEstablishState
    extends EstablishState {
        public FailedEstablishState() {
            this._state = State.CORRUPT;
        }

        @Override
        public void prepareOutbound() {
            Log log = RouterContext.getCurrentContext().logManager().getLog(VerifiedEstablishState.class);
            log.warn("prepareOutbound() on verified state, doing nothing!");
        }

        @Override
        public String toString() {
            return "FailedEstablishState";
        }
    }

    private static enum State {
        OB_INIT,
        OB_SENT_X,
        OB_GOT_Y,
        OB_GOT_HXY,
        OB_SENT_RI,
        OB_GOT_SIG,
        IB_INIT,
        IB_GOT_X,
        IB_GOT_HX,
        IB_SENT_Y,
        IB_GOT_RI_SIZE,
        IB_GOT_RI,
        VERIFIED,
        CORRUPT;

    }

    private static class VerifiedEstablishState
    extends EstablishState {
        public VerifiedEstablishState() {
            this._state = State.VERIFIED;
        }

        @Override
        public void prepareOutbound() {
            Log log = RouterContext.getCurrentContext().logManager().getLog(VerifiedEstablishState.class);
            log.warn("prepareOutbound() on verified state, doing nothing!");
        }

        @Override
        public String toString() {
            return "VerifiedEstablishState";
        }
    }
}

