/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.peermanager.PeerManager;
import net.i2p.util.Log;

public class PeerTestJob
extends JobImpl {
    private final Log _log;
    private PeerManager _manager;
    private boolean _keepTesting;
    private static final long DEFAULT_PEER_TEST_DELAY = 300000L;

    public PeerTestJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(PeerTestJob.class);
        this._keepTesting = false;
        this.getContext().statManager().createRateStat("peer.testOK", "How long a successful test takes", "Peers", new long[]{60000L, 600000L});
        this.getContext().statManager().createRateStat("peer.testTooSlow", "How long a too-slow (yet successful) test takes", "Peers", new long[]{60000L, 600000L});
        this.getContext().statManager().createRateStat("peer.testTimeout", "How often a test times out without a reply", "Peers", new long[]{60000L, 600000L});
    }

    private long getPeerTestDelay() {
        return 300000L;
    }

    private int getTestTimeout() {
        return 30000;
    }

    private int getTestConcurrency() {
        return 1;
    }

    public synchronized void startTesting(PeerManager manager) {
        this._manager = manager;
        this._keepTesting = true;
        this.getTiming().setStartAfter(this.getContext().clock().now() + 300000L);
        this.getContext().jobQueue().addJob(this);
        if (this._log.shouldLog(20)) {
            this._log.info("Start testing peers");
        }
    }

    public synchronized void stopTesting() {
        this._keepTesting = false;
        if (this._log.shouldLog(20)) {
            this._log.info("Stop testing peers");
        }
    }

    @Override
    public String getName() {
        return "Peer test start";
    }

    @Override
    public void runJob() {
        if (!this._keepTesting) {
            return;
        }
        Set<RouterInfo> peers = this.selectPeersToTest();
        if (this._log.shouldLog(10)) {
            this._log.debug("Testing " + peers.size() + " peers");
        }
        for (RouterInfo peer : peers) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Testing peer " + peer.getIdentity().getHash().toBase64());
            }
            this.testPeer(peer);
        }
        this.requeue(this.getPeerTestDelay());
    }

    private Set<RouterInfo> selectPeersToTest() {
        PeerSelectionCriteria criteria = new PeerSelectionCriteria();
        criteria.setMinimumRequired(this.getTestConcurrency());
        criteria.setMaximumRequired(this.getTestConcurrency());
        criteria.setPurpose(4);
        List<Hash> peerHashes = this._manager.selectPeers(criteria);
        if (this._log.shouldLog(10)) {
            this._log.debug("Peer selection found " + peerHashes.size() + " peers");
        }
        HashSet<RouterInfo> peers = new HashSet<RouterInfo>(peerHashes.size());
        for (Hash peer : peerHashes) {
            RouterInfo peerInfo = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (peerInfo != null) {
                peers.add(peerInfo);
                continue;
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn("Test peer " + peer.toBase64() + " had no local routerInfo?");
        }
        return peers;
    }

    private void testPeer(RouterInfo peer) {
        TunnelInfo inTunnel = this.getInboundTunnelId();
        if (inTunnel == null) {
            this._log.warn("No tunnels to get peer test replies through!  wtf!");
            return;
        }
        TunnelId inTunnelId = inTunnel.getReceiveTunnelId(0);
        RouterInfo inGateway = this.getContext().netDb().lookupRouterInfoLocally(inTunnel.getPeer(0));
        if (inGateway == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We can't find the gateway to our inbound tunnel?! wtf");
            }
            return;
        }
        int timeoutMs = this.getTestTimeout();
        long expiration = this.getContext().clock().now() + (long)timeoutMs;
        long nonce = this.getContext().random().nextLong(0xFFFFFFFFL);
        DatabaseStoreMessage msg = this.buildMessage(peer, inTunnelId, inGateway.getIdentity().getHash(), nonce, expiration);
        TunnelInfo outTunnel = this.getOutboundTunnelId();
        if (outTunnel == null) {
            this._log.warn("No tunnels to send search out through!  wtf!");
            return;
        }
        TunnelId outTunnelId = outTunnel.getSendTunnelId(0);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Sending peer test to " + peer.getIdentity().getHash().toBase64() + " out " + outTunnel + " w/ replies through " + inTunnel);
        }
        ReplySelector sel = new ReplySelector(peer.getIdentity().getHash(), nonce, expiration);
        PeerReplyFoundJob reply = new PeerReplyFoundJob(this.getContext(), peer, inTunnel, outTunnel);
        PeerReplyTimeoutJob timeoutJob = new PeerReplyTimeoutJob(this.getContext(), peer, inTunnel, outTunnel, sel);
        this.getContext().messageRegistry().registerPending(sel, reply, timeoutJob);
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnelId, null, peer.getIdentity().getHash());
    }

    private TunnelInfo getOutboundTunnelId() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    private TunnelInfo getInboundTunnelId() {
        return this.getContext().tunnelManager().selectInboundTunnel();
    }

    private DatabaseStoreMessage buildMessage(RouterInfo peer, TunnelId replyTunnel, Hash replyGateway, long nonce, long expiration) {
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setEntry(peer);
        msg.setReplyGateway(replyGateway);
        msg.setReplyTunnel(replyTunnel);
        msg.setReplyToken(nonce);
        msg.setMessageExpiration(expiration);
        return msg;
    }

    private class PeerReplyFoundJob
    extends JobImpl
    implements ReplyJob {
        private RouterInfo _peer;
        private long _testBegin;
        private TunnelInfo _replyTunnel;
        private TunnelInfo _sendTunnel;

        public PeerReplyFoundJob(RouterContext context, RouterInfo peer, TunnelInfo replyTunnel, TunnelInfo sendTunnel) {
            super(context);
            this._peer = peer;
            this._replyTunnel = replyTunnel;
            this._sendTunnel = sendTunnel;
            this._testBegin = context.clock().now();
        }

        @Override
        public String getName() {
            return "Peer test successful";
        }

        @Override
        public void runJob() {
            long responseTime = this.getContext().clock().now() - this._testBegin;
            if (PeerTestJob.this._log.shouldLog(10)) {
                PeerTestJob.this._log.debug("successful peer test after " + responseTime + " for " + this._peer.getIdentity().getHash().toBase64() + " using outbound tunnel " + this._sendTunnel + " and inbound tunnel " + this._replyTunnel);
            }
            this.getContext().profileManager().dbLookupSuccessful(this._peer.getIdentity().getHash(), responseTime);
            this._sendTunnel.testSuccessful((int)responseTime);
            this._replyTunnel.testSuccessful((int)responseTime);
        }

        @Override
        public void setMessage(I2NPMessage message) {
        }
    }

    private class PeerReplyTimeoutJob
    extends JobImpl {
        private RouterInfo _peer;
        private TunnelInfo _replyTunnel;
        private TunnelInfo _sendTunnel;
        private ReplySelector _selector;

        public PeerReplyTimeoutJob(RouterContext context, RouterInfo peer, TunnelInfo replyTunnel, TunnelInfo sendTunnel, ReplySelector sel) {
            super(context);
            this._peer = peer;
            this._replyTunnel = replyTunnel;
            this._sendTunnel = sendTunnel;
            this._selector = sel;
        }

        @Override
        public String getName() {
            return "Peer test failed";
        }

        private boolean getShouldFailPeer() {
            return true;
        }

        @Override
        public void runJob() {
            if (this._selector.matchFound()) {
                return;
            }
            if (this.getShouldFailPeer()) {
                this.getContext().profileManager().dbLookupFailed(this._peer.getIdentity().getHash());
            }
            if (PeerTestJob.this._log.shouldLog(10)) {
                PeerTestJob.this._log.debug("failed peer test for " + this._peer.getIdentity().getHash().toBase64() + " using outbound tunnel " + this._sendTunnel + " and inbound tunnel " + this._replyTunnel);
            }
            this.getContext().statManager().addRateData("peer.testTimeout", 1L);
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private long _expiration;
        private long _nonce;
        private Hash _peer;
        private boolean _matchFound;

        public ReplySelector(Hash peer, long nonce, long expiration) {
            this._nonce = nonce;
            this._expiration = expiration;
            this._peer = peer;
            this._matchFound = false;
        }

        @Override
        public boolean continueMatching() {
            return false;
        }

        @Override
        public long getExpiration() {
            return this._expiration;
        }

        @Override
        public boolean isMatch(I2NPMessage message) {
            DeliveryStatusMessage msg;
            if (message instanceof DeliveryStatusMessage && this._nonce == (msg = (DeliveryStatusMessage)message).getMessageId()) {
                long timeLeft = this._expiration - PeerTestJob.this.getContext().clock().now();
                if (timeLeft < 0L) {
                    if (PeerTestJob.this._log.shouldLog(30)) {
                        PeerTestJob.this._log.warn("Took too long to get a reply from peer " + this._peer.toBase64() + ": " + (0L - timeLeft) + "ms too slow");
                    }
                    PeerTestJob.this.getContext().statManager().addRateData("peer.testTooSlow", 0L - timeLeft);
                } else {
                    PeerTestJob.this.getContext().statManager().addRateData("peer.testOK", (long)PeerTestJob.this.getTestTimeout() - timeLeft);
                }
                this._matchFound = true;
                return true;
            }
            return false;
        }

        public boolean matchFound() {
            return this._matchFound;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Test peer ").append(this._peer.toBase64().substring(0, 4));
            buf.append(" with nonce ").append(this._nonce);
            return buf.toString();
        }
    }
}

