/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchMessageSelector;
import net.i2p.router.networkdb.kademlia.SearchReplyJob;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.router.networkdb.kademlia.SearchUpdateReplyFoundJob;
import net.i2p.util.Log;

class SearchJob
extends JobImpl {
    protected final Log _log;
    protected final KademliaNetworkDatabaseFacade _facade;
    private final SearchState _state;
    private final Job _onSuccess;
    private final Job _onFailure;
    private final long _expiration;
    private final long _timeoutMs;
    private final boolean _keepStats;
    private Job _pendingRequeueJob;
    private final PeerSelector _peerSelector;
    private final List<Search> _deferredSearches;
    private boolean _deferredCleared;
    private long _startedOn;
    private boolean _floodfillPeersExhausted;
    private int _floodfillSearchesOutstanding;
    private static final int SEARCH_BREDTH = 3;
    static final int MAX_CLOSEST = 10;
    private static final int PER_PEER_TIMEOUT = 5000;
    private static final long RESEND_TIMEOUT = 30000L;
    private static final long REQUEUE_DELAY = 1000L;
    private static final boolean DEFAULT_FLOODFILL_ONLY = true;
    static final int PER_FLOODFILL_PEER_TIMEOUT = 10000;
    static final long MIN_TIMEOUT = 2500L;
    private static int MAX_PEERS_QUERIED = 40;
    private static final int MAX_LEASE_RESEND = 10;
    private static final boolean SHOULD_RESEND_ROUTERINFO = false;

    public SearchJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, Job onSuccess, Job onFailure, long timeoutMs, boolean keepStats, boolean isLease) {
        super(context);
        if (key == null || key.getData() == null) {
            throw new IllegalArgumentException("Search for null key?  wtf");
        }
        this._log = this.getContext().logManager().getLog(this.getClass());
        this._facade = facade;
        this._state = new SearchState(this.getContext(), key);
        this._onSuccess = onSuccess;
        this._onFailure = onFailure;
        this._timeoutMs = timeoutMs;
        this._keepStats = keepStats;
        this._deferredSearches = new ArrayList<Search>(0);
        this._peerSelector = facade.getPeerSelector();
        this._startedOn = -1L;
        this._expiration = this.getContext().clock().now() + timeoutMs;
        this.getContext().statManager().addRateData("netDb.searchCount", 1L, 0L);
        if (this._log.shouldLog(10)) {
            this._log.debug("Search (" + this.getClass().getName() + " for " + key.toBase64(), (Throwable)new Exception("Search enqueued by"));
        }
    }

    @Override
    public void runJob() {
        if (this._startedOn <= 0L) {
            this._startedOn = this.getContext().clock().now();
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Searching for " + this._state.getTarget());
        }
        this.searchNext();
    }

    protected SearchState getState() {
        return this._state;
    }

    protected KademliaNetworkDatabaseFacade getFacade() {
        return this._facade;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public long getTimeoutMs() {
        return this._timeoutMs;
    }

    static boolean onlyQueryFloodfillPeers(RouterContext ctx) {
        if (ctx.netDb().floodfillEnabled()) {
            return false;
        }
        return ctx.getProperty("netDb.floodfillOnly", true);
    }

    protected int getPerPeerTimeoutMs(Hash peer) {
        int timeout = 0;
        timeout = this._floodfillPeersExhausted && this._floodfillSearchesOutstanding <= 0 ? this._facade.getPeerTimeout(peer) : 10000;
        long now = this.getContext().clock().now();
        if (now + (long)timeout > this._expiration) {
            return (int)Math.max(this._expiration - now, 2500L);
        }
        return timeout;
    }

    protected int getPerPeerTimeoutMs() {
        if (this._floodfillPeersExhausted && this._floodfillSearchesOutstanding <= 0) {
            return 5000;
        }
        return 10000;
    }

    protected void searchNext() {
        if (this._state.completed()) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Already completed");
            }
            return;
        }
        if (this._state.isAborted()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Search aborted");
            }
            this._state.complete();
            this.fail();
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Searching: " + this._state);
        }
        if (this.isLocal()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Key found locally");
            }
            this._state.complete();
            this.succeed();
        } else if (this.isExpired()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Key search expired");
            }
            this._state.complete();
            this.fail();
        } else if (this._state.getAttempted().size() > MAX_PEERS_QUERIED) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Too many peers quried");
            }
            this._state.complete();
            this.fail();
        } else {
            this.continueSearch();
        }
    }

    private boolean isLocal() {
        return this._facade.getDataStore().isKnown(this._state.getTarget());
    }

    private boolean isExpired() {
        return this.getContext().clock().now() >= this._expiration;
    }

    protected int getBredth() {
        return 3;
    }

    protected void continueSearch() {
        if (this._state.completed()) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Search already completed", (Throwable)new Exception("already completed"));
            }
            return;
        }
        int toCheck = this.getBredth() - this._state.getPending().size();
        if (toCheck <= 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Too many searches already pending (pending: " + this._state.getPending().size() + " max: " + this.getBredth() + ")");
            }
            this.requeuePending();
            return;
        }
        int sent = 0;
        Set<Hash> attempted = this._state.getAttempted();
        while (sent <= 0) {
            boolean onlyFloodfill = true;
            if (this._floodfillPeersExhausted && onlyFloodfill && this._state.getPending().isEmpty()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": no non-floodfill peers left, and no more pending.  Searched: " + this._state.getAttempted().size() + " failed: " + this._state.getFailed().size());
                }
                this.fail();
                return;
            }
            List<Hash> closestHashes = this.getClosestRouters(this._state.getTarget(), toCheck, attempted);
            if (closestHashes == null || closestHashes.isEmpty()) {
                if (this._state.getPending().isEmpty()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getJobId() + ": No peers left, and none pending!  Already searched: " + this._state.getAttempted().size() + " failed: " + this._state.getFailed().size());
                    }
                    this.fail();
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getJobId() + ": No peers left, but some are pending!  Pending: " + this._state.getPending().size() + " attempted: " + this._state.getAttempted().size() + " failed: " + this._state.getFailed().size());
                    }
                    this.requeuePending();
                }
                return;
            }
            attempted.addAll(closestHashes);
            for (Hash peer : closestHashes) {
                DatabaseEntry ds = this._facade.getDataStore().get(peer);
                if (ds == null) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Next closest peer " + peer + " was only recently referred to us, sending a search for them");
                    }
                    this.getContext().netDb().lookupRouterInfo(peer, null, null, this._timeoutMs);
                    continue;
                }
                if (ds.getType() != 0) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getJobId() + ": Error selecting closest hash that wasnt a router! " + peer + " : " + ds.getClass().getName());
                    }
                    this._state.replyTimeout(peer);
                    continue;
                }
                RouterInfo ri = (RouterInfo)ds;
                if (!FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                    this._floodfillPeersExhausted = true;
                    if (onlyFloodfill) continue;
                }
                if (ri.isHidden()) continue;
                this._state.addPending(peer);
                this.sendSearch((RouterInfo)ds);
                ++sent;
            }
        }
    }

    private void requeuePending() {
        long perPeerTimeout = this.getPerPeerTimeoutMs() / 2;
        if (perPeerTimeout < 1000L) {
            this.requeuePending(perPeerTimeout);
        } else {
            this.requeuePending(1000L);
        }
    }

    private void requeuePending(long ms) {
        if (this._pendingRequeueJob == null) {
            this._pendingRequeueJob = new RequeuePending(this.getContext());
        }
        long now = this.getContext().clock().now();
        if (this._pendingRequeueJob.getTiming().getStartAfter() < now) {
            this._pendingRequeueJob.getTiming().setStartAfter(now + ms);
        }
        this.getContext().jobQueue().addJob(this._pendingRequeueJob);
    }

    private List<Hash> getClosestRouters(Hash key, int numClosest, Set<Hash> alreadyChecked) {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(key);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Current routing key for " + key + ": " + rkey);
        }
        return this._peerSelector.selectNearestExplicit(rkey, numClosest, alreadyChecked, this._facade.getKBuckets());
    }

    protected void sendSearch(RouterInfo router) {
        if (router.getIdentity().equals((Object)this.getContext().router().getRouterInfo().getIdentity())) {
            if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": Dont send search to ourselves - why did we try?");
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Send search to " + router.getIdentity().getHash().toBase64() + " for " + this._state.getTarget().toBase64() + " w/ timeout " + this.getPerPeerTimeoutMs(router.getIdentity().calculateHash()));
        }
        this.getContext().statManager().addRateData("netDb.searchMessageCount", 1L, 0L);
        this.sendLeaseSearch(router);
    }

    protected void sendLeaseSearch(RouterInfo router) {
        Hash to = router.getIdentity().getHash();
        TunnelInfo inTunnel = this.getContext().tunnelManager().selectInboundExploratoryTunnel(to);
        if (inTunnel == null) {
            this._log.warn("No tunnels to get search replies through!  wtf!");
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        TunnelId inTunnelId = inTunnel.getReceiveTunnelId(0);
        int timeout = this.getPerPeerTimeoutMs(to);
        long expiration = this.getContext().clock().now() + (long)timeout;
        I2NPMessage msg = this.buildMessage(inTunnelId, inTunnel.getPeer(0), expiration, router);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to);
        if (outTunnel == null) {
            this._log.warn("No tunnels to send search out through!  wtf!");
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        TunnelId outTunnelId = outTunnel.getSendTunnelId(0);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Sending search to " + to + " for " + this.getState().getTarget() + " w/ replies through " + inTunnel.getPeer(0) + " via tunnel " + inTunnelId);
        }
        SearchMessageSelector sel = new SearchMessageSelector(this.getContext(), router, this._expiration, this._state);
        SearchUpdateReplyFoundJob reply = new SearchUpdateReplyFoundJob(this.getContext(), router, this._state, this._facade, this, outTunnel, inTunnel);
        if (FloodfillNetworkDatabaseFacade.isFloodfill(router)) {
            ++this._floodfillSearchesOutstanding;
        }
        this.getContext().messageRegistry().registerPending(sel, reply, new FailedJob(this.getContext(), router));
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnelId, to);
    }

    protected I2NPMessage buildMessage(TunnelId replyTunnelId, Hash replyGateway, long expiration, RouterInfo peer) {
        DatabaseLookupMessage msg = new DatabaseLookupMessage(this.getContext(), true);
        msg.setSearchKey(this._state.getTarget());
        msg.setFrom(replyGateway);
        msg.setDontIncludePeers(this._state.getClosestAttempted(10));
        msg.setMessageExpiration(expiration);
        msg.setReplyTunnel(replyTunnelId);
        return msg;
    }

    void replyFound(DatabaseSearchReplyMessage message, Hash peer) {
        long duration = this._state.replyFound(peer);
        this.getContext().jobQueue().addJob(new SearchReplyJob(this.getContext(), this, message, peer, duration));
    }

    protected void newPeersFound(int numNewPeers) {
    }

    private void succeed() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Succeeded search for key " + this._state.getTarget() + " after querying " + this._state.getAttempted().size());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of successful search: " + this._state);
        }
        if (this._keepStats) {
            long time = this.getContext().clock().now() - this._state.getWhenStarted();
            this.getContext().statManager().addRateData("netDb.successTime", time, 0L);
            this.getContext().statManager().addRateData("netDb.successPeers", (long)this._state.getAttempted().size(), time);
        }
        if (this._onSuccess != null) {
            this.getContext().jobQueue().addJob(this._onSuccess);
        }
        this._facade.searchComplete(this._state.getTarget());
        this.handleDeferred(true);
        this.resend();
    }

    private void resend() {
        LeaseSet ds = this._facade.lookupLeaseSetLocally(this._state.getTarget());
        if (ds != null) {
            Set<Hash> sendTo = this._state.getRepliedPeers();
            sendTo.addAll(this._state.getPending());
            int numSent = 0;
            for (Hash peer : sendTo) {
                RouterInfo peerInfo = this._facade.lookupRouterInfoLocally(peer);
                if (peerInfo == null) continue;
                if (this.resend(peerInfo, ds)) {
                    ++numSent;
                }
                if (numSent < 10) continue;
                break;
            }
            this.getContext().statManager().addRateData("netDb.republishQuantity", (long)numSent, (long)numSent);
        }
    }

    private boolean resend(RouterInfo toPeer, LeaseSet ls) {
        Hash to = toPeer.getIdentity().getHash();
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setEntry((DatabaseEntry)ls);
        msg.setMessageExpiration(this.getContext().clock().now() + 30000L);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to);
        if (outTunnel != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("resending leaseSet out to " + to + " through " + outTunnel + ": " + msg);
            }
            this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), null, to);
            return true;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("unable to resend a leaseSet - no outbound exploratory tunnels!");
        }
        return false;
    }

    protected void fail() {
        if (this.isLocal()) {
            if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": why did we fail if the target is local?: " + this._state.getTarget().toBase64(), (Throwable)new Exception("failure cause"));
            }
            this.succeed();
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Failed search for key " + this._state.getTarget());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of failed search: " + this._state);
        }
        long time = this.getContext().clock().now() - this._state.getWhenStarted();
        int attempted = this._state.getAttempted().size();
        this.getContext().statManager().addRateData("netDb.failedAttemptedPeers", (long)attempted, time);
        if (this._keepStats) {
            this.getContext().statManager().addRateData("netDb.failedTime", time, 0L);
        }
        if (this._onFailure != null) {
            this.getContext().jobQueue().addJob(this._onFailure);
        }
        this._facade.searchComplete(this._state.getTarget());
        this.handleDeferred(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDeferred(Job onFind, Job onFail, long expiration, boolean isLease) {
        Search search = new Search(onFind, onFail, expiration, isLease);
        boolean ok = true;
        int deferred = 0;
        List<Search> list = this._deferredSearches;
        synchronized (list) {
            if (this._deferredCleared) {
                ok = false;
            } else {
                this._deferredSearches.add(search);
            }
            deferred = this._deferredSearches.size();
        }
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Race deferred before searchCompleting?  our onFind=" + this._onSuccess + " new one: " + onFind);
            }
            this._facade.searchComplete(this._state.getTarget());
            this._facade.search(this._state.getTarget(), onFind, onFail, expiration - this.getContext().clock().now(), isLease);
            return 0;
        }
        return deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeferred(boolean success) {
        ArrayList<Search> deferred = null;
        List<Search> list = this._deferredSearches;
        synchronized (list) {
            if (!this._deferredSearches.isEmpty()) {
                deferred = new ArrayList<Search>(this._deferredSearches);
                this._deferredSearches.clear();
            }
            this._deferredCleared = true;
        }
        if (deferred != null) {
            long now = this.getContext().clock().now();
            for (int i = 0; i < deferred.size(); ++i) {
                Search cur = (Search)deferred.get(i);
                if (cur.getExpiration() < now) {
                    this.getContext().jobQueue().addJob(cur.getOnFail());
                    continue;
                }
                if (success) {
                    this.getContext().jobQueue().addJob(cur.getOnFind());
                    continue;
                }
                this.getContext().jobQueue().addJob(cur.getOnFail());
            }
        }
    }

    @Override
    public String getName() {
        return "Kademlia NetDb Search";
    }

    @Override
    public String toString() {
        return super.toString() + " started " + DataHelper.formatDuration((long)(this.getContext().clock().now() - this._startedOn)) + " ago";
    }

    boolean wasAttempted(Hash peer) {
        return this._state.wasAttempted(peer);
    }

    long timeoutMs() {
        return this._timeoutMs;
    }

    boolean add(Hash peer) {
        boolean rv = this._facade.getKBuckets().add((SimpleDataStructure)peer);
        if (rv) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Queueing up for next time: " + peer);
            }
            Set<Hash> s = Collections.singleton(peer);
            this._facade.queueForExploration(s);
        }
        return rv;
    }

    void decrementOutstandingFloodfillSearches() {
        --this._floodfillSearchesOutstanding;
    }

    protected class FailedJob
    extends JobImpl {
        private Hash _peer;
        private boolean _isFloodfill;
        private boolean _penalizePeer;
        private long _sentOn;

        public FailedJob(RouterContext enclosingContext, RouterInfo peer) {
            this(enclosingContext, peer, true);
        }

        public FailedJob(RouterContext enclosingContext, RouterInfo peer, boolean penalizePeer) {
            super(enclosingContext);
            this._penalizePeer = penalizePeer;
            this._peer = peer.getIdentity().getHash();
            this._sentOn = enclosingContext.clock().now();
            this._isFloodfill = FloodfillNetworkDatabaseFacade.isFloodfill(peer);
        }

        @Override
        public void runJob() {
            if (this._isFloodfill) {
                SearchJob.this._floodfillSearchesOutstanding--;
            }
            if (SearchJob.this._state.completed()) {
                return;
            }
            SearchJob.this._state.replyTimeout(this._peer);
            if (this._penalizePeer) {
                if (SearchJob.this._log.shouldLog(20)) {
                    SearchJob.this._log.info("Penalizing peer for timeout on search: " + this._peer.toBase64() + " after " + (this.getContext().clock().now() - this._sentOn));
                }
                this.getContext().profileManager().dbLookupFailed(this._peer);
            } else if (SearchJob.this._log.shouldLog(40)) {
                SearchJob.this._log.error("NOT (!!) Penalizing peer for timeout on search: " + this._peer.toBase64());
            }
            this.getContext().statManager().addRateData("netDb.failedPeers", 1L, 0L);
            SearchJob.this.searchNext();
        }

        @Override
        public String getName() {
            return "Kademlia Search Failed";
        }
    }

    private class RequeuePending
    extends JobImpl {
        public RequeuePending(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public String getName() {
            return "Requeue search with pending";
        }

        @Override
        public void runJob() {
            SearchJob.this.searchNext();
        }
    }

    private static class Search {
        private Job _onFind;
        private Job _onFail;
        private long _expiration;
        private boolean _isLease;

        public Search(Job onFind, Job onFail, long expiration, boolean isLease) {
            this._onFind = onFind;
            this._onFail = onFail;
            this._expiration = expiration;
            this._isLease = isLease;
        }

        public Job getOnFind() {
            return this._onFind;
        }

        public Job getOnFail() {
            return this._onFail;
        }

        public long getExpiration() {
            return this._expiration;
        }
    }
}

