/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PThread;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

class PersistentDataStore
extends TransientDataStore {
    private final File _dbDir;
    private final KademliaNetworkDatabaseFacade _facade;
    private final Writer _writer;
    private final ReadJob _readJob;
    private volatile boolean _initialized;
    private final boolean _flat;
    private static final int READ_DELAY = 120000;
    private static final String PROP_FLAT = "router.networkDatabase.flat";
    static final String DIR_PREFIX = "r";
    static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final int WRITE_LIMIT = 10000;
    private static final long WRITE_DELAY = 600000L;
    private static final String LEASESET_PREFIX = "leaseSet-";
    private static final String LEASESET_SUFFIX = ".dat";
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";

    public PersistentDataStore(RouterContext ctx, String dbDir, KademliaNetworkDatabaseFacade facade) throws IOException {
        super(ctx);
        this._flat = ctx.getBooleanProperty(PROP_FLAT);
        this._dbDir = this.getDbDir(dbDir);
        this._facade = facade;
        this._readJob = new ReadJob();
        this._context.jobQueue().addJob(this._readJob);
        ctx.statManager().createRateStat("netDb.writeClobber", "How often we clobber a pending netDb write", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writePending", "How many pending writes are there", "NetworkDatabase", new long[]{60000L});
        ctx.statManager().createRateStat("netDb.writeOut", "How many we wrote", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writeTime", "How long it took", "NetworkDatabase", new long[]{1200000L});
        this._writer = new Writer();
        I2PThread writer = new I2PThread((Runnable)this._writer, "DBWriter");
        writer.start();
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    @Override
    public void stop() {
        super.stop();
        this._writer.flush();
    }

    @Override
    public void restart() {
        super.restart();
    }

    @Override
    public void rescan() {
        if (this._initialized) {
            this._readJob.wakeup();
        }
    }

    @Override
    public DatabaseEntry get(Hash key) {
        return this.get(key, true);
    }

    @Override
    public DatabaseEntry get(Hash key, boolean persist) {
        DatabaseEntry rv = super.get(key);
        return rv;
    }

    @Override
    public DatabaseEntry remove(Hash key) {
        return this.remove(key, true);
    }

    @Override
    public DatabaseEntry remove(Hash key, boolean persist) {
        if (persist) {
            this._writer.remove(key);
            this._context.jobQueue().addJob(new RemoveJob(key));
        }
        return super.remove(key);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data) {
        return this.put(key, data, true);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data, boolean persist) {
        if (data == null || key == null) {
            return false;
        }
        boolean rv = super.put(key, data);
        if (rv && persist && data.getType() == 0) {
            this._writer.queue(key, data);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Hash key, DatabaseEntry data) {
        if (this._log.shouldLog(20)) {
            this._log.info("Writing key " + key);
        }
        OutputStream fos = null;
        File dbFile = null;
        try {
            String filename = null;
            if (data.getType() == 1) {
                filename = PersistentDataStore.getLeaseSetName(key);
            } else if (data.getType() == 0) {
                filename = this.getRouterInfoName(key);
            } else {
                throw new IOException("We don't know how to write objects of type " + data.getClass().getName());
            }
            dbFile = new File(this._dbDir, filename);
            long dataPublishDate = this.getPublishDate(data);
            if (dbFile.lastModified() < dataPublishDate) {
                fos = new SecureFileOutputStream(dbFile);
                fos = new BufferedOutputStream(fos);
                try {
                    data.writeBytes(fos);
                    fos.close();
                    dbFile.setLastModified(dataPublishDate);
                }
                catch (DataFormatException dfe) {
                    this._log.error("Error writing out malformed object as " + key + ": " + data, (Throwable)dfe);
                    dbFile.delete();
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Not writing " + key.toBase64() + ", as its up to date on disk (file mod-publish=" + (dbFile.lastModified() - dataPublishDate) + ")");
            }
        }
        catch (IOException ioe) {
            this._log.error("Error writing out the object", (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private long getPublishDate(DatabaseEntry data) {
        return data.getDate();
    }

    private File getDbDir(String dbDir) throws IOException {
        boolean created;
        SecureDirectory f = new SecureDirectory(this._context.getRouterDir(), dbDir);
        if (!f.exists() && !(created = f.mkdirs())) {
            throw new IOException("Unable to create the DB directory [" + f.getAbsolutePath() + "]");
        }
        if (!f.isDirectory()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not a directory!");
        }
        if (!f.canRead()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not readable!");
        }
        if (!f.canWrite()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not writable!");
        }
        if (this._flat) {
            PersistentDataStore.unmigrate((File)f);
        } else {
            for (int j = 0; j < B64.length(); ++j) {
                SecureDirectory subdir = new SecureDirectory((File)f, DIR_PREFIX + B64.charAt(j));
                if (subdir.exists()) continue;
                subdir.mkdir();
            }
            File[] routerInfoFiles = f.listFiles(RouterInfoFilter.getInstance());
            if (routerInfoFiles != null) {
                PersistentDataStore.migrate((File)f, routerInfoFiles);
            }
        }
        return f;
    }

    private static void unmigrate(File dbdir) {
        for (int j = 0; j < B64.length(); ++j) {
            File subdir = new File(dbdir, DIR_PREFIX + B64.charAt(j));
            File[] files = subdir.listFiles(RouterInfoFilter.getInstance());
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File from = files[i];
                File to = new File(dbdir, from.getName());
                FileUtil.rename((File)from, (File)to);
            }
        }
    }

    private static void migrate(File dbdir, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File from = files[i];
            if (!from.isFile()) continue;
            File dir = new File(dbdir, DIR_PREFIX + from.getName().charAt(ROUTERINFO_PREFIX.length()));
            File to = new File(dir, from.getName());
            FileUtil.rename((File)from, (File)to);
        }
    }

    private static String getLeaseSetName(Hash hash) {
        return LEASESET_PREFIX + hash.toBase64() + ".dat";
    }

    private String getRouterInfoName(Hash hash) {
        String b64 = hash.toBase64();
        if (this._flat) {
            return ROUTERINFO_PREFIX + b64 + ".dat";
        }
        return DIR_PREFIX + b64.charAt(0) + File.separatorChar + ROUTERINFO_PREFIX + b64 + ".dat";
    }

    static Hash getRouterInfoHash(String filename) {
        return PersistentDataStore.getHash(filename, ROUTERINFO_PREFIX, ".dat");
    }

    private static Hash getHash(String filename, String prefix, String suffix) {
        try {
            String key = filename.substring(prefix.length());
            key = key.substring(0, key.length() - suffix.length());
            byte[] b = Base64.decode((String)key);
            if (b == null) {
                return null;
            }
            Hash h = Hash.create((byte[])b);
            return h;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void removeFile(Hash key, File dir) throws IOException {
        String riName = this.getRouterInfoName(key);
        File f = new File(dir, riName);
        if (f.exists()) {
            boolean removed = f.delete();
            if (!removed) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to remove router info at " + f.getAbsolutePath());
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Removed router info at " + f.getAbsolutePath());
            }
            return;
        }
    }

    private class ReadJob
    extends JobImpl {
        private long _lastModified;
        private long _lastReseed;
        private static final int MIN_ROUTERS = 50;
        private static final long MIN_RESEED_INTERVAL = 5400000L;

        public ReadJob() {
            super(PersistentDataStore.this._context);
        }

        @Override
        public String getName() {
            return "DB Read Job";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            boolean shouldScan;
            long now = this.getContext().clock().now();
            long lastMod = PersistentDataStore.this._dbDir.lastModified();
            boolean bl = shouldScan = lastMod > this._lastModified || PersistentDataStore.this.size() < 60;
            if (!shouldScan && !PersistentDataStore.this._flat) {
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    if (subdir.lastModified() <= this._lastModified) continue;
                    shouldScan = true;
                    break;
                }
            }
            if (shouldScan) {
                PersistentDataStore.this._log.info("Rereading new files");
                File file = PersistentDataStore.this._dbDir;
                synchronized (file) {
                    this.readFiles();
                }
                this._lastModified = now;
            }
            this.requeue(120000L);
        }

        public void wakeup() {
            this.requeue(0L);
        }

        private void readFiles() {
            int count;
            int routerCount = 0;
            File[] routerInfoFiles = PersistentDataStore.this._dbDir.listFiles(RouterInfoFilter.getInstance());
            if (PersistentDataStore.this._flat) {
                if (routerInfoFiles != null) {
                    routerCount = routerInfoFiles.length;
                    for (int i = 0; i < routerInfoFiles.length && PersistentDataStore.this._context.router().isAlive(); ++i) {
                        Hash key = PersistentDataStore.getRouterInfoHash(routerInfoFiles[i].getName());
                        if (key == null || PersistentDataStore.this.isKnown(key)) continue;
                        new ReadRouterJob(routerInfoFiles[i], key).runJob();
                    }
                }
            } else {
                if (routerInfoFiles != null) {
                    PersistentDataStore.migrate(PersistentDataStore.this._dbDir, routerInfoFiles);
                }
                ArrayList<File> toRead = new ArrayList<File>(2048);
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    File[] files = subdir.listFiles(RouterInfoFilter.getInstance());
                    if (files == null) continue;
                    long lastMod = subdir.lastModified();
                    if (routerCount >= 50 && lastMod <= this._lastModified) continue;
                    routerCount += files.length;
                    if (lastMod <= this._lastModified) continue;
                    for (int i = 0; i < files.length; ++i) {
                        toRead.add(files[i]);
                    }
                }
                Collections.shuffle(toRead, (Random)PersistentDataStore.this._context.random());
                for (File file : toRead) {
                    Hash key = PersistentDataStore.getRouterInfoHash(file.getName());
                    if (key == null || PersistentDataStore.this.isKnown(key)) continue;
                    new ReadRouterJob(file, key).runJob();
                }
            }
            if (!PersistentDataStore.this._initialized) {
                if (PersistentDataStore.this._facade.reseedChecker().checkReseed(routerCount)) {
                    this._lastReseed = PersistentDataStore.this._context.clock().now();
                }
                PersistentDataStore.this._initialized = true;
            } else if (this._lastReseed < PersistentDataStore.this._context.clock().now() - 5400000L && (count = Math.min(routerCount, PersistentDataStore.this.size())) < 50 && PersistentDataStore.this._facade.reseedChecker().checkReseed(count)) {
                this._lastReseed = PersistentDataStore.this._context.clock().now();
            }
        }
    }

    private class ReadRouterJob
    extends JobImpl {
        private final File _routerFile;
        private final Hash _key;
        private long _knownDate;

        public ReadRouterJob(File routerFile, Hash key) {
            super(PersistentDataStore.this._context);
            this._routerFile = routerFile;
            this._key = key;
        }

        @Override
        public String getName() {
            return "Read RouterInfo";
        }

        private boolean shouldRead() {
            DatabaseEntry data = PersistentDataStore.this.get(this._key, false);
            if (data == null) {
                return true;
            }
            if (data.getType() == 0) {
                this._knownDate = ((RouterInfo)data).getPublished();
                long fileDate = this._routerFile.lastModified();
                return fileDate > this._knownDate + 3600000L;
            }
            PersistentDataStore.this._log.error("Prevented LS overwrite by RI " + this._key + " from " + this._routerFile);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            if (!this.shouldRead()) {
                return;
            }
            if (PersistentDataStore.this._log.shouldLog(10)) {
                PersistentDataStore.this._log.debug("Reading " + this._routerFile);
            }
            InputStream fis = null;
            boolean corrupt = false;
            try {
                fis = new FileInputStream(this._routerFile);
                fis = new BufferedInputStream(fis);
                RouterInfo ri = new RouterInfo();
                ri.readBytes(fis, true);
                if (ri.getNetworkId() != 2) {
                    corrupt = true;
                    if (PersistentDataStore.this._log.shouldLog(40)) {
                        PersistentDataStore.this._log.error("The router " + ri.getIdentity().calculateHash().toBase64() + " is from a different network");
                    }
                } else if (!ri.getIdentity().calculateHash().equals((Object)this._key)) {
                    corrupt = true;
                    if (PersistentDataStore.this._log.shouldLog(30)) {
                        PersistentDataStore.this._log.warn(ri.getIdentity().calculateHash() + " does not match " + this._key + " from " + this._routerFile);
                    }
                } else if (ri.getPublished() <= this._knownDate) {
                    if (PersistentDataStore.this._log.shouldLog(30)) {
                        PersistentDataStore.this._log.warn("Skipping since netdb newer than " + this._routerFile);
                    }
                } else {
                    try {
                        PersistentDataStore.this._facade.store(ri.getIdentity().getHash(), ri, false);
                        this.getContext().profileManager().heardAbout(ri.getIdentity().getHash(), ri.getPublished());
                    }
                    catch (IllegalArgumentException iae) {
                        if (PersistentDataStore.this._log.shouldLog(20)) {
                            PersistentDataStore.this._log.info("Refused locally loaded routerInfo - deleting", (Throwable)iae);
                        }
                        corrupt = true;
                    }
                }
            }
            catch (DataFormatException dfe) {
                if (PersistentDataStore.this._log.shouldLog(20)) {
                    PersistentDataStore.this._log.info("Error reading the routerInfo from " + this._routerFile.getName(), (Throwable)dfe);
                }
                corrupt = true;
            }
            catch (IOException ioe) {
                if (PersistentDataStore.this._log.shouldLog(20)) {
                    PersistentDataStore.this._log.info("Unable to read the router reference in " + this._routerFile.getName(), (Throwable)ioe);
                }
                corrupt = true;
            }
            catch (Exception e) {
                if (PersistentDataStore.this._log.shouldLog(20)) {
                    PersistentDataStore.this._log.info("Unable to read the router reference in " + this._routerFile.getName(), (Throwable)e);
                }
                corrupt = true;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (corrupt) {
                this._routerFile.delete();
            }
        }
    }

    private class RemoveJob
    extends JobImpl {
        private Hash _key;

        public RemoveJob(Hash key) {
            super(PersistentDataStore.this._context);
            this._key = key;
        }

        @Override
        public String getName() {
            return "Delete RI file";
        }

        @Override
        public void runJob() {
            if (PersistentDataStore.this._log.shouldLog(20)) {
                PersistentDataStore.this._log.info("Removing key " + this._key);
            }
            try {
                PersistentDataStore.this.removeFile(this._key, PersistentDataStore.this._dbDir);
            }
            catch (IOException ioe) {
                PersistentDataStore.this._log.error("Error removing key " + this._key, (Throwable)ioe);
            }
        }
    }

    static class RouterInfoFilter
    implements FilenameFilter {
        private static final FilenameFilter _instance = new RouterInfoFilter();

        RouterInfoFilter() {
        }

        public static final FilenameFilter getInstance() {
            return _instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name == null) {
                return false;
            }
            return (name = name.toUpperCase(Locale.US)).startsWith(PersistentDataStore.ROUTERINFO_PREFIX.toUpperCase(Locale.US)) && name.endsWith(".dat".toUpperCase(Locale.US));
        }
    }

    private class Writer
    implements Runnable {
        private final Map<Hash, DatabaseEntry> _keys = new ConcurrentHashMap<Hash, DatabaseEntry>(64);
        private final Object _waitLock = new Object();
        private volatile boolean _quit;

        public void queue(Hash key, DatabaseEntry data) {
            boolean exists;
            int pending = this._keys.size();
            boolean bl = exists = null != this._keys.put(key, data);
            if (exists) {
                PersistentDataStore.this._context.statManager().addRateData("netDb.writeClobber", (long)pending);
            }
            PersistentDataStore.this._context.statManager().addRateData("netDb.writePending", (long)pending);
        }

        public void remove(Hash key) {
            this._keys.remove(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._quit = false;
            Hash key = null;
            DatabaseEntry data = null;
            int count = 0;
            int lastCount = 0;
            long startTime = 0L;
            while (true) {
                Iterator<Map.Entry<Hash, DatabaseEntry>> iter = this._keys.entrySet().iterator();
                try {
                    Map.Entry<Hash, DatabaseEntry> entry = iter.next();
                    key = entry.getKey();
                    data = entry.getValue();
                    iter.remove();
                    ++count;
                }
                catch (NoSuchElementException nsee) {
                    lastCount = count;
                    count = 0;
                }
                catch (IllegalStateException ise) {
                    lastCount = count;
                    count = 0;
                }
                if (key != null) {
                    if (data != null) {
                        File ise = PersistentDataStore.this._dbDir;
                        synchronized (ise) {
                            PersistentDataStore.this.write(key, data);
                        }
                        data = null;
                    }
                    key = null;
                }
                if (count >= 10000) {
                    count = 0;
                }
                if (count != 0) continue;
                if (lastCount > 0) {
                    long time = PersistentDataStore.this._context.clock().now() - startTime;
                    if (PersistentDataStore.this._log.shouldLog(20)) {
                        PersistentDataStore.this._log.info("Wrote " + lastCount + " entries to disk in " + time);
                    }
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeOut", (long)lastCount);
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeTime", time);
                }
                if (this._quit) break;
                Object object = this._waitLock;
                synchronized (object) {
                    try {
                        this._waitLock.wait(600000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                startTime = PersistentDataStore.this._context.clock().now();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = this._waitLock;
            synchronized (object) {
                this._quit = true;
                this._waitLock.notifyAll();
            }
        }
    }
}

