/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.SummaryListener;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class StatSummarizer
implements Runnable {
    private final RouterContext _context = RouterContext.listContexts().get(0);
    private final Log _log = this._context.logManager().getLog(this.getClass());
    private final List<SummaryListener> _listeners = new CopyOnWriteArrayList<SummaryListener>();
    private static StatSummarizer _instance;
    private static final int MAX_CONCURRENT_PNG = 3;
    private final Semaphore _sem;
    private volatile boolean _isRunning = true;
    private boolean _isDisabled;
    private Thread _thread;
    static final String DEFAULT_DATABASES = "bw.sendRate.60000,bw.recvRate.60000,router.memoryUsed.60000,router.activePeers.60000";
    private static final boolean IS_WIN;

    public StatSummarizer() {
        _instance = this;
        this._sem = new Semaphore(3, true);
        this._context.addShutdownTask(new Shutdown());
    }

    public static StatSummarizer instance() {
        return _instance;
    }

    @Override
    public void run() {
        if (SystemVersion.isApache() || SystemVersion.isGNU()) {
            this._log.logAlways(30, "Graphing not supported with this JVM: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ')');
            this._isDisabled = true;
            this._isRunning = false;
            return;
        }
        boolean isPersistent = this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
        if (!isPersistent) {
            this.deleteOldRRDs();
        }
        this._thread = Thread.currentThread();
        String specs = "";
        while (this._isRunning && this._context.router().isAlive()) {
            specs = this.adjustDatabases(specs);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static boolean isDisabled() {
        return _instance == null || StatSummarizer._instance._isDisabled;
    }

    static void setDisabled() {
        if (_instance != null) {
            StatSummarizer._instance._isDisabled = true;
            StatSummarizer._instance._isRunning = false;
        }
    }

    List<SummaryListener> getListeners() {
        return this._listeners;
    }

    private String adjustDatabases(String oldSpecs) {
        String spec = this._context.getProperty("stat.summaries", DEFAULT_DATABASES);
        if (spec == null && oldSpecs == null || spec != null && oldSpecs != null && oldSpecs.equals(spec)) {
            return oldSpecs;
        }
        Set<Rate> old = this.parseSpecs(oldSpecs);
        Set<Rate> newSpecs = this.parseSpecs(spec);
        for (Rate r : old) {
            if (newSpecs.contains(r)) continue;
            this.removeDb(r);
        }
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Rate r : newSpecs) {
            if (!old.contains(r)) {
                this.addDb(r);
            }
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            buf.append(r.getRateStat().getName()).append(".").append(r.getPeriod());
        }
        return buf.toString();
    }

    private void removeDb(Rate r) {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(r)) continue;
            this._listeners.remove(lsnr);
            lsnr.stopListening();
            return;
        }
    }

    private void addDb(Rate r) {
        SummaryListener lsnr = new SummaryListener(r);
        boolean success = lsnr.startListening();
        if (success) {
            this._listeners.add(lsnr);
        } else {
            this._log.error("Failed to add RRD for rate " + r.getRateStat().getName() + '.' + r.getPeriod());
        }
    }

    public boolean renderPng(Rate rate, OutputStream out) throws IOException {
        return this.renderPng(rate, out, 250, 100, false, false, false, false, -1, 0, true);
    }

    public boolean renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                boolean ie = this.locked_renderPng(rate, out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
                return ie;
            }
            catch (NoClassDefFoundError ncdfe) {
                this._isDisabled = true;
                this._isRunning = false;
                String s = "Error rendering - disabling graph generation. Install ttf-dejavu font package?";
                this._log.logAlways(30, s);
                IOException ioe = new IOException(s);
                ioe.initCause(ncdfe);
                throw ioe;
            }
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 250;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        if (end < 0) {
            end = 0;
        }
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
            return true;
        }
        return false;
    }

    public boolean renderPng(OutputStream out, String templateFilename) throws IOException {
        SummaryRenderer.render(this._context, out, templateFilename);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getXML(Rate rate, OutputStream out) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = this.locked_getXML(rate, out);
            return bl;
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_getXML(Rate rate, OutputStream out) throws IOException {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.getData().exportXml(out);
            out.write(("<!-- Rate: " + lsnr.getRate().getRateStat().getName() + " for period " + lsnr.getRate().getPeriod() + " -->\n").getBytes());
            out.write(("<!-- Average data source name: " + lsnr.getName() + " event count data source name: " + lsnr.getEventName() + " -->\n").getBytes());
            return true;
        }
        return false;
    }

    public boolean renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                boolean ie = this.locked_renderRatePng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
                return ie;
            }
            catch (NoClassDefFoundError ncdfe) {
                this._isDisabled = true;
                this._isRunning = false;
                String s = "Error rendering - disabling graph generation. Install ttf-dejavu font package?";
                this._log.logAlways(30, s);
                IOException ioe = new IOException(s);
                ioe.initCause(ncdfe);
                throw ioe;
            }
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        SummaryListener txLsnr = null;
        SummaryListener rxLsnr = null;
        for (SummaryListener lsnr : StatSummarizer.instance().getListeners()) {
            String title = lsnr.getRate().getRateStat().getName();
            if (title.equals("bw.sendRate")) {
                txLsnr = lsnr;
                continue;
            }
            if (!title.equals("bw.recvRate")) continue;
            rxLsnr = lsnr;
        }
        if (txLsnr == null || rxLsnr == null) {
            throw new IOException("no rates for combined graph");
        }
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 250;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        txLsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, rxLsnr, this._("Bandwidth usage"));
        return true;
    }

    Set<Rate> parseSpecs(String specs) {
        if (specs == null) {
            return Collections.emptySet();
        }
        StringTokenizer tok = new StringTokenizer(specs, ",");
        HashSet<Rate> rv = new HashSet<Rate>();
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            int split = spec.lastIndexOf(46);
            if (split <= 0 || split + 1 >= spec.length()) continue;
            String name = spec.substring(0, split);
            String per = spec.substring(split + 1);
            long period = -1L;
            try {
                Rate r;
                period = Long.parseLong(per);
                RateStat rs = this._context.statManager().getRate(name);
                if (rs == null || (r = rs.getRate(period)) == null) continue;
                rv.add(r);
            }
            catch (NumberFormatException nfe) {}
        }
        return rv;
    }

    private void deleteOldRRDs() {
        File rrdDir = new File(this._context.getRouterDir(), "rrd");
        FileUtil.rmdir(rrdDir, false);
    }

    private String _(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    static {
        IS_WIN = SystemVersion.isWindows();
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            StatSummarizer.this._isRunning = false;
            if (StatSummarizer.this._thread != null) {
                StatSummarizer.this._thread.interrupt();
            }
            for (SummaryListener lsnr : StatSummarizer.this._listeners) {
                lsnr.stopListening();
            }
            StatSummarizer.this._listeners.clear();
        }
    }
}

