/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.bencode;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import net.i2p.data.Base64;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class BEValue {
    private final Object value;

    public BEValue(byte[] value) {
        this.value = value;
    }

    public BEValue(Number value) {
        this.value = value;
    }

    public BEValue(List<BEValue> value) {
        this.value = value;
    }

    public BEValue(Map<String, BEValue> value) {
        this.value = value;
    }

    public String getString() throws InvalidBEncodingException {
        try {
            return new String(this.getBytes(), "UTF-8");
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError(uee.toString());
        }
    }

    public byte[] getBytes() throws InvalidBEncodingException {
        try {
            return (byte[])this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Number getNumber() throws InvalidBEncodingException {
        try {
            return (Number)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public int getInt() throws InvalidBEncodingException {
        return this.getNumber().intValue();
    }

    public long getLong() throws InvalidBEncodingException {
        return this.getNumber().longValue();
    }

    public List<BEValue> getList() throws InvalidBEncodingException {
        try {
            return (List)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Map<String, BEValue> getMap() throws InvalidBEncodingException {
        try {
            return (Map)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String valueString;
        if (this.value instanceof byte[]) {
            byte[] bs = (byte[])this.value;
            if (bs.length == 0) {
                valueString = "0 bytes";
            } else if (bs.length <= 32) {
                int b;
                int i;
                StringBuilder buf = new StringBuilder(32);
                boolean bin = false;
                for (i = 0; i < bs.length; ++i) {
                    b = bs[i] & 0xFF;
                    if (b >= 32 && b <= 126) continue;
                    bin = true;
                    break;
                }
                if (bin && bs.length <= 8) {
                    buf.append(bs.length).append(" bytes: 0x");
                    for (i = 0; i < bs.length; ++i) {
                        b = bs[i] & 0xFF;
                        if (b < 16) {
                            buf.append('0');
                        }
                        buf.append(Integer.toHexString(b));
                    }
                } else if (bin) {
                    buf.append(bs.length).append(" bytes: ").append(Base64.encode(bs));
                } else {
                    buf.append('\"').append(new String(bs)).append('\"');
                }
                valueString = buf.toString();
            } else {
                valueString = bs.length + " bytes";
            }
        } else {
            valueString = this.value.toString();
        }
        return "BEValue[" + valueString + "]";
    }
}

