/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.I2PAppThread;

public class I2PSource
implements Source,
Runnable {
    protected final I2PSession sess;
    protected final BlockingQueue<Integer> queue;
    protected Sink sink;
    protected final Thread thread;
    protected final boolean verify;
    protected final boolean raw;

    public I2PSource(I2PSession sess) {
        this(sess, true, false);
    }

    public I2PSource(I2PSession sess, boolean verify) {
        this(sess, verify, false);
    }

    public I2PSource(I2PSession sess, boolean verify, boolean raw) {
        this.sess = sess;
        this.verify = verify;
        this.raw = raw;
        this.queue = new ArrayBlockingQueue<Integer>(256);
        this.sess.setSessionListener(new Listener());
        this.thread = new I2PAppThread(this);
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        I2PDatagramDissector diss = new I2PDatagramDissector();
        while (true) {
            try {
                while (true) {
                    int id = this.queue.take();
                    byte[] msg = this.sess.receiveMessage(id);
                    if (!this.raw) {
                        diss.loadI2PDatagram(msg);
                        if (this.verify) {
                            this.sink.send(diss.getSender(), diss.getPayload());
                            continue;
                        }
                        this.sink.send(diss.extractSender(), diss.extractPayload());
                        continue;
                    }
                    this.sink.send(null, msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected class Listener
    implements I2PSessionListener {
        protected Listener() {
        }

        @Override
        public void messageAvailable(I2PSession sess, int id, long size) {
            try {
                I2PSource.this.queue.put(id);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public void reportAbuse(I2PSession arg0, int arg1) {
        }

        @Override
        public void disconnected(I2PSession arg0) {
        }

        @Override
        public void errorOccurred(I2PSession arg0, String arg1, Throwable arg2) {
        }
    }
}

