/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.crypto.SigType;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;

public class TunnelController
implements Logging {
    private final Log _log;
    private Properties _config;
    private final I2PTunnel _tunnel = new I2PTunnel();
    private final List<String> _messages;
    private List<I2PSession> _sessions;
    private boolean _running;
    private boolean _starting;
    public static final String KEY_BACKUP_DIR = "i2ptunnel-keyBackup";
    public static final String PROP_DESCR = "description";
    public static final String PROP_DEST = "targetDestination";
    public static final String PROP_I2CP_HOST = "i2cpHost";
    public static final String PROP_I2CP_PORT = "i2cpPort";
    public static final String PROP_INTFC = "interface";
    public static final String PROP_FILE = "privKeyFile";
    public static final String PROP_LISTEN_PORT = "listenPort";
    public static final String PROP_NAME = "name";
    public static final String PROP_PROXIES = "proxyList";
    public static final String PROP_SHARED = "sharedClient";
    public static final String PROP_SPOOFED_HOST = "spoofedHost";
    public static final String PROP_START = "startOnLoad";
    public static final String PROP_TARGET_HOST = "targetHost";
    public static final String PROP_TARGET_PORT = "targetPort";
    public static final String PROP_TYPE = "type";
    public static final String PFX_OPTION = "option.";
    private static final String OPT_PERSISTENT = "option.persistentClientKey";
    private static final String OPT_BUNDLE_REPLY = "option.shouldBundleReplyInfo";
    private static final String OPT_TAGS_SEND = "option.crypto.tagsToSend";
    private static final String OPT_LOW_TAGS = "option.crypto.lowTagThreshold";
    private static final String OPT_SIG_TYPE = "option.i2cp.destination.sigType";
    public static final String TYPE_CONNECT = "connectclient";
    public static final String TYPE_HTTP_BIDIR_SERVER = "httpbidirserver";
    public static final String TYPE_HTTP_CLIENT = "httpclient";
    public static final String TYPE_HTTP_SERVER = "httpserver";
    public static final String TYPE_IRC_CLIENT = "ircclient";
    public static final String TYPE_IRC_SERVER = "ircserver";
    public static final String TYPE_SOCKS = "sockstunnel";
    public static final String TYPE_SOCKS_IRC = "socksirctunnel";
    public static final String TYPE_STD_CLIENT = "client";
    public static final String TYPE_STD_SERVER = "server";
    public static final String TYPE_STREAMR_CLIENT = "streamrclient";
    public static final String TYPE_STREAMR_SERVER = "streamrserver";

    public TunnelController(Properties config, String prefix) {
        this(config, prefix, true);
    }

    public TunnelController(Properties config, String prefix, boolean createKey) {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(TunnelController.class);
        this.setConfig(config, prefix);
        this._messages = new ArrayList<String>(4);
        this._running = false;
        boolean keyOK = true;
        if (createKey && (this.getType().endsWith(TYPE_STD_SERVER) || this.getPersistentClientKey())) {
            keyOK = this.createPrivateKey();
        }
        this._starting = keyOK && this.getStartOnLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPrivateKey() {
        I2PClient client = I2PClientFactory.createClient();
        String filename = this.getPrivKeyFile();
        if (filename == null || filename.trim().length() <= 0) {
            this.log("No filename specified for the private key");
            return false;
        }
        File keyFile = new File(this.getPrivKeyFile());
        if (!keyFile.isAbsolute()) {
            keyFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.getPrivKeyFile());
        }
        if (keyFile.exists()) {
            return true;
        }
        File parent = keyFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        SecureFileOutputStream fos = null;
        try {
            String name;
            File backup;
            fos = new SecureFileOutputStream(keyFile);
            SigType stype = I2PClient.DEFAULT_SIGTYPE;
            String st = this._config.getProperty(OPT_SIG_TYPE);
            if (st != null) {
                SigType type = SigType.parseSigType(st);
                if (type != null) {
                    stype = type;
                } else {
                    this.log("Unsupported sig type " + st + ", reverting to " + (Object)((Object)stype));
                }
            }
            Destination dest = client.createDestination((OutputStream)fos, stype);
            String destStr = dest.toBase64();
            this.log("Private key created and saved in " + keyFile.getAbsolutePath());
            this.log("You should backup this file in a secure place.");
            this.log("New destination: " + destStr);
            String b32 = dest.toBase32();
            this.log("Base32: " + b32);
            SecureFile backupDir = new SecureFile(I2PAppContext.getGlobalContext().getConfigDir(), KEY_BACKUP_DIR);
            if ((backupDir.isDirectory() || ((File)backupDir).mkdir()) && FileUtil.copy(keyFile, backup = new File(backupDir, name = b32 + '-' + I2PAppContext.getGlobalContext().clock().now() + ".dat"), false, true)) {
                this.log("Private key backup saved to " + backup.getAbsolutePath());
            }
        }
        catch (I2PException ie) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error creating new destination", ie);
            }
            this.log("Error creating new destination: " + ie.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error creating writing the destination to " + keyFile.getAbsolutePath(), ioe);
            }
            this.log("Error writing the keys to " + keyFile.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public void startTunnelBackground() {
        if (this._running) {
            return;
        }
        this._starting = true;
        new I2PAppThread(new Runnable(){

            @Override
            public void run() {
                TunnelController.this.startTunnel();
            }
        }).start();
    }

    public void startTunnel() {
        this._starting = true;
        try {
            this.doStartTunnel();
        }
        catch (Exception e) {
            this._log.error("Error starting the tunnel " + this.getName(), e);
            this.log("Error starting the tunnel " + this.getName() + ": " + e.getMessage());
            this.acquire();
            this.stopTunnel();
        }
        this._starting = false;
    }

    private void doStartTunnel() {
        boolean ok;
        if (this._running) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already running");
            }
            this.log("Tunnel " + this.getName() + " is already running");
            return;
        }
        String type = this.getType();
        if (type == null || type.length() <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start the tunnel - no type specified");
            }
            return;
        }
        if ((type.endsWith(TYPE_STD_SERVER) || this.getPersistentClientKey()) && !(ok = this.createPrivateKey())) {
            this.log("Failed to start tunnel " + this.getName() + " as the private key file could not be created");
            return;
        }
        this.setI2CPOptions();
        this.setSessionOptions();
        if (TYPE_HTTP_CLIENT.equals(type)) {
            this.startHttpClient();
        } else if (TYPE_IRC_CLIENT.equals(type)) {
            this.startIrcClient();
        } else if (TYPE_SOCKS.equals(type)) {
            this.startSocksClient();
        } else if (TYPE_SOCKS_IRC.equals(type)) {
            this.startSocksIRCClient();
        } else if (TYPE_CONNECT.equals(type)) {
            this.startConnectClient();
        } else if (TYPE_STD_CLIENT.equals(type)) {
            this.startClient();
        } else if (TYPE_STREAMR_CLIENT.equals(type)) {
            this.startStreamrClient();
        } else if (TYPE_STD_SERVER.equals(type)) {
            this.startServer();
        } else if (TYPE_HTTP_SERVER.equals(type)) {
            this.startHttpServer();
        } else if (TYPE_HTTP_BIDIR_SERVER.equals(type)) {
            this.startHttpBidirServer();
        } else if (TYPE_IRC_SERVER.equals(type)) {
            this.startIrcServer();
        } else if (TYPE_STREAMR_SERVER.equals(type)) {
            this.startStreamrServer();
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start tunnel - unknown type [" + type + "]");
            }
            return;
        }
        this.acquire();
        this._running = true;
    }

    private void startHttpClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startConnectClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startIrcClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startSocksClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runSOCKSTunnel(new String[]{listenPort, "false", privKeyFile}, this);
        } else {
            this._tunnel.runSOCKSTunnel(new String[]{listenPort, sharedClient}, this);
        }
    }

    private void startSocksIRCClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, "false", privKeyFile}, this);
        } else {
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, sharedClient}, this);
        }
    }

    private void startStreamrClient() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getListenPort();
        String dest = this.getTargetDestination();
        this._tunnel.runStreamrClient(new String[]{targetHost, targetPort, dest}, this);
    }

    private void startStreamrServer() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
        String listenPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runStreamrServer(new String[]{listenPort, privKeyFile}, this);
    }

    private void acquire() {
        List<I2PSession> sessions = this._tunnel.getSessions();
        if (!sessions.isEmpty()) {
            for (int i = 0; i < sessions.size(); ++i) {
                TunnelControllerGroup group;
                I2PSession session = sessions.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Acquiring session " + session);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.acquire(this, session);
            }
            this._sessions = sessions;
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to acquire? for " + this.getName());
        }
    }

    private void release(Collection<I2PSession> sessions) {
        if (!sessions.isEmpty()) {
            for (I2PSession s : sessions) {
                TunnelControllerGroup group;
                if (this._log.shouldLog(20)) {
                    this._log.info("Releasing session " + s);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.release(this, s);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to release? for " + this.getName());
        }
    }

    private Collection<I2PSession> getAllSessions() {
        HashSet<I2PSession> sessions = new HashSet<I2PSession>(this._tunnel.getSessions());
        if (this._sessions != null) {
            sessions.addAll(this._sessions);
        }
        return sessions;
    }

    private void startClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void startHttpServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpServer(new String[]{targetHost, targetPort, spoofedHost, privKeyFile}, this);
    }

    private void startHttpBidirServer() {
        this.setListenOn();
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String listenPort = this.getListenPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpBidirServer(new String[]{targetHost, targetPort, listenPort, spoofedHost, privKeyFile}, this);
    }

    private void startIrcServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runIrcServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void setListenOn() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
    }

    public Properties getClientOptionProps() {
        Properties opts = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(PFX_OPTION)) continue;
            key = key.substring(PFX_OPTION.length());
            String val = (String)e.getValue();
            opts.setProperty(key, val);
        }
        return opts;
    }

    private void setSessionOptions() {
        String targetport;
        String targethost;
        String spoofhost;
        String proxies;
        Properties opts = this.getClientOptionProps();
        String target = this.getTargetDestination();
        if (target != null) {
            opts.setProperty(PROP_DEST, target);
        }
        if ((proxies = this.getProxyList()) != null) {
            opts.setProperty(PROP_PROXIES, proxies);
        }
        if ((spoofhost = this.getSpoofedHost()) != null) {
            opts.setProperty(PROP_SPOOFED_HOST, spoofhost);
        }
        if ((targethost = this.getTargetHost()) != null) {
            opts.setProperty(PROP_TARGET_HOST, targethost);
        }
        if ((targetport = this.getTargetPort()) != null) {
            opts.setProperty(PROP_TARGET_PORT, targetport);
        }
        this._tunnel.setClientOptions(opts);
    }

    private void setI2CPOptions() {
        String port;
        String host = this.getI2CPHost();
        if (host != null && host.length() > 0) {
            this._tunnel.host = host;
        }
        if ("localhost".equals(this._tunnel.host)) {
            this._tunnel.host = "127.0.0.1";
        }
        if ((port = this.getI2CPPort()) != null && port.length() > 0) {
            try {
                int portNum = Integer.parseInt(port);
                this._tunnel.port = String.valueOf(portNum);
            }
            catch (NumberFormatException nfe) {
                this._tunnel.port = "7654";
            }
        } else {
            this._tunnel.port = "7654";
        }
    }

    public void stopTunnel() {
        Collection<I2PSession> sessions = this.getAllSessions();
        this._tunnel.runClose(new String[]{"forced", "all"}, this);
        this.release(sessions);
        this._running = false;
    }

    public void restartTunnel() {
        this.stopTunnel();
        this.startTunnel();
    }

    public void setConfig(Properties config, String prefix) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> e : config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            String val = (String)e.getValue();
            props.setProperty(key, val);
        }
        this._config = props;
        String type = this.getType();
        if (type != null) {
            if (type.equals(TYPE_HTTP_SERVER) || type.equals(TYPE_STREAMR_SERVER)) {
                if (!this._config.containsKey(OPT_BUNDLE_REPLY)) {
                    this._config.setProperty(OPT_BUNDLE_REPLY, "false");
                }
            } else if (type.contains("irc") || type.equals(TYPE_STREAMR_CLIENT)) {
                if (!this._config.containsKey(OPT_TAGS_SEND)) {
                    this._config.setProperty(OPT_TAGS_SEND, "20");
                }
                if (!this._config.containsKey(OPT_LOW_TAGS)) {
                    this._config.setProperty(OPT_LOW_TAGS, "14");
                }
            }
            if ((type.equals(TYPE_IRC_CLIENT) || type.equals(TYPE_STD_CLIENT) || type.equals(TYPE_SOCKS_IRC)) && !Boolean.valueOf(this.getSharedClient()).booleanValue() && !this._config.containsKey(OPT_SIG_TYPE) && SigType.ECDSA_SHA256_P256.isAvailable()) {
                this._config.setProperty(OPT_SIG_TYPE, "ECDSA_SHA256_P256");
            }
        }
        this.setSessionOptions();
        if (this._running) {
            Collection<I2PSession> sessions = this.getAllSessions();
            if (sessions.isEmpty() && this._log.shouldLog(10)) {
                this._log.debug("Running but no sessions to update");
            }
            for (I2PSession s : sessions) {
                if (!s.isClosed()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Session is open, updating: " + s);
                    }
                    s.updateOptions(this._tunnel.getClientOptions());
                    continue;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Session is closed, not updating: " + s);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Not running, not updating sessions");
        }
    }

    public Properties getConfig(String prefix) {
        Properties rv = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            rv.setProperty(prefix + key, val);
        }
        return rv;
    }

    public String getType() {
        return this._config.getProperty(PROP_TYPE);
    }

    public String getName() {
        return this._config.getProperty(PROP_NAME);
    }

    public String getDescription() {
        return this._config.getProperty(PROP_DESCR);
    }

    public String getI2CPHost() {
        return this._config.getProperty(PROP_I2CP_HOST);
    }

    public String getI2CPPort() {
        return this._config.getProperty(PROP_I2CP_PORT);
    }

    public String getClientOptions() {
        StringBuilder opts = new StringBuilder(64);
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(PFX_OPTION)) continue;
            key = key.substring(PFX_OPTION.length());
            String val = (String)e.getValue();
            if (opts.length() > 0) {
                opts.append(' ');
            }
            opts.append(key).append('=').append(val);
        }
        return opts.toString();
    }

    public String getListenOnInterface() {
        return this._config.getProperty(PROP_INTFC);
    }

    public String getTargetHost() {
        return this._config.getProperty(PROP_TARGET_HOST);
    }

    public String getTargetPort() {
        return this._config.getProperty(PROP_TARGET_PORT);
    }

    public String getSpoofedHost() {
        return this._config.getProperty(PROP_SPOOFED_HOST);
    }

    public String getPrivKeyFile() {
        return this._config.getProperty(PROP_FILE);
    }

    public String getListenPort() {
        return this._config.getProperty(PROP_LISTEN_PORT);
    }

    public String getTargetDestination() {
        return this._config.getProperty(PROP_DEST);
    }

    public String getProxyList() {
        return this._config.getProperty(PROP_PROXIES);
    }

    public String getSharedClient() {
        return this._config.getProperty(PROP_SHARED, "true");
    }

    public boolean getStartOnLoad() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_START, "true"));
    }

    public boolean getPersistentClientKey() {
        return Boolean.parseBoolean(this._config.getProperty(OPT_PERSISTENT));
    }

    public String getMyDestination() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return dest.toBase64();
            }
        }
        return null;
    }

    public String getMyDestHashBase32() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return dest.toBase32();
            }
        }
        return null;
    }

    public boolean getIsRunning() {
        return this._running;
    }

    public boolean getIsStarting() {
        return this._starting;
    }

    public boolean getIsStandby() {
        if (!this._running) {
            return false;
        }
        for (I2PSession sess : this._tunnel.getSessions()) {
            if (sess.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void getSummary(StringBuilder buf) {
        String type = this.getType();
        buf.append(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String s) {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            this._messages.add(s);
            while (this._messages.size() > 10) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clearMessages() {
        ArrayList<String> rv = null;
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            rv = new ArrayList<String>(this._messages);
            this._messages.clear();
        }
        return rv;
    }

    public String toString() {
        return "TC " + this.getType() + ' ' + this.getName() + " for " + this._tunnel;
    }
}

