/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMUtils;
import net.i2p.util.HexDump;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

abstract class SAMMessageSession {
    protected final Log _log;
    private I2PSession session;
    private SAMMessageSessionHandler handler;

    protected SAMMessageSession(String dest, Properties props) throws IOException, DataFormatException, I2PSessionException {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(dest));
        this.initSAMMessageSession(bais, props);
    }

    protected SAMMessageSession(InputStream destStream, Properties props) throws IOException, DataFormatException, I2PSessionException {
        this._log = new Log(this.getClass());
        this.initSAMMessageSession(destStream, props);
    }

    private void initSAMMessageSession(InputStream destStream, Properties props) throws IOException, DataFormatException, I2PSessionException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Initializing SAM message-based session");
        }
        this.handler = new SAMMessageSessionHandler(destStream, props);
        I2PAppThread t = new I2PAppThread(this.handler, "SAMMessageSessionHandler");
        t.start();
    }

    public Destination getDestination() {
        return this.session.getMyDestination();
    }

    public abstract boolean sendBytes(String var1, byte[] var2) throws DataFormatException;

    protected boolean sendBytesThroughMessageSession(String dest, byte[] data, int proto, int fromPort, int toPort) throws DataFormatException {
        Destination d = SAMUtils.getDest(dest);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + data.length + " bytes to " + dest);
        }
        try {
            return this.session.sendMessage(d, data, proto, fromPort, toPort);
        }
        catch (I2PSessionException e) {
            this._log.error("I2PSessionException while sending data", e);
            return false;
        }
    }

    public void close() {
        this.handler.stopRunning();
    }

    protected abstract void messageReceived(byte[] var1);

    protected abstract void shutDown();

    protected I2PSession getI2PSession() {
        return this.session;
    }

    class SAMMessageSessionHandler
    implements Runnable,
    I2PSessionListener {
        private final Object runningLock = new Object();
        private volatile boolean stillRunning = true;

        public SAMMessageSessionHandler(InputStream destStream, Properties props) throws I2PSessionException {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Instantiating new SAM message-based session handler");
            }
            I2PClient client = I2PClientFactory.createClient();
            if (!props.containsKey("inbound.nickname") && !props.containsKey("outbound.nickname")) {
                props.setProperty("inbound.nickname", "SAM UDP Client");
                props.setProperty("outbound.nickname", "SAM UDP Client");
            }
            SAMMessageSession.this.session = client.createSession(destStream, props);
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Connecting I2P session...");
            }
            SAMMessageSession.this.session.connect();
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P session connected");
            }
            SAMMessageSession.this.session.setSessionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stopRunning() {
            Object object = this.runningLock;
            synchronized (object) {
                this.stillRunning = false;
                this.runningLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("SAM message-based session handler running");
            }
            Object object = this.runningLock;
            synchronized (object) {
                while (this.stillRunning) {
                    try {
                        this.runningLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Shutting down SAM message-based session handler");
            }
            SAMMessageSession.this.shutDown();
            try {
                if (SAMMessageSession.this._log.shouldLog(10)) {
                    SAMMessageSession.this._log.debug("Destroying I2P session...");
                }
                SAMMessageSession.this.session.destroySession();
                if (SAMMessageSession.this._log.shouldLog(10)) {
                    SAMMessageSession.this._log.debug("I2P session destroyed");
                }
            }
            catch (I2PSessionException e) {
                SAMMessageSession.this._log.error("Error destroying I2P session", e);
            }
        }

        @Override
        public void disconnected(I2PSession session) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P session disconnected");
            }
            this.stopRunning();
        }

        @Override
        public void errorOccurred(I2PSession session, String message, Throwable error) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P error: " + message, error);
            }
            this.stopRunning();
        }

        @Override
        public void messageAvailable(I2PSession session, int msgId, long size) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P message available (id: " + msgId + "; size: " + size + ")");
            }
            try {
                byte[] msg = session.receiveMessage(msgId);
                if (msg == null) {
                    return;
                }
                if (SAMMessageSession.this._log.shouldLog(10)) {
                    SAMMessageSession.this._log.debug("Content of message " + msgId + ":\n" + HexDump.dump(msg));
                }
                SAMMessageSession.this.messageReceived(msg);
            }
            catch (I2PSessionException e) {
                SAMMessageSession.this._log.error("Error fetching I2P message", e);
                this.stopRunning();
            }
        }

        @Override
        public void reportAbuse(I2PSession session, int severity) {
            SAMMessageSession.this._log.warn("Abuse reported (severity: " + severity + ")");
            this.stopRunning();
        }
    }
}

