/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Date;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.data.Signature;
import net.i2p.router.web.HelperBase;

public class ProofHelper
extends HelperBase {
    public String getProof() {
        StringBuilder buf = new StringBuilder(512);
        RouterInfo us = this._context.router().getRouterInfo();
        buf.append("Hash: ").append(us.getIdentity().calculateHash().toBase64()).append('\n');
        for (RouterAddress addr : us.getAddresses()) {
            buf.append(addr.getTransportStyle()).append(": ").append(addr.getHost()).append('\n');
        }
        buf.append("Caps: ").append(us.getCapabilities()).append('\n');
        buf.append("Date: ").append(new Date());
        String msg = buf.toString();
        byte[] data = DataHelper.getUTF8(msg);
        Signature sig = this._context.dsa().sign(data, this._context.keyManager().getSigningPrivateKey());
        buf.setLength(0);
        buf.append("---BEGIN I2P SIGNED MESSAGE---\n");
        buf.append(msg);
        buf.append("\n---BEGIN I2P SIGNATURE---\n");
        buf.append(sig.toBase64());
        buf.append("\n---END I2P SIGNATURE---");
        return buf.toString();
    }
}

