/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

public class ConfigUIHelper
extends HelperBase {
    static final String PROP_THEME_PFX = "routerconsole.theme.";
    private static final String[][] langs = new String[][]{{"ar", "lang_ar", ConfigUIHelper._x("Arabic"), null}, {"cs", "cz", ConfigUIHelper._x("Czech"), null}, {"da", "dk", ConfigUIHelper._x("Danish"), null}, {"de", "de", ConfigUIHelper._x("German"), null}, {"et", "ee", ConfigUIHelper._x("Estonian"), null}, {"el", "gr", ConfigUIHelper._x("Greek"), null}, {"en", "us", ConfigUIHelper._x("English"), null}, {"es", "es", ConfigUIHelper._x("Spanish"), null}, {"fi", "fi", ConfigUIHelper._x("Finnish"), null}, {"fr", "fr", ConfigUIHelper._x("French"), null}, {"hu", "hu", ConfigUIHelper._x("Hungarian"), null}, {"it", "it", ConfigUIHelper._x("Italian"), null}, {"ja", "jp", ConfigUIHelper._x("Japanese"), null}, {"nl", "nl", ConfigUIHelper._x("Dutch"), null}, {"nb", "no", ConfigUIHelper._x("Norwegian Bokmaal"), null}, {"pl", "pl", ConfigUIHelper._x("Polish"), null}, {"pt", "pt", ConfigUIHelper._x("Portuguese"), null}, {"pt_BR", "br", ConfigUIHelper._x("Portuguese"), "Brazil"}, {"ro", "ro", ConfigUIHelper._x("Romanian"), null}, {"ru", "ru", ConfigUIHelper._x("Russian"), null}, {"sk", "sk", ConfigUIHelper._x("Slovak"), null}, {"sv", "se", ConfigUIHelper._x("Swedish"), null}, {"tr", "tr", ConfigUIHelper._x("Turkish"), null}, {"uk", "ua", ConfigUIHelper._x("Ukrainian"), null}, {"vi", "vn", ConfigUIHelper._x("Vietnamese"), null}, {"zh", "cn", ConfigUIHelper._x("Chinese"), null}};

    public String getSettings() {
        StringBuilder buf = new StringBuilder(512);
        String current = this._context.getProperty("routerconsole.theme", "light");
        Set<String> themes = this.themeSet();
        for (String theme : themes) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"theme\" ");
            if (theme.equals(current)) {
                buf.append("checked=\"checked\" ");
            }
            buf.append("value=\"").append(theme).append("\">").append(this._(theme)).append("<br>\n");
        }
        boolean universalTheming = this._context.getBooleanProperty("routerconsole.universal.theme");
        buf.append("<input type=\"checkbox\" name=\"universalTheming\" ");
        if (universalTheming) {
            buf.append("checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._("Set theme universally across all apps")).append("<br>\n");
        return buf.toString();
    }

    public String getForceMobileConsole() {
        StringBuilder buf = new StringBuilder(256);
        boolean forceMobileConsole = this._context.getBooleanProperty("routerconsole.forceMobileConsole");
        buf.append("<input type=\"checkbox\" name=\"forceMobileConsole\" ");
        if (forceMobileConsole) {
            buf.append("checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._("Force the mobile console to be used")).append("<br>\n");
        return buf.toString();
    }

    private Set<String> themeSet() {
        TreeSet<String> rv = new TreeSet<String>();
        rv.add("light");
        File dir = new File(this._context.getBaseDir(), "docs/themes/console");
        File[] files = dir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!files[i].isDirectory() || name.equals("images")) continue;
            rv.add(name);
        }
        Set<String> props = this._context.getPropertyNames();
        for (String prop : props) {
            if (!prop.startsWith(PROP_THEME_PFX) || prop.length() <= PROP_THEME_PFX.length()) continue;
            rv.add(prop.substring(PROP_THEME_PFX.length()));
        }
        return rv;
    }

    public String getLangSettings() {
        int i;
        String clang;
        String current = clang = Messages.getLanguage(this._context);
        String country = Messages.getCountry(this._context);
        if (country != null && country.length() > 0) {
            current = current + '_' + country;
        }
        boolean found = false;
        for (i = 0; i < langs.length; ++i) {
            if (!langs[i][0].equals(current)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (country != null && country.length() > 0) {
                current = clang;
                for (i = 0; i < langs.length; ++i) {
                    if (!langs[i][0].equals(current)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                current = "en";
            }
        }
        StringBuilder buf = new StringBuilder(512);
        for (int i2 = 0; i2 < langs.length; ++i2) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"lang\" ");
            String lang = langs[i2][0];
            if (lang.equals(current)) {
                buf.append("checked=\"checked\" ");
            }
            buf.append("value=\"").append(lang).append("\">").append("<img height=\"11\" width=\"16\" alt=\"\" src=\"/flags.jsp?c=").append(langs[i2][1]).append("\"> ");
            int under = lang.indexOf(95);
            String slang = under > 0 ? lang.substring(0, under) : lang;
            buf.append(Messages.getDisplayLanguage(slang, langs[i2][2], this._context));
            String name = langs[i2][3];
            if (name != null) {
                buf.append(" (").append(Messages.getString(name, this._context, "net.i2p.router.countries.messages")).append(')');
            }
            buf.append("<br>\n");
        }
        return buf.toString();
    }

    public String getPasswordForm() {
        StringBuilder buf = new StringBuilder(512);
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        Map<String, String> userpw = mgr.getMD5("routerconsole.auth.i2prouter");
        buf.append("<table>");
        if (userpw.isEmpty()) {
            buf.append("<tr><td colspan=\"3\">");
            buf.append(this._("Add a user and password to enable."));
            buf.append("</td></tr>");
        } else {
            buf.append("<tr><th>").append(this._("Remove")).append("</th><th>").append(this._("User Name")).append("</th><th>&nbsp;</th></tr>\n");
            for (String name : userpw.keySet()) {
                buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" name=\"delete_").append(name).append("\"></td><td colspan=\"2\">").append(name).append("</td></tr>\n");
            }
        }
        buf.append("<tr><td align=\"center\"><b>").append(this._("Add")).append(":</b></td><td align=\"left\"><input type=\"text\" name=\"name\"></td><td align=\"left\"><b>");
        buf.append(this._("Password")).append(":</b> <input type=\"password\" size=\"40\" name=\"nofilter_pw\"></td></tr></table>\n");
        return buf.toString();
    }
}

