/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.crypto.SigType;
import net.i2p.util.Log;

public class I2PSocketManagerFactory {
    public static final String PROP_MANAGER = "i2p.streaming.manager";
    public static final String DEFAULT_MANAGER = "net.i2p.client.streaming.impl.I2PSocketManagerFull";

    public static I2PSocketManager createManager() {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), (Properties)System.getProperties().clone());
    }

    public static I2PSocketManager createManager(Properties opts) {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts);
    }

    public static I2PSocketManager createManager(String host, int port) {
        return I2PSocketManagerFactory.createManager(host, port, (Properties)System.getProperties().clone());
    }

    public static I2PSocketManager createManager(String i2cpHost, int i2cpPort, Properties opts) {
        I2PClient client = I2PClientFactory.createClient();
        ByteArrayOutputStream keyStream = new ByteArrayOutputStream(1024);
        try {
            client.createDestination((OutputStream)keyStream, I2PSocketManagerFactory.getSigType(opts));
            ByteArrayInputStream in = new ByteArrayInputStream(keyStream.toByteArray());
            return I2PSocketManagerFactory.createManager(in, i2cpHost, i2cpPort, opts);
        }
        catch (IOException ioe) {
            I2PSocketManagerFactory.getLog().error("Error creating the destination for socket manager", (Throwable)ioe);
            return null;
        }
        catch (I2PException ie) {
            I2PSocketManagerFactory.getLog().error("Error creating the destination for socket manager", (Throwable)ie);
            return null;
        }
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), (Properties)System.getProperties().clone());
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, Properties opts) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts) {
        try {
            return I2PSocketManagerFactory.createManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, true);
        }
        catch (I2PSessionException ise) {
            I2PSocketManagerFactory.getLog().error("Error creating session for socket manager", (Throwable)ise);
            return null;
        }
    }

    public static I2PSocketManager createDisconnectedManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts) throws I2PSessionException {
        if (myPrivateKeyStream == null) {
            I2PClient client = I2PClientFactory.createClient();
            ByteArrayOutputStream keyStream = new ByteArrayOutputStream(1024);
            try {
                client.createDestination((OutputStream)keyStream, I2PSocketManagerFactory.getSigType(opts));
            }
            catch (Exception e) {
                throw new I2PSessionException("Error creating keys", (Throwable)e);
            }
            myPrivateKeyStream = new ByteArrayInputStream(keyStream.toByteArray());
        }
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, i2cpHost, i2cpPort, opts, false);
    }

    private static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts, boolean connect) throws I2PSessionException {
        I2PClient client = I2PClientFactory.createClient();
        if (opts == null) {
            opts = new Properties();
        }
        Properties syscopy = (Properties)System.getProperties().clone();
        for (Map.Entry<Object, Object> e : syscopy.entrySet()) {
            String name = (String)e.getKey();
            if (opts.containsKey(name)) continue;
            opts.setProperty(name, (String)e.getValue());
        }
        if (!opts.containsKey("i2cp.messageReliability")) {
            opts.setProperty("i2cp.messageReliability", "none");
        }
        if (i2cpHost != null) {
            opts.setProperty("i2cp.tcp.host", i2cpHost);
        }
        if (i2cpPort > 0) {
            opts.setProperty("i2cp.tcp.port", "" + i2cpPort);
        }
        I2PSession session = client.createSession(myPrivateKeyStream, opts);
        if (connect) {
            session.connect();
        }
        I2PSocketManager sockMgr = I2PSocketManagerFactory.createManager(session, opts, "manager");
        return sockMgr;
    }

    private static I2PSocketManager createManager(I2PSession session, Properties opts, String name) {
        I2PAppContext context = I2PAppContext.getGlobalContext();
        String classname = DEFAULT_MANAGER;
        try {
            Class<?> cls = Class.forName(classname);
            if (!I2PSocketManager.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(classname + " is not an I2PSocketManager");
            }
            Constructor<?> con = cls.getConstructor(I2PAppContext.class, I2PSession.class, Properties.class, String.class);
            I2PSocketManager mgr = (I2PSocketManager)con.newInstance(context, session, opts, name);
            return mgr;
        }
        catch (Throwable t) {
            I2PSocketManagerFactory.getLog().log(50, "Error loading " + classname, t);
            throw new IllegalStateException(t);
        }
    }

    private static String getHost() {
        return System.getProperty("i2cp.tcp.host", "127.0.0.1");
    }

    private static int getPort() {
        int i2cpPort = 7654;
        String i2cpPortStr = System.getProperty("i2cp.tcp.port");
        if (i2cpPortStr != null) {
            try {
                i2cpPort = Integer.parseInt(i2cpPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return i2cpPort;
    }

    private static SigType getSigType(Properties opts) {
        String st;
        if (opts != null && (st = opts.getProperty("i2cp.destination.sigType")) != null) {
            SigType rv = SigType.parseSigType((String)st);
            if (rv != null && rv.isAvailable()) {
                return rv;
            }
            I2PSocketManagerFactory.getLog().error("Unsupported sig type " + st);
        }
        return I2PClient.DEFAULT_SIGTYPE;
    }

    private static Log getLog() {
        return I2PAppContext.getGlobalContext().logManager().getLog(I2PSocketManagerFactory.class);
    }
}

