/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.VariableTunnelBuildMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

abstract class BuildRequestor {
    private static final List<Integer> ORDER;
    private static final int PRIORITY = 500;
    static final int REQUEST_TIMEOUT = 13000;
    private static final int FIRST_HOP_TIMEOUT = 10000;
    private static final int BUILD_MSG_TIMEOUT = 60000;
    private static final String MIN_VARIABLE_VERSION = "0.7.12";
    private static final boolean SEND_VARIABLE = true;
    private static final int SHORT_RECORDS = 5;
    private static final List<Integer> SHORT_ORDER;

    BuildRequestor() {
    }

    private static boolean usePairedTunnels(RouterContext ctx) {
        return true;
    }

    private static void prepare(RouterContext ctx, PooledTunnelCreatorConfig cfg) {
        int len = cfg.getLength();
        boolean isIB = cfg.isInbound();
        for (int i = 0; i < len; ++i) {
            if (!isIB && i == 0) {
                if (len <= 1) {
                    long id = ctx.tunnelDispatcher().getNewOBGWID();
                    cfg.getConfig(i).setSendTunnelId(DataHelper.toLong((int)4, (long)id));
                }
            } else {
                long id = isIB && len == 1 ? ctx.tunnelDispatcher().getNewIBZeroHopID() : (isIB && i == len - 1 ? ctx.tunnelDispatcher().getNewIBEPID() : ctx.random().nextLong(0xFFFFFFFEL));
                cfg.getConfig(i).setReceiveTunnelId(DataHelper.toLong((int)4, (long)id));
            }
            if (i > 0) {
                cfg.getConfig(i - 1).setSendTunnelId(cfg.getConfig(i).getReceiveTunnelId());
            }
            byte[] iv = new byte[16];
            ctx.random().nextBytes(iv);
            cfg.getConfig(i).setReplyIV(new ByteArray(iv));
            cfg.getConfig(i).setReplyKey(ctx.keyGenerator().generateSessionKey());
        }
    }

    public static boolean request(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        BuildRequestor.prepare(ctx, cfg);
        if (cfg.getLength() <= 1) {
            BuildRequestor.buildZeroHop(ctx, pool, cfg, exec);
            return true;
        }
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        cfg.setTunnelPool(pool);
        TunnelInfo pairedTunnel = null;
        Hash farEnd = cfg.getFarEnd();
        TunnelManagerFacade mgr = ctx.tunnelManager();
        boolean isInbound = pool.getSettings().isInbound();
        if (pool.getSettings().isExploratory() || !BuildRequestor.usePairedTunnels(ctx)) {
            pairedTunnel = isInbound ? mgr.selectOutboundExploratoryTunnel(farEnd) : mgr.selectInboundExploratoryTunnel(farEnd);
        } else {
            pairedTunnel = isInbound ? mgr.selectOutboundTunnel(pool.getSettings().getDestination(), farEnd) : mgr.selectInboundTunnel(pool.getSettings().getDestination(), farEnd);
            if (pairedTunnel == null) {
                if (isInbound) {
                    pairedTunnel = mgr.selectOutboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getOutboundSettings().getLength() + mgr.getOutboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                } else {
                    pairedTunnel = mgr.selectInboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getInboundSettings().getLength() + mgr.getInboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                }
                if (pairedTunnel != null && log.shouldLog(20)) {
                    log.info("Couldn't find a paired tunnel for " + cfg + ", using exploratory tunnel");
                }
            }
        }
        if (pairedTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Tunnel build failed, as we couldn't find a paired tunnel for " + cfg);
            }
            exec.buildComplete(cfg, pool);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return false;
        }
        TunnelBuildMessage msg = BuildRequestor.createTunnelBuildMessage(ctx, pool, cfg, pairedTunnel, exec);
        if (msg == null) {
            if (log.shouldLog(30)) {
                log.warn("Tunnel build failed, as we couldn't create the tunnel build message for " + cfg);
            }
            exec.buildComplete(cfg, pool);
            return false;
        }
        if (cfg.isInbound()) {
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request " + msg.getUniqueId() + " out the tunnel " + pairedTunnel + " to " + cfg.getPeer(0) + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId());
            }
            ctx.tunnelDispatcher().dispatchOutbound(msg, pairedTunnel.getSendTunnelId(0), cfg.getPeer(0));
        } else {
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request directly to " + cfg.getPeer(1) + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId() + " with msgId=" + msg.getUniqueId());
            }
            msg.setMessageExpiration(ctx.clock().now() + 60000L + ctx.random().nextLong(20000L));
            RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(cfg.getPeer(1));
            if (peer == null) {
                if (log.shouldLog(30)) {
                    log.warn("Could not find the next hop to send the outbound request to: " + cfg);
                }
                exec.buildComplete(cfg, pool);
                return false;
            }
            OutNetMessage outMsg = new OutNetMessage(ctx, msg, ctx.clock().now() + 10000L, 500, peer);
            outMsg.setOnFailedSendJob(new TunnelBuildFirstHopFailJob(ctx, pool, cfg, exec));
            ctx.outNetMessagePool().add(outMsg);
        }
        return true;
    }

    private static boolean supportsVariable(RouterContext ctx, Hash h) {
        RouterInfo ri = ctx.netDb().lookupRouterInfoLocally(h);
        if (ri == null) {
            return false;
        }
        String v = ri.getOption("router.version");
        if (v == null) {
            return false;
        }
        return VersionComparator.comp((String)v, (String)MIN_VARIABLE_VERSION) >= 0;
    }

    private static TunnelBuildMessage createTunnelBuildMessage(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, TunnelInfo pairedTunnel, BuildExecutor exec) {
        ArrayList<Integer> order;
        TunnelBuildMessage msg;
        int i;
        boolean useVariable;
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        long replyTunnel = 0L;
        Hash replyRouter = null;
        boolean bl = useVariable = cfg.getLength() <= 5;
        if (cfg.isInbound()) {
            replyRouter = ctx.routerHash();
            if (useVariable) {
                if (!BuildRequestor.supportsVariable(ctx, pairedTunnel.getPeer(pairedTunnel.getLength() - 1))) {
                    useVariable = false;
                } else {
                    for (i = 0; i < cfg.getLength() - 1; ++i) {
                        if (BuildRequestor.supportsVariable(ctx, cfg.getPeer(i))) continue;
                        useVariable = false;
                        break;
                    }
                }
            }
        } else {
            replyTunnel = pairedTunnel.getReceiveTunnelId(0).getTunnelId();
            replyRouter = pairedTunnel.getPeer(0);
            if (useVariable) {
                if (!BuildRequestor.supportsVariable(ctx, replyRouter)) {
                    useVariable = false;
                } else {
                    for (i = 1; i < cfg.getLength() - 1; ++i) {
                        if (BuildRequestor.supportsVariable(ctx, cfg.getPeer(i))) continue;
                        useVariable = false;
                        break;
                    }
                }
            }
        }
        if (useVariable) {
            msg = new VariableTunnelBuildMessage(ctx, 5);
            order = new ArrayList<Integer>(SHORT_ORDER);
        } else {
            msg = new TunnelBuildMessage(ctx);
            order = new ArrayList<Integer>(ORDER);
        }
        Collections.shuffle(order, (Random)ctx.random());
        cfg.setReplyOrder(order);
        if (log.shouldLog(10)) {
            log.debug("Build order: " + order + " for " + cfg);
        }
        for (int i2 = 0; i2 < msg.getRecordCount(); ++i2) {
            int hop = (Integer)order.get(i2);
            PublicKey key = null;
            if (!BuildMessageGenerator.isBlank(cfg, hop)) {
                Hash peer = cfg.getPeer(hop);
                RouterInfo peerInfo = ctx.netDb().lookupRouterInfoLocally(peer);
                if (peerInfo == null) {
                    if (log.shouldLog(30)) {
                        log.warn("Peer selected for hop " + i2 + "/" + hop + " was not found locally: " + peer + " for " + cfg);
                    }
                    return null;
                }
                key = peerInfo.getIdentity().getPublicKey();
            }
            if (log.shouldLog(10)) {
                log.debug(cfg.getReplyMessageId() + ": record " + i2 + "/" + hop + " has key " + key);
            }
            BuildMessageGenerator.createRecord(i2, hop, msg, cfg, replyRouter, replyTunnel, ctx, key);
        }
        BuildMessageGenerator.layeredEncrypt(ctx, msg, cfg, order);
        return msg;
    }

    private static void buildZeroHop(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        if (log.shouldLog(10)) {
            log.debug("Build zero hop tunnel " + cfg);
        }
        exec.buildComplete(cfg, pool);
        if (cfg.isInbound()) {
            ctx.tunnelDispatcher().joinInbound(cfg);
        } else {
            ctx.tunnelDispatcher().joinOutbound(cfg);
        }
        pool.addTunnel(cfg);
        exec.buildSuccessful(cfg);
        ExpireJob expireJob = new ExpireJob(ctx, cfg, pool);
        cfg.setExpireJob(expireJob);
        ctx.jobQueue().addJob(expireJob);
    }

    static {
        int i;
        ORDER = new ArrayList<Integer>(8);
        for (i = 0; i < 8; ++i) {
            ORDER.add(i);
        }
        SHORT_ORDER = new ArrayList<Integer>(5);
        for (i = 0; i < 5; ++i) {
            SHORT_ORDER.add(i);
        }
    }

    private static class TunnelBuildFirstHopFailJob
    extends JobImpl {
        private final TunnelPool _pool;
        private final PooledTunnelCreatorConfig _cfg;
        private final BuildExecutor _exec;

        private TunnelBuildFirstHopFailJob(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
            super(ctx);
            this._cfg = cfg;
            this._exec = exec;
            this._pool = pool;
        }

        @Override
        public String getName() {
            return "Timeout contacting first peer for OB tunnel";
        }

        @Override
        public void runJob() {
            this._exec.buildComplete(this._cfg, this._pool);
            this.getContext().profileManager().tunnelTimedOut(this._cfg.getPeer(1));
            this.getContext().statManager().addRateData("tunnel.buildFailFirstHop", 1L, 0L);
        }
    }
}

