/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.tunnel.pool.BuildRequestor;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.Log;

class BuildExecutor
implements Runnable {
    private final ArrayList<Long> _recentBuildIds = new ArrayList(100);
    private final RouterContext _context;
    private final Log _log;
    private final TunnelPoolManager _manager;
    private final Object _currentlyBuilding;
    private final ConcurrentHashMap<Long, PooledTunnelCreatorConfig> _currentlyBuildingMap;
    private final ConcurrentHashMap<Long, PooledTunnelCreatorConfig> _recentlyBuildingMap;
    private volatile boolean _isRunning;
    private boolean _repoll;
    private static final int MAX_CONCURRENT_BUILDS = 10;
    private static final long GRACE_PERIOD = 60000L;
    private static final int LOOP_TIME = 1000;

    public BuildExecutor(RouterContext ctx, TunnelPoolManager mgr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._manager = mgr;
        this._currentlyBuilding = new Object();
        this._currentlyBuildingMap = new ConcurrentHashMap(10);
        this._recentlyBuildingMap = new ConcurrentHashMap(40);
        this._context.statManager().createRateStat("tunnel.concurrentBuilds", "How many builds are going at once", "Tunnels", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("tunnel.concurrentBuildsLagged", "How many builds are going at once when we reject further builds, due to job lag (period is lag)", "Tunnels", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratoryExpire", "No response to our build request", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildClientExpire", "No response to our build request", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratorySuccess", "Response time for success (ms)", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildClientSuccess", "Response time for success (ms)", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratoryReject", "Response time for rejection (ms)", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildClientReject", "Response time for rejection (ms)", "Tunnels", new long[]{600000L, 3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.buildRequestTime", "Time to build a tunnel request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildConfigTime", "Time to build a tunnel request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildRequestZeroHopTime", "How long it takes to build a zero hop tunnel", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildFailFirstHop", "How often we fail to build a OB tunnel because we can't contact the first hop", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildReplySlow", "Build reply late, but not too late", "Tunnels", new long[]{600000L});
        StatManager statMgr = this._context.statManager();
        String bwTiers = "KLMNO";
        for (int i = 0; i < bwTiers.length(); ++i) {
            String bwTier = String.valueOf(bwTiers.charAt(i));
            statMgr.createRateStat("tunnel.tierAgree" + bwTier, "Agreed joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
            statMgr.createRateStat("tunnel.tierReject" + bwTier, "Rejected joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
            statMgr.createRateStat("tunnel.tierExpire" + bwTier, "Expired joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
        }
        statMgr.createRateStat("tunnel.tierAgreeUnknown", "Agreed joins from unknown", "Tunnels", new long[]{60000L, 600000L});
        statMgr.createRateStat("tunnel.tierRejectUnknown", "Rejected joins from unknown", "Tunnels", new long[]{60000L, 600000L});
        statMgr.createRateStat("tunnel.tierExpireUnknown", "Expired joins from unknown", "Tunnels", new long[]{60000L, 600000L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restart() {
        ArrayList<Long> arrayList = this._recentBuildIds;
        synchronized (arrayList) {
            this._recentBuildIds.clear();
        }
        this._currentlyBuildingMap.clear();
        this._recentlyBuildingMap.clear();
    }

    public synchronized void shutdown() {
        this._isRunning = false;
        this.restart();
    }

    private int allowed() {
        PooledTunnelCreatorConfig cfg;
        if (this._context.commSystem().getReachabilityStatus() == 3) {
            return 0;
        }
        int maxKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        int allowed = maxKBps / 6;
        RateStat rs = this._context.statManager().getRate("tunnel.buildRequestTime");
        if (rs != null) {
            int throttle;
            Rate r = rs.getRate(60000L);
            double avg = 0.0;
            if (r != null) {
                avg = r.getAverageValue();
            }
            if (avg <= 0.0) {
                avg = rs.getLifetimeAverageValue();
            }
            if (avg > 1.0 && (throttle = (int)(750.0 / avg)) < allowed && (allowed = throttle) < 10 && this._log.shouldLog(20)) {
                this._log.info("Throttling max builds to " + allowed + " due to avg build time of " + (int)avg + " ms");
            }
        }
        if (allowed < 2) {
            allowed = 2;
        } else if (allowed > 10) {
            allowed = 10;
        }
        allowed = this._context.getProperty("router.tunnelConcurrentBuilds", allowed);
        long expireBefore = this._context.clock().now() + 600000L - 13000L - 60000L;
        Iterator<PooledTunnelCreatorConfig> iter = this._recentlyBuildingMap.values().iterator();
        while (iter.hasNext()) {
            PooledTunnelCreatorConfig cfg2 = iter.next();
            if (cfg2.getExpiration() > expireBefore) continue;
            iter.remove();
        }
        ArrayList<PooledTunnelCreatorConfig> expired = null;
        int concurrent = 0;
        expireBefore = this._context.clock().now() + 600000L - 13000L;
        Iterator<PooledTunnelCreatorConfig> iter2 = this._currentlyBuildingMap.values().iterator();
        while (iter2.hasNext()) {
            cfg = iter2.next();
            if (cfg.getExpiration() > expireBefore) continue;
            this._recentlyBuildingMap.putIfAbsent(cfg.getReplyMessageId(), cfg);
            iter2.remove();
            if (expired == null) {
                expired = new ArrayList<PooledTunnelCreatorConfig>();
            }
            expired.add(cfg);
        }
        concurrent = this._currentlyBuildingMap.size();
        allowed -= concurrent;
        if (expired != null) {
            for (int i = 0; i < expired.size(); ++i) {
                cfg = (PooledTunnelCreatorConfig)expired.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Timed out waiting for reply asking for " + cfg);
                }
                for (int iPeer = 0; iPeer < cfg.getLength(); ++iPeer) {
                    Hash peer = cfg.getPeer(iPeer);
                    if (peer.equals((Object)this._context.routerHash())) continue;
                    RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                    String bwTier = "Unknown";
                    if (ri != null) {
                        bwTier = ri.getBandwidthTier();
                    }
                    this._context.statManager().addRateData("tunnel.tierExpire" + bwTier, 1L, 0L);
                    this.didNotReply(cfg.getReplyMessageId(), peer);
                    this._context.profileManager().tunnelTimedOut(peer);
                }
                TunnelPool pool = cfg.getTunnelPool();
                if (pool != null) {
                    pool.buildComplete(cfg);
                }
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratoryExpire", 1L, 0L);
                    continue;
                }
                this._context.statManager().addRateData("tunnel.buildClientExpire", 1L, 0L);
            }
        }
        this._context.statManager().addRateData("tunnel.concurrentBuilds", (long)concurrent, 0L);
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > 2000L && this._context.router().getUptime() > 300000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too lagged [" + lag + "], don't allow building");
            }
            this._context.statManager().addRateData("tunnel.concurrentBuildsLagged", (long)concurrent, lag);
            return 0;
        }
        return allowed;
    }

    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.run2();
        }
        catch (NoSuchMethodError nsme) {
            String s = "Fatal error:\nJava 8 compiler used with JRE version " + System.getProperty("java.version") + " and no bootclasspath specified." + "\nUpdate to Java 8 or contact packager." + "\nStop I2P now, it will not build tunnels.";
            this._log.log(50, s, (Throwable)nsme);
            System.out.println(s);
            throw nsme;
        }
        finally {
            this._isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() {
        ArrayList<TunnelPool> wanted = new ArrayList<TunnelPool>(10);
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>(8);
        while (this._isRunning && !this._manager.isShutdown()) {
            block35: {
                try {
                    this._repoll = false;
                    this._manager.listPools(pools);
                    for (int i = 0; i < pools.size(); ++i) {
                        TunnelPool pool = (TunnelPool)pools.get(i);
                        if (!pool.isAlive()) continue;
                        int howMany = pool.countHowManyToBuild();
                        for (int j = 0; j < howMany; ++j) {
                            wanted.add(pool);
                        }
                    }
                    int allowed = this.allowed();
                    allowed = this.buildZeroHopTunnels(wanted, allowed);
                    TunnelManagerFacade mgr = this._context.tunnelManager();
                    if (mgr == null || mgr.getFreeTunnelCount() <= 0 || mgr.getOutboundTunnelCount() <= 0) {
                        if (mgr != null) {
                            if (mgr.getFreeTunnelCount() <= 0) {
                                mgr.selectInboundTunnel();
                            }
                            if (mgr.getOutboundTunnelCount() <= 0) {
                                mgr.selectOutboundTunnel();
                            }
                        }
                        Object howMany = this._currentlyBuilding;
                        synchronized (howMany) {
                            if (!this._repoll) {
                                if (this._log.shouldLog(10)) {
                                    this._log.debug("No tunnel to build with (allowed=" + allowed + ", wanted=" + wanted.size() + "), wait for a while");
                                }
                                try {
                                    this._currentlyBuilding.wait(1000 + this._context.random().nextInt(1000));
                                }
                                catch (InterruptedException ie) {
                                    // empty catch block
                                }
                            }
                            break block35;
                        }
                    }
                    if (allowed > 0 && !wanted.isEmpty()) {
                        if (wanted.size() > 1) {
                            Collections.shuffle(wanted, (Random)this._context.random());
                            boolean preferEmpty = this._context.random().nextInt(4) != 0;
                            try {
                                Collections.sort(wanted, new TunnelPoolComparator(preferEmpty));
                            }
                            catch (IllegalArgumentException iae) {
                                continue;
                            }
                        }
                        if (allowed > 2) {
                            allowed = 2;
                        }
                        for (int i = 0; i < allowed && !wanted.isEmpty(); ++i) {
                            TunnelPool pool = (TunnelPool)wanted.remove(0);
                            long bef = System.currentTimeMillis();
                            PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
                            if (cfg != null) {
                                if (cfg.getLength() <= 1 && !pool.needFallback()) {
                                    if (this._log.shouldLog(10)) {
                                        this._log.debug("We don't need more fallbacks for " + pool);
                                    }
                                    --i;
                                    pool.buildComplete(cfg);
                                    continue;
                                }
                                long pTime = System.currentTimeMillis() - bef;
                                this._context.statManager().addRateData("tunnel.buildConfigTime", pTime, 0L);
                                if (this._log.shouldLog(10)) {
                                    this._log.debug("Configuring new tunnel " + i + " for " + pool + ": " + cfg);
                                }
                                this.buildTunnel(pool, cfg);
                                continue;
                            }
                            --i;
                        }
                    }
                    try {
                        Object i = this._currentlyBuilding;
                        synchronized (i) {
                            if (!this._repoll) {
                                this._currentlyBuilding.wait(500 + this._context.random().nextInt(1000));
                            }
                        }
                    }
                    catch (InterruptedException ie) {}
                }
                catch (RuntimeException e) {
                    this._log.log(50, "B0rked in the tunnel builder", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            wanted.clear();
            pools.clear();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Done building");
        }
    }

    private int buildZeroHopTunnels(List<TunnelPool> wanted, int allowed) {
        for (int i = 0; i < wanted.size(); ++i) {
            TunnelPool pool = wanted.get(0);
            if (pool.getSettings().getLength() != 0) continue;
            PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
            if (cfg != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Configuring short tunnel " + i + " for " + pool + ": " + cfg);
                }
                this.buildTunnel(pool, cfg);
                if (cfg.getLength() > 1) {
                    --allowed;
                }
                wanted.remove(i);
                --i;
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Configured a null tunnel");
        }
        return allowed;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildTunnel(TunnelPool pool, PooledTunnelCreatorConfig cfg) {
        boolean ok;
        long beforeBuild = System.currentTimeMillis();
        if (cfg.getLength() > 1) {
            do {
                cfg.setReplyMessageId(this._context.random().nextLong(0xFFFFFFFFL));
            } while (this.addToBuilding(cfg));
        }
        if (!(ok = BuildRequestor.request(this._context, pool, cfg, this))) {
            return;
        }
        long buildTime = System.currentTimeMillis() - beforeBuild;
        if (cfg.getLength() <= 1) {
            this._context.statManager().addRateData("tunnel.buildRequestZeroHopTime", buildTime, 0L);
        } else {
            this._context.statManager().addRateData("tunnel.buildRequestTime", buildTime, 0L);
        }
        long id = cfg.getReplyMessageId();
        if (id > 0L) {
            ArrayList<Long> arrayList = this._recentBuildIds;
            synchronized (arrayList) {
                if (this._recentBuildIds.size() > 98) {
                    for (int i = 0; i < 32; ++i) {
                        this._recentBuildIds.remove(0);
                    }
                }
                this._recentBuildIds.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildComplete(PooledTunnelCreatorConfig cfg, TunnelPool pool) {
        long buildTime;
        if (this._log.shouldLog(10)) {
            this._log.debug("Build complete for " + cfg, (Throwable)new Exception());
        }
        pool.buildComplete(cfg);
        if (cfg.getLength() > 1) {
            this.removeFromBuilding(cfg.getReplyMessageId());
        }
        if ((buildTime = this._context.clock().now() + 600000L - cfg.getExpiration()) > 250L) {
            Object object = this._currentlyBuilding;
            synchronized (object) {
                this._currentlyBuilding.notifyAll();
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Build complete really fast (" + buildTime + " ms) for tunnel: " + cfg);
        }
        long expireBefore = this._context.clock().now() + 600000L - 13000L;
        if (cfg.getExpiration() <= expireBefore && this._log.shouldLog(20)) {
            this._log.info("Build complete for expired tunnel: " + cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRecentlyBuilding(long replyId) {
        ArrayList<Long> arrayList = this._recentBuildIds;
        synchronized (arrayList) {
            return this._recentBuildIds.contains(replyId);
        }
    }

    public void buildSuccessful(PooledTunnelCreatorConfig cfg) {
        this._manager.buildComplete(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repoll() {
        Object object = this._currentlyBuilding;
        synchronized (object) {
            this._repoll = true;
            this._currentlyBuilding.notifyAll();
        }
    }

    private void didNotReply(long tunnel, Hash peer) {
        if (this._log.shouldLog(20)) {
            this._log.info(tunnel + ": Peer " + peer.toBase64() + " did not reply to the tunnel join request");
        }
    }

    private boolean addToBuilding(PooledTunnelCreatorConfig cfg) {
        return this._currentlyBuildingMap.putIfAbsent(cfg.getReplyMessageId(), cfg) != null;
    }

    PooledTunnelCreatorConfig removeFromBuilding(long id) {
        Long key = id;
        PooledTunnelCreatorConfig rv = this._currentlyBuildingMap.remove(key);
        if (rv != null) {
            return rv;
        }
        rv = this._recentlyBuildingMap.remove(key);
        if (rv != null) {
            long requestedOn = rv.getExpiration() - 600000L;
            long rtt = this._context.clock().now() - requestedOn;
            this._context.statManager().addRateData("tunnel.buildReplySlow", rtt, 0L);
            if (this._log.shouldLog(30)) {
                this._log.warn("Got reply late (rtt = " + rtt + ") for: " + rv);
            }
        }
        return rv;
    }

    private static class TunnelPoolComparator
    implements Comparator<TunnelPool>,
    Serializable {
        private final boolean _preferEmpty;

        public TunnelPoolComparator(boolean preferEmptyPools) {
            this._preferEmpty = preferEmptyPools;
        }

        @Override
        public int compare(TunnelPool tpl, TunnelPool tpr) {
            if (tpl.getSettings().isExploratory() && !tpr.getSettings().isExploratory()) {
                return -1;
            }
            if (tpr.getSettings().isExploratory() && !tpl.getSettings().isExploratory()) {
                return 1;
            }
            if (this._preferEmpty) {
                if (tpl.getTunnelCount() <= 0 && tpr.getTunnelCount() > 0) {
                    return -1;
                }
                if (tpr.getTunnelCount() <= 0 && tpl.getTunnelCount() > 0) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

