/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.BatchedPreprocessor;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

class BatchedRouterPreprocessor
extends BatchedPreprocessor {
    private final TunnelCreatorConfig _config;
    protected final HopConfig _hopConfig;
    private final long _sendDelay;
    public static final String PROP_BATCH_FREQUENCY = "batchFrequency";
    public static final String PROP_ROUTER_BATCH_FREQUENCY = "router.batchFrequency";
    public static final int OB_CLIENT_BATCH_FREQ = 100;
    public static final int OB_EXPL_BATCH_FREQ = 150;
    public static final int DEFAULT_BATCH_FREQUENCY = 250;

    public BatchedRouterPreprocessor(RouterContext ctx, TunnelCreatorConfig cfg) {
        super(ctx, BatchedRouterPreprocessor.getName(cfg));
        this._config = cfg;
        this._hopConfig = null;
        this._sendDelay = this.initialSendDelay();
    }

    public BatchedRouterPreprocessor(RouterContext ctx, HopConfig cfg) {
        super(ctx, BatchedRouterPreprocessor.getName(cfg));
        this._config = null;
        this._hopConfig = cfg;
        this._sendDelay = this.initialSendDelay();
    }

    private static String getName(HopConfig cfg) {
        if (cfg == null) {
            return "IB??";
        }
        if (cfg.getReceiveTunnel() != null) {
            return "IB " + cfg.getReceiveTunnel().getTunnelId();
        }
        if (cfg.getSendTunnel() != null) {
            return "IB " + cfg.getSendTunnel().getTunnelId();
        }
        return "IB??";
    }

    private static String getName(TunnelCreatorConfig cfg) {
        if (cfg == null) {
            return "OB??";
        }
        if (cfg.getReceiveTunnelId(0) != null) {
            return "OB " + cfg.getReceiveTunnelId(0).getTunnelId();
        }
        if (cfg.getSendTunnelId(0) != null) {
            return "OB " + cfg.getSendTunnelId(0).getTunnelId();
        }
        return "OB??";
    }

    @Override
    protected long getSendDelay() {
        return this._sendDelay;
    }

    private long initialSendDelay() {
        String freq;
        Properties opts;
        if (this._config != null && (opts = this._config.getOptions()) != null && (freq = opts.getProperty(PROP_BATCH_FREQUENCY)) != null) {
            try {
                return Integer.parseInt(freq);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int def = this._config != null ? (this._config.getDestination() != null ? 100 : 150) : 250;
        return this._context.getProperty(PROP_ROUTER_BATCH_FREQUENCY, def);
    }

    @Override
    protected void notePreprocessing(long messageId, int numFragments, int totalLength, List<Long> messageIds, String msg) {
        if (this._config != null) {
            this._context.messageHistory().fragmentMessage(messageId, numFragments, totalLength, messageIds, this._config, msg);
        } else {
            this._context.messageHistory().fragmentMessage(messageId, numFragments, totalLength, messageIds, this._hopConfig, msg);
        }
    }
}

