/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.util.CDPQEntry;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class OutboundMessageState
implements CDPQEntry {
    private final I2PAppContext _context;
    private final Log _log;
    private final OutNetMessage _message;
    private final I2NPMessage _i2npMessage;
    private final long _messageId;
    private final PeerState _peer;
    private final long _expiration;
    private ByteArray _messageBuf;
    private int _fragmentSize;
    private int _totalSize;
    private short[] _fragmentSends;
    private final long _startedOn;
    private long _nextSendTime;
    private int _pushCount;
    private short _maxSends;
    private boolean _released;
    private Exception _releasedBy;
    private long _enqueueTime;
    private long _seqNum;
    public static final int MAX_MSG_SIZE = 32768;
    private static final int CACHE4_BYTES = 32768;
    private static final int CACHE3_BYTES = 8192;
    private static final int CACHE2_BYTES = 2048;
    private static final int CACHE1_BYTES = 512;
    private static final int CACHE1_MAX = 256;
    private static final int CACHE2_MAX = 64;
    private static final int CACHE3_MAX = 16;
    private static final int CACHE4_MAX = 4;
    private static final ByteCache _cache1 = ByteCache.getInstance((int)256, (int)512);
    private static final ByteCache _cache2 = ByteCache.getInstance((int)64, (int)2048);
    private static final ByteCache _cache3 = ByteCache.getInstance((int)16, (int)8192);
    private static final ByteCache _cache4 = ByteCache.getInstance((int)4, (int)32768);
    private static final long EXPIRATION = 10000L;

    public OutboundMessageState(I2PAppContext context, I2NPMessage msg, PeerState peer) {
        this(context, null, msg, peer);
    }

    public OutboundMessageState(I2PAppContext context, OutNetMessage m, PeerState peer) {
        this(context, m, m.getMessage(), peer);
    }

    private OutboundMessageState(I2PAppContext context, OutNetMessage m, I2NPMessage msg, PeerState peer) {
        if (msg == null || peer == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageState.class);
        this._message = m;
        this._i2npMessage = msg;
        this._peer = peer;
        this._messageId = msg.getUniqueId();
        this._nextSendTime = this._startedOn = this._context.clock().now();
        this._expiration = this._startedOn + 10000L;
    }

    private synchronized void initBuf() {
        if (this._messageBuf != null) {
            return;
        }
        int size = this._i2npMessage.getRawMessageSize();
        this.acquireBuf(size);
        this._totalSize = this._i2npMessage.toRawByteArray(this._messageBuf.getData());
        this._messageBuf.setValid(this._totalSize);
    }

    private void acquireBuf(int size) {
        if (this._messageBuf != null) {
            this.releaseBuf();
        }
        if (size <= 512) {
            this._messageBuf = _cache1.acquire();
        } else if (size <= 2048) {
            this._messageBuf = _cache2.acquire();
        } else if (size <= 8192) {
            this._messageBuf = _cache3.acquire();
        } else if (size <= 32768) {
            this._messageBuf = _cache4.acquire();
        } else {
            throw new IllegalArgumentException("Size too large! " + size);
        }
    }

    private void releaseBuf() {
        if (this._messageBuf == null) {
            return;
        }
        int size = this._messageBuf.getData().length;
        if (size == 512) {
            _cache1.release(this._messageBuf);
        } else if (size == 2048) {
            _cache2.release(this._messageBuf);
        } else if (size == 8192) {
            _cache3.release(this._messageBuf);
        } else if (size == 32768) {
            _cache4.release(this._messageBuf);
        }
        this._messageBuf = null;
        this._released = true;
    }

    public synchronized void releaseResources() {
        if (this._messageBuf != null && !this._released) {
            this.releaseBuf();
            if (this._log.shouldLog(30)) {
                this._releasedBy = new Exception("Released on " + new Date() + " by:");
            }
        }
    }

    public OutNetMessage getMessage() {
        return this._message;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public PeerState getPeer() {
        return this._peer;
    }

    public boolean isExpired() {
        return this._expiration < this._context.clock().now();
    }

    public boolean isComplete() {
        short[] sends = this._fragmentSends;
        if (sends == null) {
            return false;
        }
        for (int i = 0; i < sends.length; ++i) {
            if (sends[i] < 0) continue;
            return false;
        }
        return true;
    }

    public synchronized int getUnackedSize() {
        short[] fragmentSends = this._fragmentSends;
        ByteArray messageBuf = this._messageBuf;
        int rv = 0;
        if (messageBuf != null && fragmentSends != null) {
            int lastSize = this._totalSize % this._fragmentSize;
            if (lastSize == 0) {
                lastSize = this._fragmentSize;
            }
            for (int i = 0; i < fragmentSends.length; ++i) {
                if (fragmentSends[i] < 0) continue;
                if (i + 1 == fragmentSends.length) {
                    rv += lastSize;
                    continue;
                }
                rv += this._fragmentSize;
            }
        }
        return rv;
    }

    public boolean needsSending(int fragment) {
        short[] sends = this._fragmentSends;
        if (sends == null || fragment >= sends.length || fragment < 0) {
            return false;
        }
        return sends[fragment] >= 0;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._startedOn;
    }

    public boolean acked(ACKBitfield bitfield) {
        short[] sends = this._fragmentSends;
        if (sends != null) {
            for (int i = 0; i < bitfield.fragmentCount() && i < sends.length; ++i) {
                if (!bitfield.received(i)) continue;
                sends[i] = -1;
            }
        }
        boolean rv = this.isComplete();
        return rv;
    }

    public long getNextSendTime() {
        return this._nextSendTime;
    }

    public void setNextSendTime(long when) {
        this._nextSendTime = when;
    }

    public int getMaxSends() {
        return this._maxSends;
    }

    public int getPushCount() {
        return this._pushCount;
    }

    public void push() {
        ++this._pushCount;
        if (this._pushCount > this._maxSends) {
            this._maxSends = (short)this._pushCount;
        }
        if (this._fragmentSends != null) {
            for (int i = 0; i < this._fragmentSends.length; ++i) {
                if (this._fragmentSends[i] < 0) continue;
                this._fragmentSends[i] = (short)(1 + this._fragmentSends[i]);
            }
        }
    }

    public boolean isFragmented() {
        return this._fragmentSends != null;
    }

    public void fragment(int fragmentSize) {
        if (this._fragmentSends != null) {
            throw new IllegalStateException();
        }
        this.initBuf();
        int numFragments = this._totalSize / fragmentSize;
        if (numFragments * fragmentSize < this._totalSize) {
            ++numFragments;
        }
        if (numFragments > 64) {
            throw new IllegalArgumentException("Fragmenting a " + this._totalSize + " message into " + numFragments + " fragments - too many!");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Fragmenting a " + this._totalSize + " message into " + numFragments + " fragments");
        }
        this._fragmentSends = new short[numFragments];
        this._fragmentSize = fragmentSize;
    }

    public int getFragmentCount() {
        if (this._fragmentSends == null) {
            return -1;
        }
        return this._fragmentSends.length;
    }

    public int getMessageSize() {
        return this._totalSize;
    }

    public boolean shouldSend(int fragmentNum) {
        return this._fragmentSends[fragmentNum] >= 0;
    }

    public int fragmentSize(int fragmentNum) {
        if (this._messageBuf == null) {
            return -1;
        }
        if (fragmentNum + 1 == this._fragmentSends.length) {
            int valid = this._totalSize;
            if (valid <= this._fragmentSize) {
                return valid;
            }
            int mod = valid % this._fragmentSize;
            return mod == 0 ? this._fragmentSize : mod;
        }
        return this._fragmentSize;
    }

    public synchronized int writeFragment(byte[] out, int outOffset, int fragmentNum) {
        if (this._messageBuf == null) {
            return -1;
        }
        if (this._released) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "SSU OMS Use after free: " + this.toString(), (Throwable)this._releasedBy);
            }
            return -1;
        }
        int start = this._fragmentSize * fragmentNum;
        int end = start + this.fragmentSize(fragmentNum);
        int toSend = end - start;
        byte[] buf = this._messageBuf.getData();
        if (buf != null && start + toSend <= buf.length && outOffset + toSend <= out.length) {
            System.arraycopy(buf, start, out, outOffset, toSend);
            if (this._log.shouldLog(10)) {
                this._log.debug("Raw fragment[" + fragmentNum + "] for " + this._messageId + "[" + start + "-" + (start + toSend) + "/" + this._totalSize + "/" + this._fragmentSize + "]: " + Base64.encode((byte[])out, (int)outOffset, (int)toSend));
            }
            return toSend;
        }
        if (buf == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error: null buf");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Error: " + start + '/' + end + '/' + outOffset + '/' + out.length);
        }
        return -1;
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    @Override
    public void drop() {
        this._peer.getTransport().failed(this, false);
        this.releaseResources();
    }

    @Override
    public void setSeqNum(long num) {
        this._seqNum = num;
    }

    @Override
    public long getSeqNum() {
        return this._seqNum;
    }

    @Override
    public int getPriority() {
        return this._message != null ? this._message.getPriority() : 1000;
    }

    public String toString() {
        short[] sends = this._fragmentSends;
        StringBuilder buf = new StringBuilder(256);
        buf.append("OB Message ").append(this._messageId);
        if (sends != null) {
            buf.append(" with ").append(sends.length).append(" fragments");
        }
        buf.append(" of size ").append(this._totalSize);
        buf.append(" volleys: ").append(this._maxSends);
        buf.append(" lifetime: ").append(this.getLifetime());
        if (sends != null) {
            buf.append(" pending fragments: ");
            for (int i = 0; i < sends.length; ++i) {
                if (sends[i] < 0) continue;
                buf.append(i).append(' ');
            }
        }
        return buf.toString();
    }
}

