/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.util.Log;

class SearchUpdateReplyFoundJob
extends JobImpl
implements ReplyJob {
    private Log _log;
    private I2NPMessage _message;
    private Hash _peer;
    private SearchState _state;
    private KademliaNetworkDatabaseFacade _facade;
    private SearchJob _job;
    private TunnelInfo _outTunnel;
    private TunnelInfo _replyTunnel;
    private boolean _isFloodfillPeer;
    private long _sentOn;

    public SearchUpdateReplyFoundJob(RouterContext context, RouterInfo peer, SearchState state, KademliaNetworkDatabaseFacade facade, SearchJob job) {
        this(context, peer, state, facade, job, null, null);
    }

    public SearchUpdateReplyFoundJob(RouterContext context, RouterInfo peer, SearchState state, KademliaNetworkDatabaseFacade facade, SearchJob job, TunnelInfo outTunnel, TunnelInfo replyTunnel) {
        super(context);
        this._log = context.logManager().getLog(SearchUpdateReplyFoundJob.class);
        this._peer = peer.getIdentity().getHash();
        this._isFloodfillPeer = FloodfillNetworkDatabaseFacade.isFloodfill(peer);
        this._state = state;
        this._facade = facade;
        this._job = job;
        this._outTunnel = outTunnel;
        this._replyTunnel = replyTunnel;
        this._sentOn = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return "Update Reply Found for Kademlia Search";
    }

    @Override
    public void runJob() {
        int i;
        if (this._isFloodfillPeer) {
            this._job.decrementOutstandingFloodfillSearches();
        }
        I2NPMessage message = this._message;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Reply from " + this._peer.toBase64() + " with message " + message.getClass().getName());
        }
        long howLong = System.currentTimeMillis() - this._sentOn;
        int msgSize = 1024;
        if (this._replyTunnel != null) {
            for (i = 0; i < this._replyTunnel.getLength(); ++i) {
                this.getContext().profileManager().tunnelDataPushed(this._replyTunnel.getPeer(i), howLong, msgSize);
            }
            this._replyTunnel.incrementVerifiedBytesTransferred(msgSize);
        }
        if (this._outTunnel != null) {
            for (i = 0; i < this._outTunnel.getLength(); ++i) {
                this.getContext().profileManager().tunnelDataPushed(this._outTunnel.getPeer(i), howLong, msgSize);
            }
            this._outTunnel.incrementVerifiedBytesTransferred(msgSize);
        }
        if (message instanceof DatabaseStoreMessage) {
            long timeToReply = this._state.dataFound(this._peer);
            DatabaseStoreMessage msg = (DatabaseStoreMessage)message;
            DatabaseEntry entry = msg.getEntry();
            if (entry.getType() == 1) {
                try {
                    this._facade.store(msg.getKey(), (LeaseSet)entry);
                    this.getContext().profileManager().dbLookupSuccessful(this._peer, timeToReply);
                }
                catch (IllegalArgumentException iae) {
                    if (this._log.shouldLog(40)) {
                        this._log.warn("Peer " + this._peer + " sent us an invalid leaseSet: " + iae.getMessage());
                    }
                    this.getContext().profileManager().dbLookupReply(this._peer, 0, 0, 1, 0, timeToReply);
                }
            } else if (entry.getType() == 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": dbStore received on search containing router " + msg.getKey() + " with publishDate of " + new Date(entry.getDate()));
                }
                try {
                    this._facade.store(msg.getKey(), (RouterInfo)entry);
                    this.getContext().profileManager().dbLookupSuccessful(this._peer, timeToReply);
                }
                catch (IllegalArgumentException iae) {
                    if (this._log.shouldLog(40)) {
                        this._log.warn("Peer " + this._peer + " sent us an invalid routerInfo: " + iae.getMessage());
                    }
                    this.getContext().profileManager().dbLookupReply(this._peer, 0, 0, 1, 0, timeToReply);
                }
            } else if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": Unknown db store type?!@ " + entry.getType());
            }
        } else if (message instanceof DatabaseSearchReplyMessage) {
            this._job.replyFound((DatabaseSearchReplyMessage)message, this._peer);
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": WTF, reply job matched a strange message: " + message);
            }
            return;
        }
        this._job.searchNext();
    }

    @Override
    public void setMessage(I2NPMessage message) {
        this._message = message;
    }
}

