/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

class NegativeLookupCache {
    private final ObjectCounter<Hash> counter = new ObjectCounter();
    private static final int MAX_FAILS = 3;
    private static final long CLEAN_TIME = 120000L;

    public NegativeLookupCache() {
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 120000L);
    }

    public void lookupFailed(Hash h) {
        this.counter.increment((Object)h);
    }

    public boolean isCached(Hash h) {
        return this.counter.count((Object)h) >= 3;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            NegativeLookupCache.this.counter.clear();
        }
    }
}

