/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.transport.BadCountries;
import net.i2p.router.transport.GeoIP;
import net.i2p.util.FileUtil;

public class BundleRouterInfos {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int c;
        Getopt g = new Getopt("PersistentDataStore", args, "i:o:c:");
        String in = System.getProperty("user.home") + "/.i2p";
        String out = "netDb";
        int count = 200;
        boolean error = false;
        block52: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 105: {
                    in = g.getOptarg();
                    continue block52;
                }
                case 111: {
                    out = g.getOptarg();
                    continue block52;
                }
                case 99: {
                    String scount = g.getOptarg();
                    try {
                        count = Integer.parseInt(scount);
                    }
                    catch (NumberFormatException nfe) {
                        error = true;
                    }
                    continue block52;
                }
            }
            error = true;
        }
        if (error) {
            BundleRouterInfos.usage();
            System.exit(1);
        }
        Properties props = new Properties();
        props.setProperty("geoip.dir", System.getProperty("user.dir") + "/installer/resources");
        GeoIP geoIP = new GeoIP(new I2PAppContext(props));
        File confDir = new File(in);
        File dbDir = new File(confDir, "netDb");
        if (!dbDir.exists()) {
            System.out.println("NetDB directory " + dbDir + " does not exist");
            System.exit(1);
        }
        File myFile = new File(confDir, "router.info");
        File toDir = new File(out);
        toDir.mkdirs();
        InputStream fis = null;
        Hash me = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(myFile));
            RouterInfo ri = new RouterInfo();
            ri.readBytes(fis, true);
            me = ri.getIdentity().getHash();
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        int routerCount = 0;
        ArrayList<File> toRead = new ArrayList<File>(2048);
        for (int j = 0; j < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~".length(); ++j) {
            File subdir = new File(dbDir, "r" + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~".charAt(j));
            File[] files = subdir.listFiles(PersistentDataStore.RouterInfoFilter.getInstance());
            if (files == null) continue;
            routerCount += files.length;
            for (int i = 0; i < files.length; ++i) {
                toRead.add(files[i]);
            }
        }
        if (toRead.isEmpty()) {
            System.out.println("No files to copy in " + dbDir);
            System.exit(1);
        }
        Collections.shuffle(toRead);
        int copied = 0;
        long tooOld = System.currentTimeMillis() - 604800000L;
        HashMap<String, String> ipMap = new HashMap<String, String>(count);
        for (File file : toRead) {
            if (copied >= count) break;
            Hash key = PersistentDataStore.getRouterInfoHash(file.getName());
            if (key == null) {
                System.out.println("Skipping bad " + file);
                continue;
            }
            if (key.equals((Object)me)) {
                System.out.println("Skipping my RI");
                continue;
            }
            fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(file));
                RouterInfo ri = new RouterInfo();
                ri.readBytes(fis, true);
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                fis = null;
                if (ri.getPublished() < tooOld) {
                    System.out.println("Skipping too old " + key);
                    continue;
                }
                if (ri.getCapabilities().contains("U")) {
                    System.out.println("Skipping unreachable " + key);
                    continue;
                }
                if (ri.getCapabilities().contains("K")) {
                    System.out.println("Skipping slow " + key);
                    continue;
                }
                Collection addrs = ri.getAddresses();
                if (addrs.isEmpty()) {
                    System.out.println("Skipping hidden " + key);
                    continue;
                }
                boolean hasIntro = false;
                boolean hasIPv4 = false;
                boolean dupIP = false;
                for (RouterAddress addr : addrs) {
                    if ("SSU".equals(addr.getTransportStyle()) && addr.getOption("ihost0") != null) {
                        hasIntro = true;
                        break;
                    }
                    String host = addr.getHost();
                    if (host == null || !host.contains(".")) continue;
                    hasIPv4 = true;
                    geoIP.add(host);
                    String old = ipMap.put(host, file.getName());
                    if (old == null || old.equals(file.getName())) continue;
                    dupIP = true;
                    break;
                }
                if (dupIP) {
                    System.out.println("Skipping dup IP " + key);
                    continue;
                }
                if (hasIntro) {
                    System.out.println("Skipping introduced " + key);
                    continue;
                }
                if (!hasIPv4) {
                    System.out.println("Skipping IPv6-only " + key);
                    continue;
                }
                File toFile = new File(toDir, file.getName());
                boolean ok = FileUtil.copy((File)file, (File)toFile, (boolean)true, (boolean)true);
                if (ok) {
                    ++copied;
                    continue;
                }
                System.out.println("Failed copy of " + file + " to " + toDir);
            }
            catch (Exception e) {
                System.out.println("Skipping bad " + file);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (copied > 0) {
            geoIP.blockingLookup();
            for (Map.Entry entry : ipMap.entrySet()) {
                String name;
                File toFile;
                String co = geoIP.get((String)entry.getKey());
                if (co == null || !BadCountries.contains(co) || !(toFile = new File(toDir, name = (String)entry.getValue())).delete()) continue;
                String full = geoIP.fullName(co);
                if (full == null) {
                    full = co;
                }
                System.out.println("Skipping " + full + ": " + name);
                --copied;
            }
        }
        if (copied > 0) {
            System.out.println("Copied " + copied + " router info files to " + toDir);
        } else {
            System.out.println("Failed to copy any files to " + toDir);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: PersistentDataStore [-i $HOME/.i2p] [-o netDb/] [-c 200]");
    }
}

