/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.util.Log;

class OutboundClientMessageJobHelper {
    private static final long ACK_EXTRA_EXPIRATION = 60000L;

    OutboundClientMessageJobHelper() {
    }

    static GarlicMessage createGarlicMessage(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, int tagsToSendOverride, int lowTagsOverride, SessionKey wrappedKey, Set<SessionTag> wrappedTags, boolean requireAck, LeaseSet bundledReplyLeaseSet) {
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(from);
        if (skm == null) {
            return null;
        }
        GarlicConfig config = OutboundClientMessageJobHelper.createGarlicConfig(ctx, replyToken, expiration, recipientPK, dataClove, from, dest, replyTunnel, requireAck, bundledReplyLeaseSet, skm);
        if (config == null) {
            return null;
        }
        int tagsToSend = replyToken >= 0L ? (tagsToSendOverride > 0 ? tagsToSendOverride : skm.getTagsToSend()) : 0;
        int lowThreshold = lowTagsOverride > 0 ? lowTagsOverride : skm.getLowThreshold();
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, tagsToSend, lowThreshold, skm);
        return msg;
    }

    private static GarlicConfig createGarlicConfig(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, boolean requireAck, LeaseSet bundledReplyLeaseSet, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        if (replyToken >= 0L && log.shouldLog(10)) {
            log.debug("Reply token: " + replyToken);
        }
        GarlicConfig config = new GarlicConfig();
        if (requireAck) {
            PayloadGarlicConfig ackClove = OutboundClientMessageJobHelper.buildAckClove(ctx, from, replyTunnel, replyToken, expiration + 60000L, skm);
            if (ackClove == null) {
                return null;
            }
            config.addClove(ackClove);
        }
        if (bundledReplyLeaseSet != null) {
            PayloadGarlicConfig leaseSetClove = OutboundClientMessageJobHelper.buildLeaseSetClove(ctx, expiration, bundledReplyLeaseSet);
            config.addClove(leaseSetClove);
        }
        config.addClove(dataClove);
        config.setCertificate(Certificate.NULL_CERT);
        config.setDeliveryInstructions(DeliveryInstructions.LOCAL);
        config.setId(ctx.random().nextLong(0xFFFFFFFFL));
        config.setExpiration(expiration);
        config.setRecipientPublicKey(recipientPK);
        if (log.shouldLog(20)) {
            log.info("Creating garlic config to be encrypted to " + recipientPK + " for destination " + dest.calculateHash().toBase64());
        }
        return config;
    }

    private static PayloadGarlicConfig buildAckClove(RouterContext ctx, Hash from, TunnelInfo replyToTunnel, long replyToken, long expiration, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        if (replyToTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Unable to send client message from " + from.toBase64() + ", as there are no inbound tunnels available");
            }
            return null;
        }
        TunnelId replyToTunnelId = replyToTunnel.getReceiveTunnelId(0);
        Hash replyToTunnelRouter = replyToTunnel.getPeer(0);
        if (log.shouldLog(10)) {
            log.debug("Ack for the data message will come back along tunnel " + replyToTunnelId + ": " + replyToTunnel);
        }
        DeliveryInstructions ackInstructions = new DeliveryInstructions();
        ackInstructions.setDeliveryMode(3);
        ackInstructions.setRouter(replyToTunnelRouter);
        ackInstructions.setTunnelId(replyToTunnelId);
        PayloadGarlicConfig ackClove = new PayloadGarlicConfig();
        ackClove.setCertificate(Certificate.NULL_CERT);
        ackClove.setDeliveryInstructions(ackInstructions);
        ackClove.setExpiration(expiration);
        ackClove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        DeliveryStatusMessage dsm = OutboundClientMessageJobHelper.buildDSM(ctx, replyToken);
        GarlicMessage msg = OutboundClientMessageJobHelper.wrapDSM(ctx, skm, dsm);
        ackClove.setPayload(msg);
        return ackClove;
    }

    private static DeliveryStatusMessage buildDSM(RouterContext ctx, long replyToken) {
        DeliveryStatusMessage msg = new DeliveryStatusMessage(ctx);
        msg.setArrival(ctx.clock().now());
        msg.setMessageId(replyToken);
        return msg;
    }

    private static GarlicMessage wrapDSM(RouterContext ctx, SessionKeyManager skm, DeliveryStatusMessage dsm) {
        MessageWrapper.OneTimeSession sess = MessageWrapper.generateSession(ctx, skm);
        GarlicMessage msg = MessageWrapper.wrap(ctx, (I2NPMessage)dsm, sess);
        return msg;
    }

    private static PayloadGarlicConfig buildDataClove(RouterContext ctx, Payload data, Destination dest, long expiration) {
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(1);
        instructions.setDestination(dest.calculateHash());
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setDeliveryInstructions(instructions);
        clove.setExpiration(expiration);
        clove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        DataMessage msg = new DataMessage(ctx);
        msg.setData(data.getEncryptedData());
        clove.setPayload(msg);
        return clove;
    }

    private static PayloadGarlicConfig buildLeaseSetClove(RouterContext ctx, long expiration, LeaseSet replyLeaseSet) {
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setDeliveryInstructions(DeliveryInstructions.LOCAL);
        clove.setExpiration(expiration);
        clove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        DatabaseStoreMessage msg = new DatabaseStoreMessage(ctx);
        msg.setEntry((DatabaseEntry)replyLeaseSet);
        msg.setMessageExpiration(expiration);
        clove.setPayload(msg);
        return clove;
    }
}

