/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.util.Log;

class ClientListenerRunner
implements Runnable {
    protected final Log _log;
    protected final RouterContext _context;
    protected final ClientManager _manager;
    protected ServerSocket _socket;
    protected final int _port;
    protected final boolean _bindAllInterfaces;
    protected volatile boolean _running;
    protected volatile boolean _listening;
    public static final String BIND_ALL_INTERFACES = "i2cp.tcp.bindAllInterfaces";
    protected static final int CONNECT_TIMEOUT = 5000;
    private static final int LOOP_DELAY = 250;

    public ClientListenerRunner(RouterContext context, ClientManager manager, int port) {
        this._context = context;
        this._log = this._context.logManager().getLog(this.getClass());
        this._manager = manager;
        this._port = port;
        this._bindAllInterfaces = context.getBooleanProperty(BIND_ALL_INTERFACES);
    }

    public boolean isListening() {
        return this._running && this._listening;
    }

    protected ServerSocket getServerSocket() throws IOException {
        if (this._bindAllInterfaces) {
            if (this._log.shouldLog(20)) {
                this._log.info("Listening on port " + this._port + " on all interfaces");
            }
            return new ServerSocket(this._port);
        }
        String listenInterface = this._context.getProperty("i2cp.hostname", "127.0.0.1");
        if (this._log.shouldLog(20)) {
            this._log.info("Listening on port " + this._port + " of the specific interface: " + listenInterface);
        }
        return new ServerSocket(this._port, 0, InetAddress.getByName(listenInterface));
    }

    @Override
    public void run() {
        this.runServer();
    }

    /*
     * Exception decompiling
     */
    protected void runServer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean validate(Socket socket) {
        try {
            InputStream is = socket.getInputStream();
            for (int i = 0; i < 20; ++i) {
                if (is.available() > 0) {
                    return is.read() == 42;
                }
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Peer did not authenticate themselves as I2CP quickly enough, dropping");
        }
        return false;
    }

    protected void runConnection(Socket socket) {
        ClientConnectionRunner runner = new ClientConnectionRunner(this._context, this._manager, socket);
        this._manager.registerConnection(runner);
    }

    public void stopListening() {
        this._running = false;
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

