/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterInfo;
import net.i2p.router.Router;

public class MultiRouter {
    private static final int BASE_PORT = 5000;
    private static int nbrRouters;
    private static PrintStream _out;
    private static ArrayList<Router> _routers;
    private static I2PAppContext _defaultContext;

    public static void main(String[] args) {
        int i;
        if (args == null || args.length < 1) {
            MultiRouter.usage();
            return;
        }
        Scanner scan = new Scanner(args[0]);
        if (!scan.hasNextInt()) {
            MultiRouter.usage();
            scan.close();
            return;
        }
        nbrRouters = scan.nextInt();
        if (nbrRouters < 0) {
            MultiRouter.usage();
            scan.close();
            return;
        }
        scan.close();
        _out = System.out;
        MultiRouter.buildClientProps(0);
        _defaultContext = new I2PAppContext(MultiRouter.buildRouterProps(0));
        _defaultContext.clock().setOffset(0L);
        _out.println("RouterConsole for Router 0 is listening on: 127.0.0.1:4999");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                _out.println("Shutting down in a few moments..");
                for (Router r : _routers) {
                    r.shutdown(0);
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(0);
            }
        });
        for (i = 0; i < nbrRouters; ++i) {
            Router router = new Router(MultiRouter.buildRouterProps(i));
            router.setKillVMOnEnd(false);
            _routers.add(router);
            _out.println("Router " + i + " was created");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        for (i = 0; i < nbrRouters; ++i) {
            final Router r = _routers.get(i);
            long offset = r.getContext().random().nextLong(30000L);
            if (r.getContext().random().nextBoolean()) {
                offset = 0L - offset;
            }
            r.getContext().clock().setOffset(offset, true);
            new Thread(){

                @Override
                public void run() {
                    r.runRouter();
                }
            }.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            _out.println("Router " + i + " was started with time offset " + offset);
        }
        _out.println("All routers have been started");
        int waitForRouters = nbrRouters / 10 * 1000;
        _out.println("Waiting " + waitForRouters / 1000 + " seconds for routers to start" + "before doing the internal reseed");
        try {
            Thread.sleep(waitForRouters);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        MultiRouter.internalReseed();
        MultiRouter.waitForCompletion();
    }

    private static void internalReseed() {
        HashSet<RouterInfo> riSet = new HashSet<RouterInfo>();
        for (Router r : _routers) {
            riSet.addAll(r.getContext().netDb().getRouters());
        }
        for (Router r : _routers) {
            for (RouterInfo ri : riSet) {
                r.getContext().netDb().publish(ri);
            }
        }
        _out.println(riSet.size() + " RouterInfos were reseeded");
    }

    private static Properties buildRouterProps(int id) {
        Properties props = MultiRouter.getRouterProps(id);
        File f = new File(props.getProperty("router.configLocation"));
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                DataHelper.storeProps((Properties)props, (File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    private static Properties getRouterProps(int id) {
        Properties props = new Properties();
        props.setProperty("router.profileDir", "/peerProfiles");
        props.setProperty("router.sessionKeys.location", "/sessionKeys.dat");
        props.setProperty("router.info.location", "/router.info");
        props.setProperty("router.keys.location", "/router.keys");
        props.setProperty("router.networkDatabase.dbDir", "/netDb");
        props.setProperty("router.tunnelPoolFile", "/tunnelPool.dat");
        props.setProperty("router.keyBackupDir", "/keyBackup");
        props.setProperty("router.clientConfigFile", MultiRouter.getBaseDir(id) + "/clients.config");
        props.setProperty("router.configLocation", MultiRouter.getBaseDir(id) + "/router.config");
        props.setProperty("router.pingFile", MultiRouter.getBaseDir(id) + "/router.ping");
        props.setProperty("router.rejectStartupTime", "0");
        props.setProperty("router.reseedDisable", "true");
        props.setProperty("i2p.dir.app", MultiRouter.getBaseDir(id));
        props.setProperty("i2p.dir.config", MultiRouter.getBaseDir(id));
        props.setProperty("i2p.dir.log", MultiRouter.getBaseDir(id));
        props.setProperty("i2p.dir.router", MultiRouter.getBaseDir(id));
        props.setProperty("i2p.dir.pid", MultiRouter.getBaseDir(id));
        props.setProperty("i2np.ntcp.hostname", "127.0.0.1");
        props.setProperty("i2np.udp.host", "127.0.0.1");
        props.setProperty("i2np.ntcp.port", 5000 + id + "");
        props.setProperty("i2np.udp.port", 5000 + id + "");
        props.setProperty("i2np.ntcp.allowLocal", "true");
        props.setProperty("i2np.udp.allowLocal", "true");
        props.setProperty("i2np.udp.internalPort", 5000 + id + "");
        props.setProperty("i2cp.port", Integer.toString(5000 + nbrRouters + id));
        return props;
    }

    private static Properties buildClientProps(int id) {
        Properties rProps = MultiRouter.getRouterProps(id);
        Properties props = MultiRouter.getClientProps();
        File f = new File(rProps.getProperty("router.clientConfigFile"));
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                DataHelper.storeProps((Properties)props, (File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    private static Properties getClientProps() {
        Properties props = new Properties();
        props.setProperty("clientApp.0.args", "4999 127.0.0.1 ./webapps");
        props.setProperty("clientApp.0.main", "net.i2p.router.web.RouterConsoleRunner");
        props.setProperty("clientApp.0.name", "webconsole");
        props.setProperty("clientApp.0.onBoot", "true");
        props.setProperty("clientApp.1.args", "i2ptunnel.config");
        props.setProperty("clientApp.1.main", "net.i2p.i2ptunnel.TunnelControllerGroup");
        props.setProperty("clientApp.1.name", "tunnels");
        props.setProperty("clientApp.1.delay", "6");
        return props;
    }

    private static String getBaseDir(int id) {
        File f = new File(".");
        return f.getAbsoluteFile().getParentFile().toString() + "/multirouter/" + Integer.toString(id);
    }

    private static void waitForCompletion() {
        while (true) {
            int alive = 0;
            for (int i = 0; i < _routers.size(); ++i) {
                Router r = _routers.get(i);
                if (!r.isAlive()) {
                    _out.println("Router " + i + " is dead");
                    continue;
                }
                ++alive;
            }
            if (alive <= 0) break;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        _out.println("All routers shut down");
    }

    private static void usage() {
        System.err.println("Usage: MultiRouter nbr_routers");
        System.err.println("       Where nbr_routers > 0");
    }

    static {
        _routers = new ArrayList(8);
    }
}

