/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block.index;

import java.io.IOException;
import java.util.HashMap;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipLevels;
import net.metanotion.io.block.index.BSkipSpan;
import net.metanotion.io.block.index.IBSkipIterator;
import net.metanotion.io.block.index.IBSkipSpan;
import net.metanotion.util.skiplist.SkipIterator;
import net.metanotion.util.skiplist.SkipLevels;
import net.metanotion.util.skiplist.SkipList;
import net.metanotion.util.skiplist.SkipSpan;

public class BSkipList
extends SkipList {
    private static final long MAGIC = 6011014058695291764L;
    public int firstSpanPage = 0;
    public int firstLevelPage = 0;
    public int skipPage = 0;
    public final BlockFile bf;
    private boolean isClosed;
    final HashMap<Integer, BSkipSpan> spanHash = new HashMap();
    final HashMap<Integer, SkipLevels> levelHash = new HashMap();
    private final boolean fileOnly;

    public BSkipList(int spanSize, BlockFile bf, int skipPage, Serializer key, Serializer val) throws IOException {
        this(spanSize, bf, skipPage, key, val, false);
    }

    public BSkipList(int spanSize, BlockFile bf, int skipPage, Serializer key, Serializer val, boolean fileOnly) throws IOException {
        if (spanSize < 1) {
            throw new RuntimeException("Span size too small");
        }
        this.skipPage = skipPage;
        this.bf = bf;
        BlockFile.pageSeek(bf.file, skipPage);
        long magic = bf.file.readLong();
        if (magic != 6011014058695291764L) {
            throw new IOException("Bad SkipList magic number 0x" + Long.toHexString(magic) + " on page " + skipPage);
        }
        this.firstSpanPage = bf.file.readUnsignedInt();
        this.firstLevelPage = bf.file.readUnsignedInt();
        this.size = bf.file.readUnsignedInt();
        int spans = bf.file.readInt();
        int levelCount = bf.file.readInt();
        this.fileOnly = fileOnly;
        this.first = fileOnly ? new IBSkipSpan(bf, this, this.firstSpanPage, key, val) : new BSkipSpan(bf, this, this.firstSpanPage, key, val);
        this.stack = new BSkipLevels(bf, this.firstLevelPage, this);
        int total = 0;
        for (BSkipSpan ss : this.spanHash.values()) {
            total += ss.nKeys;
        }
        if (bf.log.shouldLog(10)) {
            bf.log.debug("Loaded " + this + " cached " + this.levelHash.size() + " levels and " + this.spanHash.size() + " spans with " + total + " entries");
        }
        if (bf.file.canWrite() && (levelCount != this.levelHash.size() || spans != this.spanHash.size() || this.size != total)) {
            if (bf.log.shouldLog(30)) {
                bf.log.warn("On-disk counts were " + levelCount + " / " + spans + " / " + this.size + ", correcting");
            }
            this.size = total;
            this.flush();
        }
    }

    public void close() {
        this.flush();
        this.spanHash.clear();
        this.levelHash.clear();
        this.isClosed = true;
    }

    @Override
    public void flush() {
        if (!this.bf.file.canWrite()) {
            return;
        }
        if (this.isClosed) {
            this.bf.log.error("Already closed!! " + this, new Exception());
            return;
        }
        try {
            BlockFile.pageSeek(this.bf.file, this.skipPage);
            this.bf.file.writeLong(6011014058695291764L);
            this.bf.file.writeInt(this.firstSpanPage);
            this.bf.file.writeInt(this.firstLevelPage);
            this.bf.file.writeInt(Math.max(0, this.size));
            this.bf.file.writeInt(this.spanHash.size());
            this.bf.file.writeInt(this.levelHash.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error writing to database", ioe);
        }
    }

    public void delete() throws IOException {
        if (this.isClosed) {
            this.bf.log.error("Already closed!! " + this, new Exception());
            return;
        }
        SkipLevels curLevel = this.stack;
        while (curLevel != null) {
            SkipLevels nextLevel = curLevel.levels[0];
            curLevel.killInstance();
            curLevel = nextLevel;
        }
        this.stack.killInstance();
        SkipSpan curSpan = this.first;
        while (curSpan != null) {
            SkipSpan nextSpan = curSpan.next;
            curSpan.killInstance();
            curSpan = nextSpan;
        }
        this.bf.freePage(this.skipPage);
        this.spanHash.clear();
        this.levelHash.clear();
        this.isClosed = true;
    }

    public static void init(BlockFile bf, int page, int spanSize) throws IOException {
        int firstSpan = bf.allocPage();
        int firstLevel = bf.allocPage();
        BlockFile.pageSeek(bf.file, page);
        bf.file.writeLong(6011014058695291764L);
        bf.file.writeInt(firstSpan);
        bf.file.writeInt(firstLevel);
        bf.file.writeInt(0);
        bf.file.writeInt(1);
        bf.file.writeInt(1);
        BSkipSpan.init(bf, firstSpan, spanSize);
        BSkipLevels.init(bf, firstLevel, firstSpan, 4);
    }

    @Override
    public int maxLevels() {
        int hob = 0;
        for (int s = this.spanHash.size(); s > 0; s /= 2) {
            ++hob;
        }
        int max = Math.max(hob, super.maxLevels());
        return Math.min(32, max);
    }

    @Override
    public SkipIterator iterator() {
        if (!this.fileOnly) {
            return super.iterator();
        }
        return new IBSkipIterator(this.first, 0);
    }

    @Override
    public SkipIterator min() {
        return this.iterator();
    }

    @Override
    public SkipIterator max() {
        if (!this.fileOnly) {
            return super.max();
        }
        SkipSpan ss = this.stack.getEnd();
        return new IBSkipIterator(ss, ss.nKeys - 1);
    }

    @Override
    public SkipIterator find(Comparable key) {
        if (!this.fileOnly) {
            return super.find(key);
        }
        int[] search = new int[1];
        SkipSpan ss = this.stack.getSpan(this.stack.levels.length - 1, key, search);
        if (search[0] < 0) {
            search[0] = -1 * (search[0] + 1);
        }
        return new IBSkipIterator(ss, search[0]);
    }

    public boolean bslck(boolean fix, boolean isMeta) {
        this.bf.log.info("    size " + this.size);
        this.bf.log.info("    spans " + this.spanHash.size());
        this.bf.log.info("    levels " + this.levelHash.size());
        this.bf.log.info("    skipPage " + this.skipPage);
        this.bf.log.info("    firstSpanPage " + this.firstSpanPage);
        this.bf.log.info("    firstLevelPage " + this.firstLevelPage);
        this.bf.log.info("    maxLevels " + this.maxLevels());
        boolean rv = this.stack.blvlck(fix);
        return rv;
    }

    public String toString() {
        String rv = this.getClass().getSimpleName() + " page " + this.skipPage;
        if (this.isClosed) {
            rv = rv + " CLOSED";
        }
        return rv;
    }
}

