/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;

public class PortMapper {
    private final ConcurrentHashMap<String, Integer> _dir = new ConcurrentHashMap(8);
    public static final String SVC_CONSOLE = "console";
    public static final String SVC_HTTPS_CONSOLE = "https_console";
    public static final String SVC_HTTP_PROXY = "HTTP";
    public static final String SVC_HTTPS_PROXY = "HTTPS";
    public static final String SVC_EEPSITE = "eepsite";
    public static final String SVC_IRC = "irc";
    public static final String SVC_SOCKS = "socks";
    public static final String SVC_TAHOE = "tahoe-lafs";
    public static final String SVC_SMTP = "SMTP";
    public static final String SVC_POP = "POP3";
    public static final String SVC_SAM = "SAM";
    public static final String SVC_BOB = "BOB";
    public static final String SVC_I2CP = "I2CP";

    public PortMapper(I2PAppContext context) {
    }

    public boolean register(String service, int port) {
        if (port <= 0) {
            return false;
        }
        return this._dir.putIfAbsent(service, port) == null;
    }

    public void unregister(String service) {
        this._dir.remove(service);
    }

    public int getPort(String service) {
        int port = this.getPort(service, -1);
        return port;
    }

    public int getPort(String service, int def) {
        Integer port = this._dir.get(service);
        if (port == null) {
            return def;
        }
        return port;
    }
}

