/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.i2p.I2PAppContext;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.util.Log;

public class I2PSSLSocketFactory {
    private final SSLSocketFactory _factory;

    public I2PSSLSocketFactory(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        this._factory = I2PSSLSocketFactory.initSSLContext(context, loadSystemCerts, relativeCertPath);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this._factory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this._factory.createSocket(host, port);
    }

    private static SSLSocketFactory initSSLContext(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        int adds;
        KeyStore ks;
        Log log = context.logManager().getLog(I2PSSLSocketFactory.class);
        if (loadSystemCerts) {
            ks = KeyStoreUtil.loadSystemKeyStore();
            if (ks == null) {
                throw new GeneralSecurityException("Key Store init error");
            }
        } else {
            try {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, "".toCharArray());
            }
            catch (IOException ioe) {
                throw new GeneralSecurityException("Key Store init error", ioe);
            }
        }
        File dir = new File(context.getConfigDir(), relativeCertPath);
        int totalAdds = adds = KeyStoreUtil.addCerts(dir, ks);
        if (adds > 0 && log.shouldLog(20)) {
            log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        File dir2 = new File(context.getBaseDir(), relativeCertPath);
        if (!dir.getAbsolutePath().equals(dir2.getAbsolutePath())) {
            adds = KeyStoreUtil.addCerts(dir2, ks);
            totalAdds += adds;
            if (adds > 0 && log.shouldLog(20)) {
                log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (totalAdds > 0 || loadSystemCerts) {
            if (log.shouldLog(20)) {
                log.info("Loaded total of " + totalAdds + " new trusted certificates");
            }
        } else {
            String msg = "No trusted certificates loaded (looked in " + dir.getAbsolutePath() + (dir.getAbsolutePath().equals(dir2.getAbsolutePath()) ? "" : " and " + dir2.getAbsolutePath()) + ", SSL connections will fail. " + "Copy the cert in " + relativeCertPath + " from the router to the directory.";
            throw new GeneralSecurityException(msg);
        }
        SSLContext sslc = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        sslc.init(null, tmf.getTrustManagers(), context.random());
        return sslc.getSocketFactory();
    }
}

