/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class SendMessageMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 5;
    protected SessionId _sessionId;
    protected Destination _destination;
    protected Payload _payload;
    protected long _nonce;

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public void setPayload(Payload payload) {
        this._payload = payload;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setNonce(long nonce) {
        this._nonce = nonce;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        throw new IllegalStateException("wtf, do not run me");
    }

    @Override
    public void readMessage(InputStream in, int length, int type) throws I2CPMessageException, IOException {
        if (type != this.getType()) {
            throw new I2CPMessageException("Invalid message type (found: " + type + " supported: " + this.getType() + " class: " + this.getClass().getName() + ")");
        }
        if (length < 0) {
            throw new IOException("Negative payload size");
        }
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._destination = Destination.create(in);
            this._payload = new Payload();
            this._payload.readBytes(in);
            this._nonce = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new RuntimeException("wtf, dont run me");
    }

    @Override
    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("No session ID");
        }
        if (this._destination == null) {
            throw new I2CPMessageException("No dest");
        }
        if (this._payload == null) {
            throw new I2CPMessageException("No payload");
        }
        if (this._nonce < 0L) {
            throw new I2CPMessageException("No nonce");
        }
        int len = 2 + this._destination.size() + this._payload.getSize() + 4 + 4;
        try {
            DataHelper.writeLong(out, 4, len);
            DataHelper.writeLong(out, 1, this.getType());
            this._sessionId.writeBytes(out);
            this._destination.writeBytes(out);
            this._payload.writeBytes(out);
            DataHelper.writeLong(out, 4, this._nonce);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing the msg", dfe);
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SendMessageMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tNonce: ").append(this.getNonce());
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tPayload: ").append(this.getPayload());
        buf.append("]");
        return buf.toString();
    }
}

