/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;

public class KeysAndCert
extends DataStructureImpl {
    protected PublicKey _publicKey;
    protected SigningPublicKey _signingKey;
    protected Certificate _certificate;
    private Hash __calculatedHash;
    protected byte[] _padding;

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        if (this._certificate != null) {
            throw new IllegalStateException();
        }
        this._certificate = cert;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setPublicKey(PublicKey key) {
        if (this._publicKey != null) {
            throw new IllegalStateException();
        }
        this._publicKey = key;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this._signingKey = key;
    }

    public void setPadding(byte[] padding) {
        if (this._padding != null) {
            throw new IllegalStateException();
        }
        this._padding = padding;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._publicKey != null || this._signingKey != null || this._certificate != null) {
            throw new IllegalStateException();
        }
        this._publicKey = PublicKey.create(in);
        SigningPublicKey spk = SigningPublicKey.create(in);
        Certificate cert = Certificate.create(in);
        if (cert.getCertificateType() == 5) {
            KeyCertificate kcert = cert.toKeyCertificate();
            this._signingKey = spk.toTypedKey(kcert);
            this._padding = spk.getPadding(kcert);
            this._certificate = kcert;
        } else {
            this._signingKey = spk;
            this._certificate = cert;
        }
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._certificate == null || this._publicKey == null || this._signingKey == null) {
            throw new DataFormatException("Not enough data to format the router identity");
        }
        this._publicKey.writeBytes(out);
        if (this._padding != null) {
            out.write(this._padding);
        }
        this._signingKey.writeTruncatedBytes(out);
        this._certificate.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof KeysAndCert)) {
            return false;
        }
        KeysAndCert ident = (KeysAndCert)object;
        return DataHelper.eq(this._signingKey, ident._signingKey) && DataHelper.eq(this._publicKey, ident._publicKey) && Arrays.equals(this._padding, ident._padding) && DataHelper.eq(this._certificate, ident._certificate);
    }

    public int hashCode() {
        if (this._signingKey == null) {
            return 0;
        }
        return this._signingKey.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append('[').append(this.getClass().getSimpleName()).append(": ");
        buf.append("\n\tHash: ").append(this.getHash().toBase64());
        buf.append("\n\tCertificate: ").append(this._certificate);
        buf.append("\n\tPublicKey: ").append(this._publicKey);
        buf.append("\n\tSigningPublicKey: ").append(this._signingKey);
        if (this._padding != null) {
            buf.append("\n\tPadding: ").append(this._padding.length).append(" bytes");
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public Hash calculateHash() {
        return this.getHash();
    }

    public Hash getHash() {
        byte[] identBytes;
        if (this.__calculatedHash != null) {
            return this.__calculatedHash;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(400);
            this.writeBytes(baos);
            identBytes = baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("KAC hash error", ioe);
        }
        catch (DataFormatException dfe) {
            throw new IllegalStateException("KAC hash error", dfe);
        }
        this.__calculatedHash = SHA256Generator.getInstance().calculateHash(identBytes);
        return this.__calculatedHash;
    }
}

