/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math;

import java.io.Serializable;
import net.i2p.crypto.eddsa.math.Constants;
import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.FieldElement;

public class Field
implements Serializable {
    private static final long serialVersionUID = 8746587465875676L;
    public final FieldElement zero;
    public final FieldElement one;
    public final FieldElement two;
    public final FieldElement four;
    public final FieldElement five;
    public final FieldElement eight;
    private final int b;
    private final FieldElement q;
    private final FieldElement qm2;
    private final FieldElement qm5d8;
    private final Encoding enc;

    public Field(int b, byte[] q, Encoding enc) {
        this.b = b;
        this.enc = enc;
        this.enc.setField(this);
        this.q = this.fromByteArray(q);
        this.zero = this.fromByteArray(Constants.ZERO);
        this.one = this.fromByteArray(Constants.ONE);
        this.two = this.fromByteArray(Constants.TWO);
        this.four = this.fromByteArray(Constants.FOUR);
        this.five = this.fromByteArray(Constants.FIVE);
        this.eight = this.fromByteArray(Constants.EIGHT);
        this.qm2 = this.q.subtract(this.two);
        this.qm5d8 = this.q.subtract(this.five).divide(this.eight);
    }

    public FieldElement fromByteArray(byte[] x) {
        return this.enc.decode(x);
    }

    public int getb() {
        return this.b;
    }

    public FieldElement getQ() {
        return this.q;
    }

    public FieldElement getQm2() {
        return this.qm2;
    }

    public FieldElement getQm5d8() {
        return this.qm5d8;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        Field f = (Field)obj;
        return this.b == f.b && this.q.equals(f.q);
    }
}

