/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.impl.ConnectionOptions;

class StandardSocket
extends Socket {
    private final I2PSocket _socket;

    StandardSocket(I2PSocket socket) {
        this._socket = socket;
    }

    @Override
    public void bind(SocketAddress bindpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this._socket.isClosed()) {
            throw new IOException("Already closed");
        }
        this._socket.close();
    }

    @Override
    public void connect(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream rv = this._socket.getInputStream();
        if (rv != null) {
            return rv;
        }
        throw new IOException("No stream");
    }

    @Override
    public boolean getKeepAlive() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return false;
        }
        return opts.getInactivityAction() == 2;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public boolean getOOBInline() {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream rv = this._socket.getOutputStream();
        if (rv != null) {
            return rv;
        }
        throw new IOException("No stream");
    }

    @Override
    public int getPort() {
        return this._socket.getPort();
    }

    @Override
    public int getReceiveBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getReuseAddress() {
        return false;
    }

    @Override
    public int getSendBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    @Override
    public int getSoLinger() {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            return -1;
        }
        return -1;
    }

    @Override
    public int getSoTimeout() {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            return 0;
        }
        return (int)opts.getReadTimeout();
    }

    @Override
    public boolean getTcpNoDelay() {
        return false;
    }

    @Override
    public int getTrafficClass() {
        return 0;
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this._socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return !this._socket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this._socket.isClosed();
    }

    @Override
    public boolean isOutputShutdown() {
        return this._socket.isClosed();
    }

    @Override
    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeepAlive(boolean on) {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return;
        }
        if (on) {
            opts.setInactivityAction(2);
        } else {
            opts.setInactivityAction(0);
        }
    }

    @Override
    public void setOOBInline(boolean on) {
        if (on) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setReuseAddress(boolean on) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            throw new SocketException("No options");
        }
        opts.setReadTimeout((long)timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) {
    }

    @Override
    public void setTrafficClass(int tc) {
    }

    @Override
    public void shutdownInput() throws IOException {
        this.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.close();
    }

    @Override
    public String toString() {
        return this._socket.toString();
    }
}

