/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.irc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelDCCServer
extends I2PTunnelServer {
    private final ConcurrentHashMap<Integer, LocalAddress> _outgoing = new ConcurrentHashMap(8);
    private final ConcurrentHashMap<Integer, LocalAddress> _active = new ConcurrentHashMap(8);
    private final ConcurrentHashMap<Integer, LocalAddress> _resume = new ConcurrentHashMap(8);
    private final List<I2PSocket> _sockList = new CopyOnWriteArrayList<I2PSocket>();
    private static final InetAddress DUMMY;
    private static final int MIN_I2P_PORT = 1;
    private static final int MAX_I2P_PORT = 65535;
    private static final int MAX_OUTGOING_PENDING = 20;
    private static final int MAX_OUTGOING_ACTIVE = 20;
    private static final long OUTBOUND_EXPIRE = 1800000L;

    public I2PTunnelDCCServer(I2PSocketManager sktMgr, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(DUMMY, 0, sktMgr, l, notifyThis, tunnel);
    }

    @Override
    protected void blockingHandle(I2PSocket socket) {
        if (this._log.shouldLog(20)) {
            this._log.info("Incoming connection to '" + this.toString() + "' from: " + socket.getPeerDestination().calculateHash().toBase64());
        }
        try {
            this.expireOutbound();
            int myPort = socket.getLocalPort();
            LocalAddress local = this._outgoing.remove(myPort);
            if (local == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rejecting incoming DCC connection for unknown port " + myPort);
                }
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Incoming DCC connection for I2P port " + myPort + " sending to " + local.ia + ':' + local.port);
            }
            try {
                Socket s = new Socket(local.ia, local.port);
                this._sockList.add(socket);
                I2PTunnelRunner t = new I2PTunnelRunner(s, socket, this.slock, null, null, this._sockList, (I2PTunnelRunner.FailCallback)null);
                t.start();
                local.socket = socket;
                local.expire = this.getTunnel().getContext().clock().now() + 1800000L;
                this._active.put(myPort, local);
            }
            catch (SocketException ex) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this._log.error("Error relaying incoming DCC connection to IRC client at " + local.ia + ':' + local.port, ex);
            }
        }
        catch (IOException ex) {
            this._log.error("Error while waiting for I2PConnections", ex);
        }
    }

    @Override
    public boolean close(boolean forced) {
        this._outgoing.clear();
        this._active.clear();
        for (I2PSocket s : this._sockList) {
            try {
                s.close();
            }
            catch (IOException ioe) {}
        }
        this._sockList.clear();
        return super.close(forced);
    }

    public int newOutgoing(byte[] ip, int port, String type) {
        return this.newOutgoing(ip, port, type, 0);
    }

    private int newOutgoing(byte[] ip, int port, String type, int i2pPort) {
        InetAddress ia;
        this.expireOutbound();
        if (this._outgoing.size() >= 20 || this._active.size() >= 20) {
            this._log.error("Too many outgoing DCC, max is 20/20 pending/active");
            return -1;
        }
        try {
            ia = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            return -1;
        }
        int limit = i2pPort > 0 ? 10 : 1;
        LocalAddress client = new LocalAddress(ia, port, this.getTunnel().getContext().clock().now() + 1800000L);
        for (int i = 0; i < limit; ++i) {
            LocalAddress old;
            int iport = i2pPort > 0 ? i2pPort : 1 + this.getTunnel().getContext().random().nextInt(65535);
            if (this._active.containsKey(iport) || (old = this._outgoing.putIfAbsent(iport, client)) != null) continue;
            return iport;
        }
        return -1;
    }

    public int resumeIncoming(int port) {
        Integer iport = port;
        LocalAddress local = this._active.remove(iport);
        if (local != null) {
            local.expire = this.getTunnel().getContext().clock().now() + 1800000L;
            this._resume.put(local.port, local);
            return local.port;
        }
        local = this._outgoing.get(iport);
        if (local != null) {
            local.expire = this.getTunnel().getContext().clock().now() + 1800000L;
            return local.port;
        }
        return -1;
    }

    public int acceptOutgoing(int port) {
        Iterator<Map.Entry<Integer, LocalAddress>> iter = this._resume.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, LocalAddress> e = iter.next();
            LocalAddress local = e.getValue();
            if (local.port != port) continue;
            iter.remove();
            return this.newOutgoing(local.ia.getAddress(), port, "ACCEPT", e.getKey());
        }
        return -1;
    }

    private void expireOutbound() {
        LocalAddress a;
        Iterator<LocalAddress> iter = this._outgoing.values().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            if (a.expire >= this.getTunnel().getContext().clock().now()) continue;
            iter.remove();
        }
        iter = this._active.values().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            I2PSocket s = a.socket;
            if (s == null || !s.isClosed()) continue;
            iter.remove();
        }
    }

    static {
        InetAddress dummy = null;
        try {
            dummy = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DUMMY = dummy;
    }

    private static class LocalAddress {
        public final InetAddress ia;
        public final int port;
        public long expire;
        public I2PSocket socket;

        public LocalAddress(InetAddress a, int p, long exp) {
            this.ia = a;
            this.port = p;
            this.expire = exp;
        }
    }
}

