/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.util.BigPipedInputStream;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.ReusableGZIPInputStream;

class HTTPResponseOutputStream
extends FilterOutputStream {
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private final Log _log = this._context.logManager().getLog(this.getClass());
    protected ByteArray _headerBuffer = _cache.acquire();
    private boolean _headerWritten;
    private final byte[] _buf1 = new byte[1];
    protected boolean _gzip;
    protected long _dataExpected;
    protected String _contentType;
    private static final int CACHE_SIZE = 8192;
    private static final ByteCache _cache = ByteCache.getInstance(8, 8192);
    private static final int MAX_HEADER_SIZE = 65536;
    private static final byte NL = 10;

    public HTTPResponseOutputStream(OutputStream raw) {
        super(raw);
    }

    @Override
    public void write(int c) throws IOException {
        this._buf1[0] = (byte)c;
        this.write(this._buf1, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (this._headerWritten) {
            this.out.write(buf, off, len);
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.ensureCapacity();
            this._headerBuffer.getData()[this._headerBuffer.getValid()] = buf[off + i];
            this._headerBuffer.setValid(this._headerBuffer.getValid() + 1);
            if (!this.headerReceived()) continue;
            this.writeHeader();
            this._headerWritten = true;
            if (i + 1 < len) {
                this.out.write(buf, off + i + 1, len - i - 1);
            }
            return;
        }
    }

    private void ensureCapacity() throws IOException {
        if (this._headerBuffer.getValid() >= 65536) {
            throw new IOException("Max header size exceeded: 65536");
        }
        if (this._headerBuffer.getValid() + 1 >= this._headerBuffer.getData().length) {
            int newSize = (int)((double)this._headerBuffer.getData().length * 1.5);
            ByteArray newBuf = new ByteArray(new byte[newSize]);
            System.arraycopy(this._headerBuffer.getData(), 0, newBuf.getData(), 0, this._headerBuffer.getValid());
            newBuf.setValid(this._headerBuffer.getValid());
            newBuf.setOffset(0);
            if (this._headerBuffer.getData().length == 8192) {
                _cache.release(this._headerBuffer);
            }
            this._headerBuffer = newBuf;
        }
    }

    private boolean headerReceived() {
        if (this._headerBuffer.getValid() < 3) {
            return false;
        }
        byte first = this._headerBuffer.getData()[this._headerBuffer.getValid() - 3];
        byte second = this._headerBuffer.getData()[this._headerBuffer.getValid() - 2];
        byte third = this._headerBuffer.getData()[this._headerBuffer.getValid() - 1];
        return HTTPResponseOutputStream.isNL(second) && HTTPResponseOutputStream.isNL(third) || HTTPResponseOutputStream.isNL(first) && HTTPResponseOutputStream.isNL(third);
    }

    protected String filterResponseLine(String line) {
        return line;
    }

    private static boolean isNL(byte b) {
        return b == 10;
    }

    private void writeHeader() throws IOException {
        String responseLine = null;
        boolean connectionSent = false;
        boolean proxyConnectionSent = false;
        int lastEnd = -1;
        for (int i = 0; i < this._headerBuffer.getValid(); ++i) {
            if (!HTTPResponseOutputStream.isNL(this._headerBuffer.getData()[i])) continue;
            if (lastEnd == -1) {
                responseLine = new String(this._headerBuffer.getData(), 0, i + 1);
                responseLine = this.filterResponseLine(responseLine);
                responseLine = responseLine.trim() + "\r\n";
                this.out.write(responseLine.getBytes());
            } else {
                for (int j = lastEnd + 1; j < i; ++j) {
                    String lcVal;
                    String lcKey;
                    if (this._headerBuffer.getData()[j] != 58) continue;
                    int keyLen = j - (lastEnd + 1);
                    int valLen = i - (j + 1);
                    if (keyLen <= 0 || valLen < 0) {
                        throw new IOException("Invalid header @ " + j);
                    }
                    String key = new String(this._headerBuffer.getData(), lastEnd + 1, keyLen);
                    String val = null;
                    val = valLen == 0 ? "" : new String(this._headerBuffer.getData(), j + 2, valLen).trim();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Response header [" + key + "] = [" + val + "]");
                    }
                    if ("connection".equals(lcKey = key.toLowerCase(Locale.US))) {
                        this.out.write("Connection: close\r\n".getBytes());
                        connectionSent = true;
                        break;
                    }
                    if ("proxy-connection".equals(lcKey)) {
                        this.out.write("Proxy-Connection: close\r\n".getBytes());
                        proxyConnectionSent = true;
                        break;
                    }
                    if ("content-encoding".equals(lcKey) && "x-i2p-gzip".equals(val.toLowerCase(Locale.US))) {
                        this._gzip = true;
                        break;
                    }
                    if ("proxy-authenticate".equals(lcKey)) break;
                    if ("content-length".equals(lcKey)) {
                        try {
                            this._dataExpected = Long.parseLong(val);
                        }
                        catch (NumberFormatException nfe) {}
                    } else if ("content-type".equals(lcKey)) {
                        this._contentType = val;
                    } else if ("set-cookie".equals(lcKey) && ((lcVal = val.toLowerCase(Locale.US)).contains("domain=b32.i2p") || lcVal.contains("domain=.b32.i2p"))) {
                        if (!this._log.shouldLog(20)) break;
                        this._log.info("Stripping \"" + key + ": " + val + "\" from response ");
                        break;
                    }
                    this.out.write((key.trim() + ": " + val.trim() + "\r\n").getBytes());
                    break;
                }
            }
            lastEnd = i;
        }
        if (!connectionSent) {
            this.out.write("Connection: close\r\n".getBytes());
        }
        if (!proxyConnectionSent) {
            this.out.write("Proxy-Connection: close\r\n".getBytes());
        }
        this.finishHeaders();
        boolean shouldCompress = this.shouldCompress();
        if (this._log.shouldLog(20)) {
            this._log.info("After headers: gzip? " + this._gzip + " compress? " + shouldCompress);
        }
        if (this._headerBuffer.getData().length == 8192) {
            _cache.release(this._headerBuffer);
        } else {
            this._headerBuffer = null;
        }
        if (shouldCompress) {
            this.beginProcessing();
        }
    }

    protected boolean shouldCompress() {
        return this._gzip;
    }

    protected void finishHeaders() throws IOException {
        this.out.write("\r\n".getBytes());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    protected void beginProcessing() throws IOException {
        PipedInputStream pi = BigPipedInputStream.getInstance();
        PipedOutputStream po = new PipedOutputStream(pi);
        I2PTunnelClientBase.getClientExecutor().execute(new Pusher(pi, this.out));
        this.out = po;
    }

    private class Pusher
    implements Runnable {
        private final InputStream _inRaw;
        private final OutputStream _out;

        public Pusher(InputStream in, OutputStream out) {
            this._inRaw = in;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReusableGZIPInputStream _in = ReusableGZIPInputStream.acquire();
            long written = 0L;
            ByteArray ba = null;
            try {
                _in.initialize(this._inRaw);
                ba = _cache.acquire();
                byte[] buf = ba.getData();
                int read = -1;
                while ((read = _in.read(buf)) != -1) {
                    if (HTTPResponseOutputStream.this._log.shouldLog(10)) {
                        HTTPResponseOutputStream.this._log.debug("Read " + read + " and writing it to the browser/streams");
                    }
                    this._out.write(buf, 0, read);
                    this._out.flush();
                    written += (long)read;
                }
                if (HTTPResponseOutputStream.this._log.shouldLog(20)) {
                    HTTPResponseOutputStream.this._log.info("Decompressed: " + written + ", " + _in.getTotalRead() + "/" + _in.getTotalExpanded());
                }
            }
            catch (IOException ioe) {
                if (HTTPResponseOutputStream.this._log.shouldLog(30)) {
                    HTTPResponseOutputStream.this._log.warn("Error decompressing: " + written + ", " + _in.getTotalRead() + "/" + _in.getTotalExpanded(), ioe);
                }
            }
            catch (OutOfMemoryError oom) {
                HTTPResponseOutputStream.this._log.error("OOM in HTTP Decompressor", oom);
            }
            finally {
                if (HTTPResponseOutputStream.this._log.shouldLog(20) && _in != null) {
                    HTTPResponseOutputStream.this._log.info("After decompression, written=" + written + " read=" + _in.getTotalRead() + ", expanded=" + _in.getTotalExpanded() + ", remaining=" + _in.getRemaining() + ", finished=" + _in.getFinished());
                }
                if (ba != null) {
                    _cache.release(ba);
                }
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (_in != null) {
                double compressed = _in.getTotalRead();
                double expanded = _in.getTotalExpanded();
                ReusableGZIPInputStream.release(_in);
                if (compressed > 0.0 && expanded > 0.0) {
                    double ratio = compressed / expanded;
                    HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressionRatio", (int)(100.0 * ratio), 0L);
                    HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpCompressed", (long)compressed, 0L);
                    HTTPResponseOutputStream.this._context.statManager().addRateData("i2ptunnel.httpExpanded", (long)expanded, 0L);
                }
            }
        }
    }
}

